;**************************************
;* EXAMPLE PROGRAM FOR ET-LAB3A       *
;* DESCRIPTION : CLOSE LOOP CONTROL   *
;* COMPILER    : SXA51                *
;**************************************
            ORG     0000H             ;reset vector
            LJMP    MAIN

            ORG     001BH             ;timer1 interrupt
            LJMP    TIMER1_INT

PORT_LCD    EQU     P1                ;Port  LCD
E_LCD       EQU     PORT_LCD.2        ;Enable LCD
WR_LCD      EQU     PORT_LCD.1        ;WR LCD
RS_LCD      EQU     PORT_LCD.0        ;RS Select LCD 

MS:         DS      1
PV:         DS      1
SETP:       DS      1
MV:         DS      1 

MAIN:       MOV     SP,#256-32

            LCALL   DELAY
            LCALL   INIT_LCD           ;initial LCD

            MOV     P3,#0FEH
            SETB    ET1
            MOV     TMOD,#15H

            MOV     SETP,#20

LOOP:
            MOV     TH1,#0F3H
            MOV     TL1,#0FFH
            MOV     TH0,#00H
            MOV     TL0,#00H

            MOV     MS,#0
            SETB    TR0
            SETB    TR1
            SETB    EA

SAMAGAIN:   MOV     A,MS
            CJNE    A,#250,SAMPLING    ;WAIL UNTIL 500 ms
SAMPLING:   JC      SAMAGAIN

            CLR     EA
            CLR     TR0
            CLR     TR1

            MOV     PV,TL0

            MOV     A,SETP
            CLR     C
            SUBB    A,PV
            RR      A
            ADD     A,MV
            JNB     ACC.7,NEG
            MOV     A,#0
NEG:        CJNE    A,#150,CKMORE     
CKMORE:     JC      GO
            MOV     A,#150
GO:         MOV     MV,A
            MOV     P0,MV

            MOV     A,#0
            LCALL   GOTOLCD

            MOV     DPTR,#SP_TAB         ;SHOW TEXT
SSP2:       MOV     A,#0
            MOVC    A,@A+DPTR
            CJNE    A,#0DH,SSP
            LJMP    SSP1
SSP:        LCALL   WRITE_DATA
            INC     DPTR
            LJMP    SSP2

SSP1:       MOV     A,#06
            LCALL   GOTOLCD

            MOV     A,PV
            CJNE    A,#99,LP1             ;NOT MORE THAN TABLE
LP1:        JC      LP2
            MOV     A,#99

LP2:        MOV     DPTR,#HEXDEC          ;HEX TO DEC  
            MOVC    A,@A+DPTR 

            PUSH    ACC
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WRITE_DATA             ;SHOW SPEED

            POP     ACC
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WRITE_DATA        ;SHOW SPEED

            LJMP    LOOP


TIMER1_INT: INC     MS
            MOV     TH1,#0F3H
            MOV     TL1,#0FFH
            RETI

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WRITE_INS:  MOV     B,A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            RET

WRITE_DATA: MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            RET 

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H       
            LCALL   WRITE_INS
            MOV     A,#32H       
            LCALL   WRITE_INS
            MOV     A,#28H        
            LCALL   WRITE_INS         
            MOV     A,#01H
            LCALL   WRITE_INS         
            MOV     A,#02H          
            LCALL   WRITE_INS          
            MOV     A,#0FH         
            LCALL   WRITE_INS          
            RET


GOTOLCD:    SETB   ACC.7
            LCALL  WRITE_INS
            RET

;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     SETB    E_LCD           ;Enable LCD
            LCALL   BUSY            ;Busy delay time
            CLR     E_LCD           ;Disable LCD
            LCALL   BUSY
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#05H
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET

;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    07H
            PUSH    06H
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            POP     06H
            POP     07H
            RET

HEXASC:     CJNE    A,#0AH,CKLESS
CKLESS:     JNC     MORETHAN
            ADD     A,#30H
            RET
MORETHAN:   ADD     A,#37H
            RET

HEXDEC:     DB        00H,01H,02H,03H,04H,05H,06H,07H,08H,09H
            DB        10H,11H,12H,13H,14H,15H,16H,17H,18H,19H
            DB        20H,21H,22H,23H,24H,25H,26H,27H,28H,29H
            DB        30H,31H,32H,33H,34H,35H,36H,37H,38H,39H
            DB        40H,41H,42H,43H,44H,45H,46H,47H,48H,49H
            DB        50H,51H,52H,53H,54H,55H,56H,57H,58H,59H
            DB        60H,61H,62H,63H,64H,65H,66H,67H,68H,69H
            DB        70H,71H,72H,73H,74H,75H,76H,77H,78H,79H
            DB        80H,81H,82H,83H,84H,85H,86H,87H,88H,89H
            DB        90H,91H,92H,93H,94H,95H,96H,97H,85H,99H

SP_TAB:     DB      'SPEED       RPS',0DH

            END
   
