unit segment;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Mask;

type
    Data_Type = ARRAY[0..16] OF BYTE;
    Data_Seg  = ARRAY[0..9] OF BYTE;
    Show_Seg  = ARRAY[0..4] OF BYTE;

    TForm7Segment = class(TForm)
    GroupBoxPort: TGroupBox;
    RadioButtonLpt1: TRadioButton;
    RadioButtonLpt2: TRadioButton;
    MaskEditDelay: TMaskEdit;
    Label1: TLabel;
    GroupBox2: TGroupBox;
    MaskEdit7Segment1: TMaskEdit;
    Timer1: TTimer;
    ButtonOK: TButton;
    MaskEdit7Segment2: TMaskEdit;
    MaskEdit7Segment3: TMaskEdit;
    MaskEdit7Segment4: TMaskEdit;
    ButtonCancel: TButton;
    procedure FormCreate(Sender: TObject);
    procedure RadioButtonLpt1Click(Sender: TObject);
    procedure RadioButtonLpt2Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
    procedure MaskEditDelayChange(Sender: TObject);
    procedure ButtonCancelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form7Segment: TForm7Segment;

  T,A,E,Port_Number,Control_Byte,Data_Byte,Control_Lines : BYTE;
                 Base_Addr_LO_Nibble,Base_Addr_HI_Nibble : BYTE;
                                          LPTX,Data_Word : WORD;
                                          Inverted_Logic : Data_Type;
                                                 DataSeg : Data_Seg;
                                                 ShowSeg : Show_Seg;


  procedure Generate_Data(var Inverted_Logic:Data_Type);
  procedure Send_Control_Word(Control_BYTE:BYTE);
  procedure Send_Data(Data_Byte,Port_Number:BYTE);
  procedure Outport(Port:WORD;Data:BYTE);stdcall;external 'LPTDLL.DLL';
  function  Inport(Port:WORD):BYTE;      stdcall;external 'LPTDLL.DLL';


implementation

{$R *.DFM}

procedure Generate_Data(var Inverted_Logic:Data_Type);
var  Count,Temp,D0,D1,D2,D3:BYTE;
begin
      Count := 0;
      FOR D3 := 1 DOWNTO 0 DO
        FOR D2 := 0 TO 1 DO
          FOR D1 := 1 DOWNTO 0 DO
            FOR D0 := 1 DOWNTO 0 DO
            BEGIN
                 Temp  := (8*D3)+(4*D2)+(2*D1)+D0;
                 Inverted_Logic[Count] := Temp;
                 Count :=  Count+1;
            END;
end;



procedure Send_Control_Word(Control_BYTE:BYTE);
var  Temp:BYTE;
     TempA:WORD;
begin
      Base_Addr_LO_Nibble := $0F;
      Outport(LPTX,Base_Addr_LO_Nibble);
      Base_Addr_HI_Nibble := Control_Byte AND $F0;
      Outport(LPTX,(Base_Addr_HI_Nibble OR Base_Addr_LO_Nibble));

      Temp  := Control_Byte AND $0F;
      Temp  := Inverted_Logic[Temp];
      TempA := LPTX+2;
      Outport(TempA,Temp);

      Outport(LPTX,(Inport(LPTX) AND $F7)); {1111 0111 set write line to low}
      sleep(T);
      Outport(LPTX,(Inport(LPTX) OR  $08)); {0000 1000 set write line to high}
      sleep(T);
end;


{ Send Data_Byte to Port [Port Number] }
procedure Send_Data(Data_Byte,Port_Number:Byte);
var   Temp:BYTE;
      TempA:WORD;
begin
      Base_Addr_LO_Nibble := $0C OR Port_Number;
      Outport(LPTX,Base_Addr_LO_Nibble);
      Outport(LPTx,(Data_Byte AND $F0) OR Base_Addr_LO_Nibble);
      Temp := Data_Byte AND $0F;
      Temp := Inverted_Logic[Temp];
      TempA := LPTX+2;
      Outport(TempA,Temp);

      Outport(LPTX,Inport(LPTX) AND $F7); { 0000 0111 set write line to low}
      sleep(T);
      Outport(LPTX,Inport(LPTX) OR $08);  { 0000 1000 set write line to high}
      sleep(T);
end;



{Read data from selected port,invert inverted data on line D0,D1,D3 }
{Return, via Data_Byte,a correct reading byte of data               }
procedure Input_Data(var Data_Byte:BYTE;Port_Number:BYTE);
var   Temp:BYTE;
      TempA:WORD;
begin
      Base_Addr_LO_Nibble := $0C;                          { Initialize Control Line,    0000 1100 }
      Base_Addr_LO_Nibble := $0C OR Port_Number;           { Select port for input                 }
      Outport(LPTX,Base_Addr_LO_Nibble);                   { 0000 1101                             }
      Outport(LPTX,Inport(LPTX) AND $0B);                  { Rd line = LOW;              0000 1001 }
      TempA := LPTX+2;
      Outport(TempA,$04);                                  { set all line high for read; 0000 0100 }

      Data_Byte := Inport(TempA) AND $0F;
      TempA := LPTX+1;
      Data_Byte := Data_Byte OR (Inport(TempA) AND $F0);

      Outport(LPTX,Base_Addr_LO_Nibble);

      Temp := Data_Byte AND $0F;
      Temp := Inverted_Logic[Temp];
      Data_Byte := (Data_Byte AND $F0) OR Temp;
end;


procedure TForm7Segment.FormCreate(Sender: TObject);
begin
        LPTX := $378;
        T := strtoint(MaskEditDelay.text);
        Generate_Data(Inverted_Logic);
        Send_Control_Word($80);

        DataSeg[0] := $3F;
        DataSeg[1] := $06;
        DataSeg[2] := $5B;
        DataSeg[3] := $4F;
        DataSeg[4] := $66;
        DataSeg[5] := $6D;
        DataSeg[6] := $7D;
        DataSeg[7] := $07;
        DataSeg[8] := $7F;
        DataSeg[9] := $6F;

end;

procedure TForm7Segment.RadioButtonLpt1Click(Sender: TObject);
begin
        LPTX := $378;
end;

procedure TForm7Segment.RadioButtonLpt2Click(Sender: TObject);
begin
        LPTX := $278;
end;

procedure Scan7Seg();
var cnt:BYTE;
begin
      FOR cnt := 0 TO 3 DO
      BEGIN
            Send_Data(ShowSeg[cnt],0);
            Send_Data(cnt,1);
            Send_Data($00,0);
      END;
end;

procedure TForm7Segment.Timer1Timer(Sender: TObject);
begin
       Scan7Seg();
end;

procedure TForm7Segment.ButtonOKClick(Sender: TObject);
var C1,C2,C3,C4:BYTE;
begin
       C1 := strtoint(MaskEdit7Segment1.text);
       C2 := strtoint(MaskEdit7Segment2.text);
       C3 := strtoint(MaskEdit7Segment3.text);
       C4 := strtoint(MaskEdit7Segment4.text);
       ShowSeg[0] := DataSeg[C1];
       ShowSeg[1] := DataSeg[C2];
       ShowSeg[2] := DataSeg[C3];
       ShowSeg[3] := DataSeg[C4];

       Timer1.Enabled := True;
end;


procedure TForm7Segment.MaskEditDelayChange(Sender: TObject);
begin
      T := strtoint(MaskEditDelay.text);
end;


procedure TForm7Segment.ButtonCancelClick(Sender: TObject);
begin
         Timer1.Enabled := False;
end;

end.
