;*************************************
;* examples program for ET-LAB3A     *
;* description : write ascii to lcd  *
;* compiler    : reads51             *
;*************************************

#include <sfr51.inc>

PORT_LCD    EQU     P1              ;Port  LCD
E_LCD       bit     PORT_LCD.2      ;Enable LCD
WR_LCD      bit     PORT_LCD.1      ;WR LCD
RS_LCD      bit     PORT_LCD.0      ;RS Select LCD 

            ORG     0000H
MAIN:       MOV     SP,#256-32      ;Initial Stack 32 Byte

            LCALL   DELAY           ;initial delay

            LCALL   INIT_LCD        ;initial LCD

            MOV     A,#41H
            LCALL   WRITE_DATA

            LJMP    $

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WRITE_INS:  MOV     B,A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            RET

WRITE_DATA: MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            RET 

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H       
            LCALL   WRITE_INS
            MOV     A,#32H       
            LCALL   WRITE_INS
            MOV     A,#28H        
            LCALL   WRITE_INS         
            MOV     A,#01H
            LCALL   WRITE_INS         
            MOV     A,#02H          
            LCALL   WRITE_INS          
            MOV     A,#0FH         
            LCALL   WRITE_INS          
            RET
;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     SETB    E_LCD           ;Enable LCD
            LCALL   BUSY            ;Busy delay time
            CLR     E_LCD           ;Disable LCD
            LCALL   BUSY
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#0B0H
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET

;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    07H
            PUSH    06H
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            POP     06H
            POP     07H
            RET

            END

