;******************************************
;* examples program for ET-LAB3A          *
;* description : scan key 4 x 4           *
;* compiler    : reads51                  *
;******************************************

#include <sfr51.inc>

            ORG     0000H
            LJMP    RESET_VEC       ;reset vector

PORT_LCD    EQU     P1              ;Port  LCD
E_LCD       bit     PORT_LCD.2      ;Enable LCD
WR_LCD      bit     PORT_LCD.1      ;WR LCD
RS_LCD      bit     PORT_LCD.0      ;RS Select LCD 

            ORG     25H
BUF:        DS      1
SCAN_CODE:  DS      1
IN_CODE:    DS      1


RESET_VEC:  MOV     SP,#256-32      ;stack 32 byte       
            LCALL   INIT_LCD

LOOP_MAIN:  LCALL   SCAN_KEY
            MOV     A,SCAN_CODE 
            MOV     BUF,A     
            CJNE    A,#12,CKFLAG
CKFLAG:     JNC     LOOP_END
            LCALL   DELAY
            LCALL   SCAN_KEY
            MOV     A,SCAN_CODE
            CJNE    A,BUF,LOOP_END

            MOV     A,#0
            LCALL   GOTOLCD
            MOV     DPTR,#ASCII
            MOV     A,SCAN_CODE
            MOVC    A,@A+DPTR
            LCALL   WRITE_DATA

LOOP_END:   LJMP    LOOP_MAIN



SCAN_KEY:   MOV     R7,#3
            MOV     SCAN_CODE,#0
            MOV     DPTR,#CHECK_CODE
LOOP1:      MOV     A,#0 
            MOVC    A,@A+DPTR
            MOV     P0,A
            MOV     A,P0
            SWAP    A
            ANL     A,#0FH
            MOV     IN_CODE,A

            MOV     R2,#4
LOOP:       MOV     A,IN_CODE
            CLR     C
            RRC     A
            JC      SKIP
            RET
SKIP:       MOV     A,IN_CODE
            RR      A
            MOV     IN_CODE,A
            INC     SCAN_CODE     
            DJNZ    R2,LOOP

            INC     DPTR
            DJNZ    R7,LOOP1

            RET


CHECK_CODE: DB      0F6H,0F5H,0F3H
ASCII:      DB      "1","4","7","A","2","5","8","0","3","6","9","B"


WRITE_INS:  MOV     B,A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            RET

WRITE_DATA: MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            RET


GOTOLCD:    SETB   ACC.7
            LCALL  WRITE_INS
            RET

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H       
            LCALL   WRITE_INS
            MOV     A,#32H       
            LCALL   WRITE_INS
            MOV     A,#28H        
            LCALL   WRITE_INS         
            MOV     A,#01H
            LCALL   WRITE_INS         
            MOV     A,#02H          
            LCALL   WRITE_INS          
            MOV     A,#0FH         
            LCALL   WRITE_INS          
            RET
;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     SETB    E_LCD           ;Enable LCD
            LCALL   BUSY            ;Busy delay time
            CLR     E_LCD           ;Disable LCD
            LCALL   BUSY
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#0B0H
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET

;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    07H
            PUSH    06H
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            POP     06H
            POP     07H
            RET



            END













