;****************************************
;* examples program for ET-LAB3A        *
;* description : scan dot-matrix led    *
;* compiler    : reads51                *
;****************************************

#include <sfr51.inc>

PORT_DSP       EQU   P1

COL_RESET      bit   PORT_DSP.0
COL_SHIFT      bit   PORT_DSP.1
COL_LATCH      bit   PORT_DSP.2
COL_ENABLE     bit   PORT_DSP.3
COL_DATA       bit   PORT_DSP.5

ROW_ENABLE     bit   PORT_DSP.4
ROW_RESET      bit   PORT_DSP.6
ROW_DATA       bit   PORT_DSP.7


               ORG   0000H                ;reset vector
MAIN:          MOV   SP,#256-32           ;stack 32 byte


LOOP:          LCALL SCAN_DSP
               SJMP  LOOP

SCAN_DSP:      SETB  COL_RESET
               CLR   ROW_ENABLE
               SETB  ROW_RESET
               CLR   ROW_RESET

               MOV   B,#7
SCAN_DSP1:     SETB  COL_ENABLE
               MOV   A,#0FFH
               CPL   A
               LCALL SER_OUT
               MOV   A,#0FFH
               CPL   A
               LCALL SER_OUT
               SETB  COL_LATCH
               CLR   COL_LATCH
               SETB  ROW_DATA
               CLR   ROW_DATA
               CLR   COL_ENABLE
               MOV   R5,#1
SCAN_DSP2:     MOV   R6,#00H
               DJNZ  R6,$
               DJNZ  R5,SCAN_DSP2
               DJNZ  B,SCAN_DSP1
               SETB  ROW_DATA
               CLR   ROW_DATA
               SETB  ROW_ENABLE
               RET
               
;**********************************************
;*           shift serial data out            *
;**********************************************
SER_OUT:       MOV   R2,#8
               CLR   C
SHF_OUT:       RRC   A
               MOV   COL_DATA,C
               NOP
               NOP
               SETB  COL_SHIFT
               NOP
               NOP
               CLR   COL_SHIFT
               NOP
               NOP
               DJNZ  R2,SHF_OUT
               RET

               END





