;*****************************************
;* examples program for ET-LAB3A         *
;* escription : control PCF8574A         *
;* compiler   : reads51                  *
;*****************************************

#include <sfr51.inc>

SCL         bit     P0.0
SDA         bit     P0.1

ADD_BW      EQU     074H            ;ADDRESS FOR WRITE
ADD_BR      EQU     075H            ;ADDRESS FOR READ
   
             dseg  at 25H
DATA_BYTE:   DS      1
             end

            cseg  at 0
RESET_VEC:  MOV     SP,#256-32      ;stack 32 byte 
  

INIT_PORT:  SETB    SCL
            SETB    SDA

            mov     p1,#0

            LCALL   DELAY           ;initial delay

loopx:      mov     r7,#8
            MOV     DATA_BYTE,#0feh
lx:         LCALL   WRITE_BYTE
            lcall   delay
            mov     a,DATA_BYTE
            setb    c
            rlc     a
            mov     DATA_BYTE,a
            djnz    r7,lx
            ljmp    loopx
            


;*****************************************************
;*            WRITE DATA TO EEPROM 1 BYTE            *
;*      : DATA                                       *
;*****************************************************
WRITE_BYTE: CLR     SDA                    ;start bit
            LCALL   TDEL
            CLR     SCL

            MOV     A,#ADD_BW              ;send control byte
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,WRITE_BYTE         ;loop until busy
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL

            setb    p1.0

            MOV     A,DATA_BYTE                 ;send data
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,WRITE_BYTE         ;loop until busy
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL
            CLR     SDA

            setb    p1.1

            SETB    SCL                    ;stop bit
            LCALL   TDEL
            SETB    SDA
            LCALL   TDEL
            RET


;****************************************************
;*                      WRITE                       *
;* INPUT: ACC                                       *
;****************************************************
PUT_BYTE:   PUSH    02H
            MOV     R2,#08H
PUT1:       RLC     A
            MOV     SDA,C
            SETB    SCL
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL
            DJNZ    R2,PUT1
            POP     02H
            RET

;*                     delay
;***************************************************
DELAY4M:    PUSH    DPH
            PUSH    DPL
            MOV     DPTR,#0000H
DEL4:       INC     DPTR
            MOV     A,DPL
            ORL     A,DPH
            JNZ     DEL4
            POP     DPL
            POP     DPH
            RET



;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    DPH
            PUSH    DPL
            PUSH    ACC
            MOV     DPTR,#0000H
DEL:        INC     DPTR
            MOV     A,DPL
            ORL     A,DPH
            JNZ     DEL
            POP     ACC
            POP     DPL
            POP     DPH
            RET



TDEL:       NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            RET

            END














