;****************************************
;* examples program for ET-LAB3A        *
;* description : read thermister & ldr  *
;* compiler    : reads51                *
;****************************************

#include <sfr51.inc>

PORT_LCD    EQU     P1              ;Port  LCD
E_LCD       bit     PORT_LCD.2      ;Enable LCD
WR_LCD      bit     PORT_LCD.1      ;WR LCD
RS_LCD      bit     PORT_LCD.0      ;RS Select LCD 

ADC_PORT    EQU     P0
CLK         bit     ADC_PORT.2
CS          bit     ADC_PORT.3
DIN         bit     ADC_PORT.0 
DOUT        bit     ADC_PORT.4


ADC_DATA:   DS      1

            ORG     0000H           ;reset vector 
            MOV     SP,#256-32      ;stack 32 byte  
 
            CLR     WR_LCD          ;write LCD
            SETB    E_LCD           ;initial LCD

INIT_PORT:  CLR     CLK
            SETB    CS
            SETB    DIN
            SETB    DOUT


            LCALL   DELAY           ;initial delay

            LCALL   INIT_LCD        ;initial LCD

            MOV     DPTR,#TEXT_TAB
SSP2:       MOV     A,#0
            MOVC    A,@A+DPTR
            CJNE    A,#0DH,SSP1
            LJMP    ADC
SSP1:       LCALL   WRITE_DATA
            INC     DPTR 
            LJMP    SSP2 


ADC:        LCALL   ADC1

            MOV     A,#40h
            LCALL   GOTOLCD

            MOV     A,ADC_DATA
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WRITE_DATA
            MOV     A,ADC_DATA
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WRITE_DATA

            LCALL   ADC2

            MOV     A,#47h
            LCALL   GOTOLCD

            MOV     A,ADC_DATA
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WRITE_DATA
            MOV     A,ADC_DATA
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WRITE_DATA

            LJMP    ADC


ADC1:       SETB    DIN           ;START
            CLR     CS
            SETB    CLK
            LCALL   CLK_DELAY
            CLR     CLK
            LCALL   CLK_DELAY

            SETB    DIN           ;SGL/DIF
            SETB    CLK
            LCALL   CLK_DELAY
            CLR     CLK
            LCALL   CLK_DELAY

            CLR     DIN           ;ODD/SIGN
            NOP
            SETB    CLK
            LCALL   CLK_DELAY
            CLR     CLK
            LCALL   CLK_DELAY

            SETB    CLK
            LCALL   CLK_DELAY
            CLR     CLK
            LCALL   CLK_DELAY 

            SETB    CLK
            LCALL   CLK_DELAY

            MOV     R2,#8
LOOP_MSB1:  CLR     CLK
            NOP
            MOV     C,DOUT
            LCALL   CLK_DELAY
            SETB    CLK
            LCALL   CLK_DELAY
            RLC     A
            DJNZ    R2,LOOP_MSB1
            MOV     ADC_DATA,A

            MOV     R2,#8
LOOP_LSB1:  CLR     CLK
            LCALL   CLK_DELAY
            CLR     CLK
            LCALL   CLK_DELAY
            DJNZ    R2,LOOP_LSB1

            LCALL   CLK_DELAY
            LCALL   CLK_DELAY
            LCALL   CLK_DELAY

            SETB    CS

            RET



ADC2:       SETB    DIN           ;START
            CLR     CS
            SETB    CLK
            LCALL   CLK_DELAY
            CLR     CLK
            LCALL   CLK_DELAY

            SETB    DIN           ;SGL/DIF
            SETB    CLK
            LCALL   CLK_DELAY
            CLR     CLK
            LCALL   CLK_DELAY

            SETB    DIN           ;ODD/SIGN
            NOP
            SETB    CLK
            LCALL   CLK_DELAY
            CLR     CLK
            LCALL   CLK_DELAY

            SETB    CLK
            LCALL   CLK_DELAY
            CLR     CLK
            LCALL   CLK_DELAY 

            SETB    CLK
            LCALL   CLK_DELAY

            MOV     R2,#8
LOOP_MSB2:  CLR     CLK
            NOP
            MOV     C,DOUT
            LCALL   CLK_DELAY
            SETB    CLK
            LCALL   CLK_DELAY
            RLC     A
            DJNZ    R2,LOOP_MSB2
            MOV     ADC_DATA,A

            MOV     R2,#8
LOOP_LSB2:  CLR     CLK
            LCALL   CLK_DELAY
            CLR     CLK
            LCALL   CLK_DELAY
            DJNZ    R2,LOOP_LSB2

            LCALL   CLK_DELAY
            LCALL   CLK_DELAY
            LCALL   CLK_DELAY

            SETB    CS
            RET




CLK_DELAY:  PUSH  7
            MOV   R7,#25
            DJNZ  R7,$
            POP   7
            RET

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WRITE_INS:  MOV     B,A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            RET

;**********************************************
;*          WRITE DATA
;**********************************************
WRITE_DATA: MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            RET 

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H       
            LCALL   WRITE_INS
            MOV     A,#32H       
            LCALL   WRITE_INS
            MOV     A,#28H        
            LCALL   WRITE_INS         
            MOV     A,#01H
            LCALL   WRITE_INS         
            MOV     A,#02H          
            LCALL   WRITE_INS          
            MOV     A,#0EH         
            LCALL   WRITE_INS          
            RET

;****************************************************
;*
;****************************************************
GOTOLCD:    SETB   ACC.7
            LCALL  WRITE_INS
            RET

;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     SETB    E_LCD           ;Enable LCD
            LCALL   BUSY            ;Busy delay time
            CLR     E_LCD           ;Disable LCD
            LCALL   BUSY
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#05H
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET


;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    DPH
            PUSH    DPL
            PUSH    ACC
            MOV     DPTR,#0000H
DEL:        INC     DPTR
            MOV     A,DPL
            ORL     A,DPH
            JNZ     DEL
            POP     ACC
            POP     DPL
            POP     DPH
            RET

HEXASC:     CJNE    A,#10,CHECK
CHECK:      JNC     MORE
            ADD     A,#30H
            RET
MORE:       ADD     A,#37H 
            RET

TEXT_TAB:   DB      "NTC    LDR",0DH

            END


