;*****************************************
;* examples program for ET-LAB3A         *
;* description : read ID from DS1990A    *
;* compiler    : reads51                 *
;*****************************************

#include <sfr51.inc>

DATA_BIT     bit     P0.0

PORT_LCD     EQU     P1                ;Port  LCD
E_LCD        bit     PORT_LCD.2        ;Enable LCD
WR_LCD       bit     PORT_LCD.1        ;WR LCD
RS_LCD       bit     PORT_LCD.0        ;RS Select LCD 


             dseg at 25H
BUFFER:      DS      10
             end

             cseg at 0
MAIN:        MOV     SP,#256-32    ; Initial Stack 32 Byte
             CLR     EA

             LCALL   DELAY
             LCALL   INIT_LCD           ;initial LCD

TRESET:      LCALL   TOUCHRESET
             JNC     TRESET   

             MOV     A,#33H        ;READ ROM
             LCALL   TOUCHBYTE     

             MOV     R7,#8
             MOV     R0,#BUFFER
LOOP:        MOV     A,#0FFH
             LCALL   TOUCHBYTE
             MOV     @R0,A
             INC     R0
             DJNZ    R7,LOOP

             MOV     R2,#8
             MOV     R0,#BUFFER

LOOP1:       MOV     A,@R0
             PUSH    02 

             PUSH    ACC
             SWAP    A
             ANL     A,#0FH
             LCALL   HEXASC
             LCALL   WRITE_DATA

             POP     ACC
             ANL     A,#0FH
             LCALL   HEXASC
             LCALL   WRITE_DATA

             INC     R0

             POP     02
             DJNZ    R2,LOOP1

             LJMP    $


TOUCHRESET:
             PUSH   ACC                 ;     SAVE THE ACCUMULATOR
             MOV    A,#12               ;     LOAD OUTER LOOP VARIABLE
             CLR    DATA_BIT            ;     START THE RESET PULSE 
             MOV    R1,#3               ;
DELRESET:    MOV    R2,#245             ;2.   SET TIME INTERVAL
             DJNZ   R2,$                ;490. WAIT WITH DATA LOW
             DJNZ   R1,DELRESET         ;
             SETB   DATA_BIT            ;1.   RELEASE DATA LINE
             MOV    B,#20               ;2.   SET TIME INTERVAL
             CLR    C                   ;1.   CLEAR PRESENCE FLAG
WAITLOW:
             JB     DATA_BIT,WH         ;EXIT LOOP IF LINE HIGH
             DJNZ   B,WAITLOW           ;HANG AROUND FOR 3360
             DJNZ   ACC,WAITLOW         ;US IF LINE IS LOW
             SJMP   SHORT               ;LINE COULD NOT GO HIGH
WH:
             MOV    R1,#255             ;DELAY FOR PRESENCE DETECT
HL:
             ORL    C,/DATA_BIT         ;2.   CATCH PRESENCE PULSE
             DJNZ   R1,HL               ;510  WAIT WITH DATA HIGH
SHORT:
             POP    ACC                 ;RESTORE ACCUMULATOR
             RET                        ;RETURN



TOUCHBYTE:
             PUSH   B                   ;SAVE THE B REGISTER
             MOV    B,#8                ;SETUP FOR 8 BIT
BIT_LOOP:
             RRC    A                   ;GET BIT IN CARRY
             LCALL  TOUCHBIT            ;SEND BIT
             DJNZ   B,BIT_LOOP          ;GET NEXT BIT
             RRC    A                   ;GET FINAL BIT IN ACC
             POP    B                   ;RESTORE B REGISTER
             RET                        ;RETURN TO CALLER


TOUCHBIT:    CLR   DATA_BIT             ;1.     START THE TIME SLOT
             MOV   R1,#4                ;1.
             DJNZ  R1,$                 ;2 X 4  DELAY ~ 3 US

             MOV   DATA_BIT,C           ;1      SEND OUT THE DATA BIT
             MOV   R1,#10               ;1
             DJNZ  R1,$                 ;2 X 10 DELAY ~ 7 US

             MOV   C,DATA_BIT           ;1      SAMPLE INPUT DATA BIT
             MOV   R1,#90               ;1
             DJNZ  R1,$                 ;2 X 90 DELAY ~ 59 US
             SETB  DATA_BIT             ;TERMINATE TIME SLOT
             RET

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WRITE_INS:  MOV     B,A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            RET

WRITE_DATA: MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.0
            MOV     P1,A
            LCALL   EN_LCD
            RET 

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H       
            LCALL   WRITE_INS
            MOV     A,#32H       
            LCALL   WRITE_INS
            MOV     A,#28H        
            LCALL   WRITE_INS         
            MOV     A,#01H
            LCALL   WRITE_INS         
            MOV     A,#02H          
            LCALL   WRITE_INS          
            MOV     A,#0FH         
            LCALL   WRITE_INS          
            RET


GOTOLCD:    SETB   ACC.7
            LCALL  WRITE_INS
            RET

;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     SETB    E_LCD           ;Enable LCD
            LCALL   BUSY            ;Busy delay time
            CLR     E_LCD           ;Disable LCD
            LCALL   BUSY
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#05H
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET

;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    07H
            PUSH    06H
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            POP     06H
            POP     07H
            RET


HEXASC:     CJNE    A,#0AH,HEX
HEX:        JNC     MORE
            ADD     A,#30H
            RET
MORE:       ADD     A,#37H
            RET

            END




