;****************************************************
;* examples program for ET-LAB3A                    *
;* description : show character on dot-matrix led   *
;* compiler    : reads51                            * 
;****************************************************

#include <sfr51.inc>

PORT_DSP       EQU   P1

COL_RESET      bit   PORT_DSP.0
COL_SHIFT      bit   PORT_DSP.1
COL_LATCH      bit   PORT_DSP.2
COL_ENABLE     bit   PORT_DSP.3
COL_DATA       bit   PORT_DSP.5

ROW_ENABLE     bit   PORT_DSP.4
ROW_RESET      bit   PORT_DSP.6
ROW_DATA       bit   PORT_DSP.7

               dseg at 20H
DSP_BUFF:      ds   14
DATA_INX:      ds   1
INX_BUFF:      ds   3
               end 

               cseg at 0
MAIN:          MOV   SP,#256-32             ;stack 32 byte

               MOV   R2,#14
               MOV   R0,#DSP_BUFF
               CLR   A

CLR_BUFF:      MOV   @R0,A
               INC   R0
               DJNZ  R2,CLR_BUFF
               
               MOV   INX_BUFF+0,#0
               MOV   INX_BUFF+1,#1
               MOV   INX_BUFF+2,#2

               LCALL UNPK_DSP

LOOP:          LCALL SCAN_DSP
               SJMP  LOOP

UNPK_DSP:      MOV   DPTR,#TAB_FONT
               MOV   A,INX_BUFF+0
               MOV   B,#7
               MUL   AB
               CLR   C
               ADDC  A,DPL
               MOV   DPL,A
               MOV   A,B
               ADDC  A,DPH
               MOV   DPH,A

               MOV   R2,#7
               MOV   R0,#DSP_BUFF+0

UNPK_DAT1:     CLR   A
               MOVC  A,@A+DPTR
               MOV   @R0,A
               INC   R0
               INC   DPTR
               DJNZ  R2,UNPK_DAT1

               MOV   DPTR,#TAB_FONT
               MOV   A,INX_BUFF+1
               MOV   B,#7
               MUL   AB
               CLR   C
               ADDC  A,DPL
               MOV   DPL,A
               MOV   A,B
               ADDC  A,DPH
               MOV   DPH,A

               MOV   R2,#7
               MOV   R0,#DSP_BUFF+0

UNPK_DAT2:     CLR   A
               MOVC  A,@A+DPTR
               RR    A
               RR    A
               RR    A
               RR    A
               RR    A
               ANL   A,#00000111B
               ORL   A,@R0
               MOV   @R0,A
               INC   R0
               INC   DPTR
               DJNZ  R2,UNPK_DAT2

               MOV   DPTR,#TAB_FONT
               MOV   A,INX_BUFF+1
               MOV   B,#7
               MUL   AB
               CLR   C
               ADDC  A,DPL
               MOV   DPL,A
               MOV   A,B
               ADDC  A,DPH
               MOV   DPH,A

               MOV   R2,#7
               MOV   R0,#DSP_BUFF+7

UNPK_DAT3:     CLR   A
               MOVC  A,@A+DPTR
               RL    A
               RL    A
               RL    A
               ANL   A,#11000000B
               MOV   @R0,A
               INC   R0
               INC   DPTR
               DJNZ  R2,UNPK_DAT3

               MOV   DPTR,#TAB_FONT
               MOV   A,INX_BUFF+2
               MOV   B,#7
               MUL   AB
               CLR   C
               ADDC  A,DPL
               MOV   DPL,A
               MOV   A,B
               ADDC  A,DPH
               MOV   DPH,A

               MOV   R2,#7
               MOV   R0,#DSP_BUFF+7

UNPK_DAT4:     CLR   A
               MOVC  A,@A+DPTR
               RR    A
               RR    A
               ANL   A,#00111111B
               ORL   A,@R0
               MOV   @R0,A
               INC   R0
               INC   DPTR
               DJNZ  R2,UNPK_DAT4
               RET


SCAN_DSP:      SETB  COL_RESET
               CLR   ROW_ENABLE
               SETB  ROW_RESET
               CLR   ROW_RESET

               MOV   R0,#DSP_BUFF+0
               MOV   R1,#DSP_BUFF+7
               MOV   B,#7
SCAN_DSP1:     SETB  COL_ENABLE
               MOV   A,@R1
               CPL   A
               LCALL SER_OUT
               MOV   A,@R0
               CPL   A
               LCALL SER_OUT
               SETB  COL_LATCH
               CLR   COL_LATCH
               SETB  ROW_DATA
               CLR   ROW_DATA
               CLR   COL_ENABLE
               MOV   R5,#1
SCAN_DSP2:     MOV   R6,#00H
               DJNZ  R6,$
               DJNZ  R5,SCAN_DSP2
               INC   R0
               INC   R1
               DJNZ  B,SCAN_DSP1
               SETB  ROW_DATA
               CLR   ROW_DATA
               SETB  ROW_ENABLE
               RET
               


SER_OUT:       MOV   R2,#8
               CLR   C
SHF_OUT:       RRC   A
               MOV   COL_DATA,C
               NOP
               NOP
               SETB  COL_SHIFT
               NOP
               NOP
               CLR   COL_SHIFT
               NOP
               NOP
               DJNZ  R2,SHF_OUT
               RET

TAB_FONT:      DB     11111000B
               DB     10000000B
               DB     11110000B
               DB     00001000B
               DB     00001000B
               DB     10001000B
               DB     01110000B


               DB     00000000B
               DB     00100000B
               DB     10101000B
               DB     01110000B
               DB     10101000B
               DB     00100000B
               DB     00000000B

               DB     11111000B
               DB     00001000B
               DB     00010000B
               DB     00100000B
               DB     01000000B
               DB     01000000B
               DB     01000000B



               END





