;********************************************
;* examples program for ET-LAB3A            *
;* description : read adc 4ch from pcf8591  *
;* compiler    : reads51                    *
;********************************************

#include <sfr51.inc>

SCL         bit     P0.0
SDA         bit     P0.1

ADD_BW      EQU     092H            ;ADDRESS FOR WRITE
ADD_BR      EQU     093H            ;ADDRESS FOR READ

PORT_LCD    EQU     P1              ;Port  LCD
E_LCD       bit     PORT_LCD.2      ;Enable LCD
WR_LCD      bit     PORT_LCD.1      ;WR LCD
RS_LCD      bit     PORT_LCD.0      ;RS Select LCD 

   
            dseg  at  25H
DATA_BYTE:  DS      1
CONTROL:    DS      1
            end  

            cseg at 0
RESET_VEC:  MOV     SP,#256-32
            CLR     EA

INIT_PORT:  SETB    SCL
            SETB    SDA

            CLR     WR_LCD          ;write LCD
            SETB    E_LCD           ;initial LCD

            LCALL   DELAY           ;initial delay

            LCALL   INIT_LCD        ;initial LCD


            MOV     DPTR,#TXT_TAB
NEXT_TXT:   MOV     A,#0
            MOVC    A,@A+DPTR
            JZ      LOOP
            LCALL   WR_DATA
            INC     DPTR
            SJMP    NEXT_TXT


LOOP:       MOV     CONTROL,#0
            LCALL   WRITE_CONG
             
            LCALL   READ_BYTE

            MOV     A,#4CH
            LCALL   GOTO_LCD

            MOV     A,DATA_BYTE
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA
            MOV     A,DATA_BYTE
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     CONTROL,#1
            LCALL   WRITE_CONG
             
            LCALL   READ_BYTE

            MOV     A,#40H
            LCALL   GOTO_LCD

            MOV     A,DATA_BYTE
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA
            MOV     A,DATA_BYTE
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     CONTROL,#2
            LCALL   WRITE_CONG
             
            LCALL   READ_BYTE

            MOV     A,#44H
            LCALL   GOTO_LCD

            MOV     A,DATA_BYTE
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA
            MOV     A,DATA_BYTE
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            MOV     CONTROL,#3
            LCALL   WRITE_CONG
             
            LCALL   READ_BYTE

            MOV     A,#48H
            LCALL   GOTO_LCD

            MOV     A,DATA_BYTE
            SWAP    A
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA
            MOV     A,DATA_BYTE
            ANL     A,#0FH
            LCALL   HEXASC
            LCALL   WR_DATA

            LJMP    LOOP

;*****************************************************
;*             write config
;*****************************************************
WRITE_CONG: CLR     SDA
            LCALL   TDEL
            CLR     SCL

            MOV     A,#ADD_BW
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,READ_BYTE
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL

            MOV     A,CONTROL
            LCALL   PUT_BYTE
            SETB    SCL
            JB      SDA,READ_BYTE
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL
            CLR     SDA

            SETB    SCL                    ;stop bit
            LCALL   TDEL
            SETB    SDA
            LCALL   TDEL

            RET

;*****************************************************
;*            WRITE DATA TO EEPROM 1 BYTE            *
;*      : DATA                                       *
;*****************************************************
WRITE_BYTE: CLR     SDA                    ;start bit
            LCALL   TDEL
            CLR     SCL

            MOV     A,#ADD_BW              ;send control byte
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,WRITE_BYTE         ;loop until busy
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL

            MOV     A,CONTROL             ;send address low
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,WRITE_BYTE         ;loop until busy
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL

            MOV     A,DATA_BYTE                 ;send data
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,WRITE_BYTE         ;loop until busy
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL
            CLR     SDA

            SETB    SCL                    ;stop bit
            LCALL   TDEL
            SETB    SDA
            LCALL   TDEL
            RET

;******************************************************
;*            READ DATA FROM EEPROM 1 BYTE            *
;* OUTPUT : DATA                                      *
;******************************************************
READ_BYTE:  CLR     SDA                    ;start
            LCALL   TDEL
            CLR     SCL

            MOV     A,#ADD_BR              ;send control byte
            LCALL   PUT_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,READ_BYTE          ;loop until busy
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL

            LCALL   GET_BYTE
            MOV     DATA_BYTE,A

            SETB    SDA
            SETB    SCL                    ;NO ACK
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL

            CLR     SDA

            SETB    SCL                   ;stop bit
            LCALL   TDEL
            SETB    SDA
            LCALL   TDEL
            RET


;****************************************************
;*                      WRITE                       *
;* INPUT: ACC                                       *
;****************************************************
PUT_BYTE:   PUSH    02H
            MOV     R2,#08H
PUT1:       RLC     A
            MOV     SDA,C
            SETB    SCL
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL
            DJNZ    R2,PUT1
            POP     02H
            RET

;*****************************************************
;*                       READ                        *
;* OUTPUT: ACC                                       *
;*****************************************************
GET_BYTE:   PUSH    02H
            MOV     R2,#08H
GET1:       SETB    SCL
            MOV     C,SDA
            LCALL   TDEL
            CLR     SCL
            LCALL   TDEL
            RLC     A
            DJNZ    R2,GET1
            POP     02H
            RET

;***************************************************
;*                     delay
;***************************************************
DELAY4M:    PUSH    DPH
            PUSH    DPL
            MOV     DPTR,#0000H
DEL4:       INC     DPTR
            MOV     A,DPL
            ORL     A,DPH
            JNZ     DEL4
            POP     DPL
            POP     DPH
            RET



;****************************************************
;*                Input  : ACC  (ASCII)             *
;*                Output : Data bus LCD             *
;****************************************************
WR_DATA:    MOV     B,A
            ANL     A,#0F0H
            ORL     A,#00000101B    ;RS/CS HI
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B
            ORL     A,R2
            MOV     PORT_LCD,A
            LCALL   EN_LCD
            MOV     A,B             ;Low byte
            SWAP    A
            ANL     A,#0F0H
            ORL     A,#00000101B
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B
            ORL     A,R2
            MOV     PORT_LCD,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WR_INS:     MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.2           ;E HI
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B    ;else bit
            ORL     A,R2
            MOV     PORT_LCD,A      ;High byte
            LCALL   EN_LCD
            MOV     A,B             ;Low byte
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.2
            MOV     R2,A
            MOV     A,PORT_LCD
            ANL     A,#00001000B
            ORL     A,R2
            MOV     PORT_LCD,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                 Goto position of LCD             *
;*                 Input : ACC (addr.)              *
;****************************************************
GOTO_LCD:   SETB    ACC.7
            LCALL   WR_INS
            RET

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H          ;Set DL = 1 3-time
            LCALL   WR_INS
            MOV     A,#32H          ;Clear DL = 0 1-time
            LCALL   WR_INS
            MOV     A,#28H          ;Function set
            LCALL   WR_INS          ;DL=0 4Bit,N=1 2Line,F=0 5X7
            MOV     A,#0CH
            LCALL   WR_INS          ;Entry display,cursor off,cursor not blink
            MOV     A,#06H          ;Entry mode set
            LCALL   WR_INS          ;I/D=1 Increment,S=0 cursor shift
            MOV     A,#01H          ;Clear display
            LCALL   WR_INS          ;Clear display,set DD RAM address=0
            RET
;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     CLR     E_LCD           ;Enable LCD
            LCALL   BUSY            ;Busy delay time
            SETB    E_LCD           ;Disable LCD
            RET


;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#0AH
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET

;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    DPH
            PUSH    DPL
            PUSH    ACC
            MOV     DPTR,#0000H
DEL:        INC     DPTR
            MOV     A,DPL
            ORL     A,DPH
            JNZ     DEL
            POP     ACC
            POP     DPL
            POP     DPH
            RET

HEXASC:     CJNE    A,#10,CHECK
CHECK:      JNC     MORE
            ADD     A,#30H
            RET
MORE:       ADD     A,#37H 
            RET

TXT_TAB:    DB      "CH1 CH2 CH3 CH4 ",00H


TDEL:       NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            RET

            END














