/**************************************/
/* example program for ET-LAB3A       */
/* description  : scan 4 x4 key       */
/* compiler     : keil c51            */
/**************************************/

/* include section */
#include <reg51f.h>
#include <stdio.h>
       
sbit  E  = P1^2;
sbit  RW = P1^1;
sbit  RS = P1^0;

char ascii[12] = {'1','4','7','A',
                  '2','5','8','0',
		 		  '3','6','9','B'};


/* pototype section */				  
void init_lcd();
void gotolcd(unsigned char);
void write_ins(unsigned char);
void write_data(unsigned char);
unsigned char key_scan();
void key_release();
void delay(char);

/*************************************/
/*           main program            */
/*************************************/
void main(void)
{
 unsigned char v1,v2;

 delay(10);
 init_lcd();
 
  while(1)
  {
    v1 = key_scan();
	if(v1 < 12)
	{
	   delay(1);
	   v2 = key_scan();

	   if(v1 == v2) 
	   {
	     gotolcd(0);
	     write_data(ascii[v2]);
   	     key_release(); 
	   }
	}
  } 
}


/************************************/
/*           key  release           */
/************************************/
void key_release(void)
{
  unsigned char kcode;
  
  P0 = 0xF8;

  do
  {
    kcode  = P0 & 0xf0; 
  }while(kcode != 0xf0);

 return;
}


/**********************************/
/*            scan key            */
/**********************************/
unsigned char key_scan(void)
{
  char scan_code = 0;
  char m,n;
  unsigned char in_code,a;
  unsigned char check_code[3] = {0xF6,0xF5,0xF3};
  char flag = 0;

  for(m = 0;(m < 3) && (flag == 0);m++)
  {
    P0 = check_code[m];
	in_code = P0;
    in_code >>= 4;  

	for(n=0;n<4;n++)
	{
	  a = in_code % 2;
	  if(a == 0) {flag = 1; break;};
	  in_code = in_code / 2;
      scan_code++;
	}
  }

 return scan_code;
}


/**************************************/
/*            initial LCD             */
/**************************************/
void init_lcd(void)
{
  write_ins(0x33);
  write_ins(0x32);
  write_ins(0x28);
  write_ins(0x08);
  write_ins(0x01);
  write_ins(0x02);
  write_ins(0x0f);

 return;
}


/****************************************/
/*              goto lcd                */
/****************************************/
void gotolcd(unsigned char i)
{
  i |= 0x80;

  write_ins(i); 
 
  return;
}


/**************************************/
/*      write instruction lcd         */
/**************************************/
void write_ins(unsigned char i)
{
  
  P1 = i & 0xF0;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = (i << 4) & 0xF0;
  E = 1;   delay(2);
  E = 0;   delay(2);

 return;
}


/***************************************/
/*           writev data lcd           */
/***************************************/
void write_data(unsigned char i)
{
  
  P1 = (i & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = ((i << 4) & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

 return;
}


/**************************************/
/*           delay   program          */ 
/**************************************/
void delay(char i)
{
  unsigned int j;

  do
  {
    for(j=0;j<1000;j++) {}
	i--; 
  }while(i > 0);

return;
}

