/***********************************/
/*  examnple  program for ET-LAB3A */
/* description : read adc          */
/* compiler    : keil c51          */  
/***********************************/

/*  include  section */
#include <reg51f.h>
#include <stdio.h>
#include <intrins.h>


sbit sda = P0^1;
sbit scl = P0^0;

sbit E = P1^2;
sbit RW = P1^1;
sbit RS = P1^0;

char lcdbuf[16+1];


/*  pototype  section */
void init_lcd();
void gotolcd(unsigned char);
void write_ins(unsigned char);
void write_data(unsigned char);
void printlcd();
void delay(char);
void deli2c();

void writebyte(unsigned char);
void readbyte(unsigned char *);
void sendbyte(unsigned char);
unsigned char getbyte(); 


/******************************************/
/*            main  program               */
/******************************************/
void main(void)
{
  unsigned char *j;

  scl = 1;
  sda = 1;
  delay(10);


  init_lcd();

  sprintf(lcdbuf,"CH0 CH1 CH2 CH3 ");
  printlcd();
  
 
  while(1)
  {
    writebyte(0x00);
   	readbyte(j);

	gotolcd(0x40);
    sprintf(lcdbuf,"%02Bx",*j);    
    printlcd();
    

	writebyte(0x01);
	readbyte(j);

	gotolcd(0x44);
    sprintf(lcdbuf,"%02Bx",*j);    
    printlcd();



	writebyte(0x02);
	readbyte(j);

	gotolcd(0x48);
    sprintf(lcdbuf,"%02Bx",*j);    
    printlcd();



	writebyte(0x03);
	readbyte(j);

	gotolcd(0x4C);
    sprintf(lcdbuf,"%02Bx",*j);    
    printlcd();

 }

}


/***********************************************/
/*         write data 1 byte to i2c            */ 
/***********************************************/
void writebyte(unsigned char i)
{
   sda = 0;
   scl = 0;

   sendbyte(0x92);
   sda = 1;
   scl = 1;   deli2c();
   while(sda) {}
   scl = 0;   deli2c();

   sendbyte(i);
   sda = 1;
   scl = 1;   deli2c();
   while(sda) {}
   scl = 0;   deli2c();
   sda = 0;

   scl = 1;
   sda = 1;
 
 return;
}



/***************************************************/
/*           read  data 1 byte from i2c            */
/***************************************************/
void readbyte(unsigned char *p)
{
   sda = 0;
   scl = 0;

   sendbyte(0x93);
   sda = 1;
   scl = 1;   deli2c();
   while(sda) {}
   scl = 0;   deli2c(); 

   getbyte();

   sda = 0;
   scl = 1;  deli2c();
   scl = 0;  deli2c();

   *p = getbyte();
   
   sda = 1;
   scl = 1;  deli2c();
   scl = 0;  deli2c();

   scl = 1;
   sda = 1;

 return;
}


/************************************************/
/*             send  data  1  byte              */
/************************************************/
void sendbyte(unsigned char i)
{
 char j;

 for(j = 0;j < 8;j++)
 {
   if((i & 0x80) == 0x80) {sda = 1;}
   else                   {sda = 0;}

   scl = 1;  deli2c(); 
   scl = 0;  deli2c();
 
   i <<= 1;
 }
  
 return;
}


/************************************************/
/*             get  data  1  byte               */ 
/************************************************/
unsigned char getbyte(void)
{
 unsigned char i;
 char j;

 for(j=0;j<8;j++)
 {
   i <<= 1;

   sda = 1;  
   scl = 1; deli2c();

   if(sda == 1) {i |= 0x01;}
   else         {i &= 0xFE;}
   
   scl = 0; deli2c();
 } 
  
 return i;
}


/***********************************************/
/*            print  data  to  lcd             */
/***********************************************/
void printlcd(void)
{
 char *p;
 
 p = lcdbuf;
 
 do{
    write_data(*p); 
    p++;
 }while(*p != '\0');
 
 return;
}


/********************************************/
/*               initial  lcd               */ 
/********************************************/
void init_lcd(void)
{
  write_ins(0x33);
  write_ins(0x32);
  write_ins(0x28);
  write_ins(0x08);
  write_ins(0x01);
  write_ins(0x02);
  write_ins(0x0f);

 return;
}


/********************************************/
/*             move lcd cursor              */
/********************************************/
void gotolcd(unsigned char i)
{
  i |= 0x80;

  write_ins(i); 
 
  return;
}


/********************************************/
/*       write instruction command          */
/********************************************/
void write_ins(unsigned char i)
{
  
  P1 = i & 0xF0;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = (i << 4) & 0xF0;
  E = 1;   delay(2);
  E = 0;   delay(2);

 return;
}


/*********************************************/
/*            write  data  lcd               */
/*********************************************/
void write_data(unsigned char i)
{
  
  P1 = (i & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = ((i << 4) & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

 return;
}


/**********************************************/
/*               delay  program               */
/**********************************************/
void delay(char i)
{
  unsigned int j;

  do
  {
    for(j=0;j<1000;j++) {}
	i--; 
  }while(i > 0);

return;
}


void deli2c(void)
{
 unsigned char i;

 i = 3; while(i>0) {i--;}
 return;
}

