/*****************************************/
/*  example  program for ET-LAB3A        */
/*  description : send data to port      */ 
/*  compiler    : keil c51               */
/*****************************************/
#include <reg51f.h>
#include <stdio.h>


sbit sda = P0^1;
sbit scl = P0^0;

/*  pototype  section  */
void deli2c(); 
void delay();
void writebyte(unsigned char);
void sendbyte(unsigned char);


/****************************************/
/*            main  program             */
/****************************************/
void main(void)
{
  unsigned char i;

  scl = 1;
  sda = 1;
  
  i = 0x01;
  while(1)
  {	
    if(i == 0x00) {i = 0x01;}  
    writebyte(~i);
	delay();
    i <<= 1;
  }  
}


/*****************************************/
/*      write data 1 byte to i2c         */
/*****************************************/
void writebyte(unsigned char i)
{
   sda = 0;
   scl = 0;

   sendbyte(0x74);       /*control word PCF8574A = 74H = | 0 | 1 | 1 | 1 | A2 | A1 | A0 | 0 | */        
   sda = 1;              /*control word PCF8574  = 44H = | 0 | 1 | 0 | 0 | A2 | A1 | A0 | 0 | */
   scl = 1;   deli2c();
   while(sda) {}
   scl = 0;   deli2c(); 

   sendbyte(i);
   sda = 1;
   scl = 1;   deli2c();
   while(sda) {} 
   scl = 0;   deli2c();

   scl = 1;
   sda = 1;

 return;
}


/**********************************************/
/*             send data 1 byte               */
/**********************************************/
void sendbyte(unsigned char i)
{
 char j;

 for(j = 0;j < 8;j++)
 {
   if((i & 0x80) == 0x80) {sda = 1;}
   else                   {sda = 0;}

   scl = 1;  deli2c();
   scl = 0;  deli2c();

   i <<= 1;
 }
  
 return;
}


void deli2c(void)
{
 unsigned char i;
 
 i = 2; while(i>0) {i--;}

 return;
}


/****************************************/
/*          delay  program              */
/****************************************/
void delay(void)
{
  unsigned int j;

  j = 50000; while(j>0) {j--;}

 return; 
}
