/***********************************/
/* example program for ET-LAB3A    */
/* description : move lcd cursor   */
/* compiler    :  keil C51         */
/***********************************/

/* include section */
#include <reg51f.h>
#include <stdio.h>

sbit  E = P1^2;
sbit  RW = P1^1;
sbit  RS = P1^0;

char lcdbuf[9];


/* pototype section */
void init_lcd();
void write_ins(unsigned char);
void write_data(unsigned char);
void printlcd();
void gotolcd(unsigned char);
void delay(char);


/********************************/
/*         main program         */ 
/********************************/
void main()
{
  delay(10);
  init_lcd();

  gotolcd(0x40);
  sprintf(lcdbuf,"ET-LAB3A");
  printlcd();

  while(1) {}

}


/*********************************/
/*      goto lcd program         */
/*********************************/
void gotolcd(unsigned char i)
{
  i |= 0x80;

  write_ins(i); 
 
  return;
}


/*********************************/
/*      print lcd program        */
/*********************************/
void printlcd(void)
{
 char i;
 char *p;
 
 p = lcdbuf;
 for(i = 0;i < 8;i++)
 {
    write_data(*p); 
    p++;
 }
 
 return;
}


/******************************/
/*    initial lcd program     */
/******************************/
void init_lcd(void)
{
  write_ins(0x33);
  write_ins(0x32);
  write_ins(0x28);
  write_ins(0x08);
  write_ins(0x01);
  write_ins(0x02);
  write_ins(0x0f);

 return;
}


/************************************/
/*       write instruction lcd      */
/************************************/
void write_ins(unsigned char i)
{
  
  P1 = i & 0xF0;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = (i << 4) & 0xF0;
  E = 1;   delay(2);
  E = 0;   delay(2);

 return;
}


/***************************************/
/*           write data lcd            */ 
/***************************************/
void write_data(unsigned char i)
{
  
  P1 = (i & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = ((i << 4) & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

 return;
}


/************************************/
/*          delay program           */
/************************************/
void delay(char i)
{
  unsigned int j;

  do
  {
    for(j=0;j<1000;j++) {}
	i--; 
  }while(i > 0);

return;
}
