/**********************************************/
/*   example program for ET-LAB3A             */
/* description : read temperature from ds1820 */
/* compiler    : keil c51                     */ 
/**********************************************/

/*   include section   */
#include <reg51.h>
#include <stdio.h>


sbit  data_bit = P0^1;
sbit  E = P1^2;
sbit  RW = P1^1;
sbit  RS = P1^0;


char lcdbuf[9];


/*   pototype  section  */
void init_lcd();
void gotolcd(unsigned char);
void write_ins(unsigned char);
void write_data(unsigned char);
void printlcd();
void delay(char);
unsigned char touchreset();
unsigned char touchbyte(unsigned char);
void readrom();
void skiprom();
void converttemp();
void readscratchpad(unsigned char *);
unsigned char gencrc(unsigned char *);


/****************************************/
/*            main  program             */  
/****************************************/
void main(void)
{
  unsigned char tempbuf[10];
  float i;
 
  delay(10);
  init_lcd();

  while(1)
  {
    readrom();   
    skiprom();
  
    converttemp();
    delay(50);

    skiprom();
    readscratchpad(tempbuf);
    
	if(tempbuf[1] == 0)
	{
	  i = (float)tempbuf[0]/2;
	  
	  gotolcd(0x00);
	  sprintf(lcdbuf,"Temp = +%3.1f C",i);
	  printlcd();
	}
    else
	{
	  i = ~tempbuf[0] + 1;
 	  i = i/2;
      
	  gotolcd(0x00);
	  sprintf(lcdbuf,"Temp = -%3.1f C",i);
	  printlcd();
	}


  } 
}



unsigned char touchreset(void)
{
  unsigned char i;

  data_bit = 0;         /* start reset pulse */ 
  i = 255; while(i>0) {i--;}
  i = 255; while(i>0) {i--;}
  i = 255; while(i>0) {i--;}
  
  data_bit = 1;         /* release data line */

  i = 50; 
  while(!data_bit)
  {
    i--;
    if(i == 0) {return 0;}
  }

    
  i = 230; 
  while(i>0) 
  {
    if(!data_bit)
    {
      while(!data_bit) {i = 4;while(i>0) i--;}
      return 1;
    }
    else { i--; } 
  }
 
 return 0;  
}



unsigned char touchbyte(unsigned char d)
{
  unsigned char i;
  unsigned char j;
  char c;

  for(c = 0;c < 8;c++)
  {
    j >>= 1; 
    if((d & 0x01) == 0x01)              
    {
      data_bit = 0;
      i = 4;   while(i > 0) {i--;}
      data_bit = 1;
      i = 10;  while(i > 0) {i--;}
	  if(data_bit) {j |= 0x80;}
	  i = 61;  while(i > 0) {i--;}
    }
    else                                        
    {
      data_bit = 0;
	  i = 4;  while(i > 0) {i--;}
	  data_bit = 0;
	  i = 10; while(i > 0) {i--;}
	  if(data_bit) {j |= 0x80;}
	  i = 90; while(i > 0) {i--;}
    }
	data_bit = 1;
	d >>= 1;	  
  }
   

 return j;
}



unsigned char gencrc(unsigned char *m)
{
  char i,j;
  unsigned char crc = 0;
  unsigned char k;

  for(j=0;j<7;j++)
  {
   for(i=0;i<8;i++)
   {
     k = m[j] ^ crc;
     if((k & 0x01) == 0x01)
     {
	   crc   = crc ^ 0x18;
	   crc >>= 1; 
	   crc  |= 0x80;
	 }
	 else
     {
	   crc >>= 1;    
	 }
	 m[j] >>= 1;
   }
 }

 return crc;
}



void readrom(void)
{
  char i;
  unsigned char rombuf[8];
  unsigned char crc;

  while(!touchreset()) {}

  touchbyte(0x33);            /*read rom command */
  
  for(i=0;i<8;i++)
  {
   rombuf[i] = touchbyte(0xFF);   
  }
  
  crc = gencrc(rombuf);
  
  while(crc != rombuf[7]) {}

 return;
}


void skiprom(void)
{
  while(!touchreset()) {}

  touchbyte(0xCC);

 return;
}


void converttemp(void)
{
  touchbyte(0x44); 
 return;
}


void readscratchpad(unsigned char *scratch)
{
  char i;

  touchbyte(0xBE);
  
  for(i=0;i<9;i++)
  {
    scratch[i] = touchbyte(0xFF);
  }
  
  touchreset();

 return;
}


void printlcd(void)
{
 char i = 0;
 
 do
 {
    write_data(lcdbuf[i]); 
    i++;
 }while(lcdbuf[i] != '\0');
 
 return;
}


void init_lcd(void)
{
  write_ins(0x33);
  write_ins(0x32);
  write_ins(0x28);
  write_ins(0x08);
  write_ins(0x01);
  write_ins(0x02);
  write_ins(0x0f);

 return;
}

void gotolcd(unsigned char i)
{
  i |= 0x80;

  write_ins(i); 
 
  return;
}

void write_ins(unsigned char i)
{
  
  P1 = i & 0xF0;
  E = 1;   delay(2);
  E = 0;   delay(2);

  P1 = (i << 4) & 0xF0;
  E = 1;   delay(2);
  E = 0;   delay(2);

 return;
}


void write_data(unsigned char i)
{
  
  P1 = (i & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = ((i << 4) & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

 return;
}


void delay(char i)
{
  unsigned int j;

  do
  {
    for(j=0;j<1000;j++) {}
	i--; 
  }while(i > 0);

return;
}
