/***************************************/
/*  example program for ET-LAB3A       */
/* description : read & write from rtc */ 
/* compiler    : keil c51              */
/***************************************/

/*   include  section  */
#include <reg51f.h>
#include <stdio.h>


sbit sda = P0^1;
sbit scl = P0^0;

sbit E = P1^2;
sbit RW = P1^1;
sbit RS = P1^0;

char lcdbuf[16+1];

/*  pototype  section  */
void init_lcd(void);
void gotolcd(unsigned char);
void write_ins(unsigned char);
void write_data(unsigned char);
void printlcd(void);
void delay(char);
void deli2c(void);

void writebyte(unsigned char,unsigned char);
void readbyte(unsigned char,unsigned char *);
void sendbyte(unsigned char);
unsigned char getbyte(void); 

/****************************************/
/*            main  program             */
/****************************************/
void main(void)
{
  unsigned char *j;
  scl = 1;
  sda = 1;
  delay(10);


  init_lcd();

  writebyte(0,0);
  
  gotolcd(0);
  sprintf(lcdbuf,"HH:MM:SS");
  printlcd();

  while(1)
  {
    readbyte(0,j);
    gotolcd(0x46);
    sprintf(lcdbuf,"%02BX",*j);
    printlcd();

	readbyte(1,j);
	gotolcd(0x43);
    sprintf(lcdbuf,"%02BX",*j);
    printlcd();

	readbyte(2,j);
	gotolcd(0x40);
    sprintf(lcdbuf,"%02BX",*j);
    printlcd();


  }
}


/**********************************************/
/*       write  data 1 byte to DS1307         */
/**********************************************/
void writebyte(unsigned char a,unsigned char d)
{
   sda = 0;
   scl = 0;

   sendbyte(0xD0);
   sda = 1;
   scl = 1;   deli2c(); 
   while(sda) {}
   scl = 0;   deli2c();

   sendbyte(a);
   sda = 1;
   scl = 1;   deli2c();
   while(sda) {}
   scl = 0;   deli2c(); 

   sendbyte(d);
   sda = 1;
   scl = 1;   deli2c();
   while(sda) {}
   scl = 0;   deli2c();
   sda = 0;

   scl = 1;
   sda = 1;
 
 return;
}
 


/*************************************************/
/*       read  data  1 byte  from ds1307         */
/*************************************************/
void readbyte(unsigned char a,unsigned char *p)
{
   sda = 0;
   scl = 0;

   sendbyte(0xD0);
   sda = 1;
   scl = 1;   deli2c();
   while(sda) {}
   scl = 0;   deli2c(); 

   sendbyte(a);
   sda = 1;
   scl = 1;   deli2c();
   while(sda) {}
   scl = 0;   deli2c(); 

   scl = 1;
   sda = 1;

   sda = 0;
   scl = 0;   

   sendbyte(0xD1);
   sda = 1;
   scl = 1;   deli2c();
   while(sda) {}
   scl = 0;   deli2c(); 
   
   *p = getbyte();

   sda = 1;
   scl = 1;  deli2c();

   scl = 0;  deli2c();

   scl = 1;
   sda = 1;

 return;
}


/************************************************/
/*          send data 8 bit to i2c              */ 
/************************************************/
void sendbyte(unsigned char i)
{
 char j;

 for(j = 0;j < 8;j++)
 {
   if((i & 0x80) == 0x80) {sda = 1;}
   else                   {sda = 0;}

   scl = 1;  deli2c();
   scl = 0;  deli2c();

   i <<= 1;
 }
  
 return;
}


/********************************************/
/*        get data 8 bit from rtc           */
/********************************************/
unsigned char getbyte(void)
{
 unsigned char i;
 char j;

 for(j=0;j<8;j++)
 {
   i <<= 1;

   sda = 1;  

   scl = 1;     deli2c();

   if(sda == 1) {i |= 0x01;}
   else         {i &= 0xFE;}
   
   scl = 0;     deli2c();
 } 
  
 return i;
}


/******************************************/
/*          print ascii to lcd            */
/******************************************/
void printlcd(void)
{
 char *p;
 
 p = lcdbuf;
 
 do{
    write_data(*p); 
    p++;
 }while(*p != '\0');
 
 return;
}


/*****************************************/
/*            initial lcd                */
/*****************************************/
void init_lcd(void)
{
  write_ins(0x33);
  write_ins(0x32);
  write_ins(0x28);
  write_ins(0x08);
  write_ins(0x01);
  write_ins(0x02);
  write_ins(0x0f);

 return;
}

/********************************************/
/*             move lcd cursor              */            
/********************************************/
void gotolcd(unsigned char i)
{
  i |= 0x80;

  write_ins(i); 
 
  return;
}


/********************************************/
/*          write instruction lcd           */ 
/********************************************/
void write_ins(unsigned char i)
{
  
  P1 = i & 0xF0;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = (i << 4) & 0xF0;
  E = 1;   delay(2);
  E = 0;   delay(2);

 return;
}


/*****************************************************/
/*              write  data lcd command              */
/*****************************************************/
void write_data(unsigned char i)
{
  
  P1 = (i & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = ((i << 4) & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

 return;
}


/*********************************************/
/*               delay   program             */
/*********************************************/
void delay(char i)
{
  unsigned int j;

  do
  {
    for(j=0;j<1000;j++) {}
	i--; 
  }while(i > 0);

return;
}

void deli2c(void)
{
  unsigned char i;
 
  i = 2; while(i>0) {i--;}

  return;
}

