/*************************************/
/*   example program for ET-LAB3A    */
/* description : scan dot-matrix led */
/* compiler    : keil c51            */ 
/*************************************/

/*  include section */
#include <reg51f.h>

sbit CLK   = P1^7;
sbit ENA   = P1^4;
sbit RST   = P1^6;

sbit SER   = P1^5;
sbit SRCLK = P1^1;
sbit SRCLR = P1^0;
sbit RCK   = P1^2;
sbit G     = P1^3;


/* pototype section */
void dataout(void);
void outword(unsigned int);
void out595(unsigned char);
void delay(unsigned char);


/***********************************/
/*           main program          */
/***********************************/
void main(void)
{
  G  = 0;
  SRCLR = 1;
  RST = 1;
  ENA = 0;

  delay(20);
 
  while(1)
  {
    dataout();
  }
    
}


/******************************************/
/*              scan  display             */ 
/******************************************/
void dataout(void)
{
 char j;
  
  RST = 1;
  RST = 0;

  for(j = 0;j < 7;j++)
  {
    outword(0xFFFF);    
    CLK = 1;            delay(10);  
	CLK = 0;            delay(10); 
	outword(0x0000);
	delay(250);
  }
    outword(0xFFFF);

 return;
}


/***************************************/
/*          out 2 byte 74HC595         */
/***************************************/
void outword(unsigned int i)
{
  out595(i);
  out595(i >> 8);

  RCK = 1;       delay(10);
  RCK = 0;       delay(10);
  G = 0;         delay(10);
}


/***************************************/
/*         out 8 bit 74HC595           */
/***************************************/
void out595(unsigned char i)
{
 char j;
 
 for(j=0;j<8;j++)
 {
   if((i & 0x80) == 0x80) {SER = 1;}
   else                   {SER = 0;}

   SRCLK = 1;      delay(10);
   SRCLK = 0;      delay(10);
   i <<= 1;
 }

 return;
}


/***************************************/
/*                delay                */
/***************************************/
void delay(unsigned char i)
{

 do{}while(i-- > 0);

 return;
}
