/***********************************************/
/*     example program for ET-LAB3A            */
/* description : show "5*7" at dot-matrix led  */
/* compiler    : keil C51                      */ 
/***********************************************/

/*    include section    */
#include <reg51.h>

sbit CLK_4017   = P1^7;
sbit ENA_4017   = P1^4;
sbit RST_4017   = P1^6;

sbit SER_595    = P1^5;
sbit SCLK_595   = P1^1;
sbit SCLR_595   = P1^0;
sbit RCK_595    = P1^2;
sbit G_595      = P1^3;

/*    pototype section     */
void out595(void);
void delay(unsigned char);


/****************************************/
/*             main program             */
/****************************************/
void main(void)
{
 
  while(1)
  {
    out595();
  }    
}


/***************************************/
/*           scan  display             */
/***************************************/
void out595(void)
{
 char j,i;
 unsigned int m,n;                                  
 code unsigned char  character[3][7] =  {{0xF8,0x80,0xF0,0x08,0x08,0x88,0x70},
                                         {0x00,0x20,0xA8,0x70,0xA8,0x20,0x00},
									     {0xF8,0x08,0x10,0x20,0x40,0x40,0x40}}; 

   
   SCLR_595  = 1;
   ENA_4017  = 0;
   RST_4017  = 1;
   RST_4017  = 0;


   for(i=0;i<7;i++)
   {
     G_595 = 1;

	 m   = character[0][i];
     m <<= 8;
	 m  &= 0xF800;
     n   = character[1][i];
     n <<= 3;
	 n  &= 0x07C0;
	 m  |= n;
	 n   = character[2][i];
     n >>= 2;
	 n  &= 0x003F;
     m  |= n;
     m = ~m;
     for(j=0;j<16;j++)
     {
       if((m & 0x01) == 0x01) {SER_595 = 1;}
       else                   {SER_595 = 0;}
 
	   delay(1);
       SCLK_595 = 1; delay(1);    
       SCLK_595 = 0; delay(1);     
       m >>= 1;
     }
	 RCK_595 = 1;
	 RCK_595 = 0;

	 CLK_4017 = 1;
	 CLK_4017 = 0;

	 G_595 = 0;

	 delay(100);
   }

   CLK_4017 = 1;
   CLK_4017 = 0;
   ENA_4017 = 1;

 return;
}


/***************************************/
/*           delay program             */ 
/***************************************/
void delay(unsigned char i)
{

 while(i>0) {i--;}

 return;

}
