/********************************************/
/* example program for ET-LAB3A             */
/* description : close loop speed control   */
/* compiler    : keil c51                   */
/********************************************/

/* include section  */
#include <reg51f.h>
#include <stdio.h>


sbit  E = P1^2;
sbit  RW = P1^1;
sbit  RS = P1^0;

char lcdbuf[17];
unsigned int pv; 
unsigned int ms;

/* pototype section */
void init_lcd();
void gotolcd(unsigned char);
void write_ins(unsigned char);
void write_data(unsigned char);
void printlcd();
void delay(char);
void timer1();


/******************************************/
/*              main program              */
/******************************************/
void main(void)
{
  unsigned char sp = 20;         //set point
  float gain = 1;              //gain control 
  int ee;                        //error variable
  int mv = 0;                    //manipulate variable

  delay(10);
  init_lcd();
  
  P3 = 0xFE;
  P0 = mv;
 
  ET1 = 1;
  TMOD = 0x15;

  while(1)
  {
    TH1  = 0xF3;
    TL1  = 0xFF;
    TH0  = 0x00;
    TL0  = 0x00;

    ms = 0;
    TR0 = 1;
    TR1 = 1;
    EA  = 1;
  
    while(ms < 500) {}            //wait until 500ms
  
    EA  = 0;
    TR0 = 0;
    TR1 = 0;
    
	pv = TH0;
	pv <<= 8;
	pv |= TL0;

	ee = sp-pv;    
    mv += (ee*gain);
	if(mv > 255) {mv = 255;}
	if(mv < 0)   {mv = 0;  }
    P0 = mv;

	gotolcd(0x00); 
    sprintf(lcdbuf," speed %04d rps ",pv);
	printlcd();

   }
}


/*********************************************/
/*          timer1 service interrupt         */
/*********************************************/
void timer1(void) interrupt 3 using 2
{
  ms++;
  TH1  = 0xF3; 
  TL1  = 0xFF;
 return;
}


/*******************************************/
/*            print data to lcd            */
/*******************************************/
void printlcd(void)
{
 char i;
 char *p;
 
 p = lcdbuf;
 for(i = 0;i < 16;i++)
 {
    write_data(*p); 
    p++;
 }
 
 return;
}


/****************************************/
/*              initial lcd             */
/****************************************/
void init_lcd(void)
{
  write_ins(0x33);
  write_ins(0x32);
  write_ins(0x28);
  write_ins(0x08);
  write_ins(0x01);
  write_ins(0x02);
  write_ins(0x0f);

 return;
}


/********************************************/
/*               move cursor lcd            */
/********************************************/
void gotolcd(unsigned char i)
{
  i |= 0x80;

  write_ins(i); 
 
  return;
}


/********************************************/
/*      write instruction lcd command       */ 
/********************************************/
void write_ins(unsigned char i)
{
  
  P1 = i & 0xF0;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = (i << 4) & 0xF0;
  E = 1;   delay(2);
  E = 0;   delay(2);

 return;
}


/*********************************************/
/*           write data lcd command          */
/*********************************************/
void write_data(unsigned char i)
{
  
  P1 = (i & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = ((i << 4) & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

 return;
}


/*********************************************/
/*                delay program              */
/*********************************************/
void delay(char i)
{
  unsigned int j;

  do
  {
    for(j=0;j<1000;j++) {}
	i--; 
  }while(i > 0);

return;
}
