/*******************************************************/
/*   example program for ET-LAB3A                      */
/* description : read thermister and ldr from adc0832  */
/* compiler    : keil c51                              */
/*******************************************************/

/*  include  section   */
#include <reg51f.h>
#include <stdio.h>

sbit din   = P0^0;
sbit dout  = P0^4;
sbit clk   = P0^2;
sbit cs    = P0^3;

sbit E = P1^2;
sbit RW = P1^1;
sbit RS = P1^0;
char lcdbuf[16+1];

/*  pototype  section  */
void init_lcd();
void gotolcd(unsigned char);
void write_ins(unsigned char);
void write_data(unsigned char);
void printlcd();
void delay(char);
unsigned char sigadc0();
unsigned char sigadc1();
void delspi(unsigned char);


/******************************************/
/*             main  program              */
/******************************************/
void main(void)
{
  unsigned char i;
  
  delay(10);

  cs   = 1;
  clk  = 0;
  dout = 1;

  init_lcd(); 

  sprintf(lcdbuf,"NTC   LDR");
  printlcd();

  while(1)
  {
    i = sigadc0();
  
    gotolcd(0x40);
    sprintf(lcdbuf,"%02BX",i);
    printlcd();

    i = sigadc1();
    gotolcd(0x46);
    sprintf(lcdbuf,"%02BX",i);
    printlcd();
  }

 return;  
}


/********************************************/
/*           read  adc  channel 0           */
/********************************************/
unsigned char sigadc0(void)
{
  unsigned char i;
  unsigned char j;
  
  cs = 0;

  din = 1;  
  clk = 1; delspi(5); 
  clk = 0; delspi(5); 
 
  din = 1;  
  clk = 1; delspi(5);    
  clk = 0; delspi(5); 
 
  din = 0;  
  clk = 1; delspi(5);    
  clk = 0; delspi(5);  

  for(j=0;j<8;j++)
  {
    clk = 1; delspi(5);
	clk = 0; delspi(5);
 
    i <<= 1; 
    if(dout == 1) {i |= 0x01;}
    else          {i &= 0xfe;}
  }
   
  cs = 1;
	
 return i;
}


/***************************************/
/*         read adc  channel1          */
/***************************************/
unsigned char sigadc1(void)
{
  unsigned char i;
  unsigned char j;
  
  cs = 0;

  din = 1;  
  clk = 1; delspi(5); 
  clk = 0; delspi(5); 
 
  din = 1;  
  clk = 1; delspi(5);    
  clk = 0; delspi(5); 
 
  din = 1;  
  clk = 1; delspi(5);    
  clk = 0; delspi(5);  

  for(j=0;j<8;j++)
  {
    clk = 1; delspi(5);
	clk = 0; delspi(5);
 
    i <<= 1; 
    if(dout == 1) {i |= 0x01;}
    else          {i &= 0xfe;}
  }
   
  cs = 1;
	
 return i;
}

/****************************************/
/*          print data to lcd           */
/****************************************/
void printlcd(void)
{
 char *p;
 
 p = lcdbuf;
 
 do{
    write_data(*p); 
    p++;
 }while(*p != '\0');
 
 return;
}


/******************************************/
/*             initial lcd                */ 
/******************************************/
void init_lcd(void)
{
  write_ins(0x33);
  write_ins(0x32);
  write_ins(0x28);
  write_ins(0x08);
  write_ins(0x01);
  write_ins(0x02);
  write_ins(0x0f);

 return;
}


/*****************************************/
/*           move cursor lcd             */
/*****************************************/
void gotolcd(unsigned char i)
{
  i |= 0x80;

  write_ins(i); 
 
  return;
}


/**********************************************/
/*          write instruction command         */
/**********************************************/
void write_ins(unsigned char i)
{
  
  P1 = i & 0xF0;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = (i << 4) & 0xF0;
  E = 1;   delay(2);
  E = 0;   delay(2);

 return;
}


/**********************************************/
/*              write  data  command          */
/**********************************************/
void write_data(unsigned char i)
{
  
  P1 = (i & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

  P1 = ((i << 4) & 0xF0) | 0x01;
  E = 1;    delay(2);
  E = 0;    delay(2);

 return;
}


/***********************************************/
/*                delay  program               */
/***********************************************/
void delay(char i)
{
  unsigned int j;

  do
  {
    for(j=0;j<1000;j++) {}
	i--; 
  }while(i > 0);

return;
}


/************************************************/
/*             delay for spi  device            */
/************************************************/
void delspi(unsigned char j)
{
  do{}while(j-- > 0);

 return;
}





