/*******************************************/
/* example program for ET-LAB3A            */ 
/* description  : read and write 24c16     */
/* compiler     : keil c51                 */    
/*******************************************/

/*  include section */
#include <reg51f.h>
#include <stdio.h>
#include <intrins.h>


sbit sda = P0^1;
sbit scl = P0^0;

sbit E  = P1^2;
sbit RW = P1^1;
sbit RS = P1^0;

char lcdbuf[16+1];


/*   pototype  section */
void init_lcd();
void gotolcd(unsigned char);
void write_ins(unsigned char);
void write_data(unsigned char);
void printlcd();
void delay(unsigned char);
void deli2c();

char writebyte(unsigned int,unsigned char);
char readbyte(unsigned int,unsigned char *);
void sendbyte(unsigned char);
unsigned char getbyte(); 


/***************************************/
/*            main  program            */
/***************************************/
void main(void)
{
  unsigned char *j;
  scl = 1;
  sda = 1;
  delay(10);


  init_lcd();

  writebyte(1,0x50); 
  
  gotolcd(0);
  sprintf(lcdbuf," write     read ");
  printlcd();

  readbyte(1,j);

  gotolcd(0x40);
  sprintf(lcdbuf,"  50       %02BX",*j);
  printlcd();

  while(1) {}

}


/*****************************************************/
/*        write  data 1 byte  to eeprom              */ 
/*****************************************************/
char writebyte(unsigned int a,unsigned char d)
{  
   unsigned char i;
   
   i  = (a >> 7) & 0x0E;
   i |= 0xA0;
  
   sda = 0;  
   scl = 0;  
   
   sendbyte(i);              /* control byte for write RW = 0*/
   sda = 1;
   scl = 1;  deli2c();
   while(sda) {}
   scl = 0;  deli2c(); 

   sendbyte(a);
   sda = 1;
   scl = 1;  deli2c();
   while(sda) {}
   scl = 0;  deli2c(); 

   sendbyte(d);
   sda = 1;
   scl = 1;  deli2c();
   while(sda) {} 
   scl = 0;  deli2c();
   
   sda = 0;

   scl = 1; 
   sda = 1; 

   delay(255);
 
 return 1;
}
 


/****************************************************/
/*        read  data  1 byte from eeprom            */
/****************************************************/
char readbyte(unsigned int a,unsigned char *p)
{
   unsigned char i;
   
   i  = (a >> 7) & 0x0E;
   i |= 0xA0;


   sda = 0;  
   scl = 0;

   sendbyte(i);            /* control byte for write RW = 0 */
   sda = 1;
   scl = 1;  deli2c();
   while(sda) {}
   scl = 0;  deli2c(); 

   sendbyte(a);
   sda = 1;
   scl = 1;  deli2c();
   while(sda) {} 
   scl = 0;  deli2c(); 

   scl = 1;  
   sda = 1; 
 
   sda = 0;  
   scl = 0;  

   sendbyte(i | 0x01);       /* control byte for read  RW = 1*/
   sda = 1;
   scl = 1;  deli2c();
   while(sda) {}
   scl = 0;  deli2c(); 
   
   *p = getbyte();

   sda = 1;
   scl = 1;  
   scl = 0;  

   scl = 1;  
   sda = 1;  
   
   delay(255);

 return 1;
}


/*******************************************/
/*     send  data 1 byte to eeprom         */
/*******************************************/
void sendbyte(unsigned char i)
{
 char j;

 for(j = 0;j < 8;j++)
 {
   if((i & 0x80) == 0x80) {sda = 1;}
   else                   {sda = 0;}

   scl = 1;  deli2c();
   scl = 0;  deli2c();
   i <<= 1;
 }
  
 return;
}


/******************************************/
/*         get  data  8 bit               */
/******************************************/
unsigned char getbyte(void)
{
 unsigned char i;
 char j;

 for(j=0;j<8;j++)
 {
   i <<= 1;

   sda = 1;  
   scl = 1;  deli2c();
   if(sda == 1) {i |= 0x01;}
   else         {i &= 0xFE;}   
   scl = 0;  deli2c();
 } 
  
 return i;
}


/**********************************************/
/*             print ascii to lcd             */
/**********************************************/
void printlcd(void)
{
 char *p;
 
 p = lcdbuf;
 
 do{
    write_data(*p); 
    p++;
 }while(*p != '\0');
 
 return;
}


/************************************************/
/*                initial  lcd                  */ 
/************************************************/
void init_lcd(void)
{
  write_ins(0x33);
  write_ins(0x32);
  write_ins(0x28);
  write_ins(0x08);
  write_ins(0x01);
  write_ins(0x02);
  write_ins(0x0f);

 return;
}


/*************************************************/
/*               move lcd cursor                 */      
/*************************************************/
void gotolcd(unsigned char i)
{
  i |= 0x80;

  write_ins(i); 
 
  return;
}


/*************************************************/
/*        write instruction command              */
/*************************************************/
void write_ins(unsigned char i)
{
  
  P1 = i & 0xF0;
  E = 1;    delay(1);
  E = 0;    delay(1);

  P1 = (i << 4) & 0xF0;
  E = 1;   delay(1);
  E = 0;   delay(1);

 return;
}

/****************************************/
/*        write  data  command          */
/****************************************/
void write_data(unsigned char i)
{
  
  P1 = (i & 0xF0) | 0x01;
  E = 1;    delay(1);
  E = 0;    delay(1);

  P1 = ((i << 4) & 0xF0) | 0x01;
  E = 1;    delay(1);
  E = 0;    delay(1);

 return;
}

/***************************************/
/*           delay  program            */
/***************************************/
void delay(unsigned char i)
{
  unsigned int j;
  
  while(i>0)
  {
    j = 0x02FF; while(j>0) j--;
	i--;
  }

return;
}


/******************************************/
/*        delay for i2c  device           */
/******************************************/
void deli2c(void)
{
  unsigned char i;

  i = 100; while(i>0) i--;

 return;
}
