;/***********************************/;
;/* Demo Program For CP-Z80  V1.0   */;
;/* File Name : DEMOOUT8.ASM        */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : Cross32 V4.0        */;
;/* Execute   : Run on Monitor Z80  */;
;/* Function  : General Output-8    */;
;/***********************************/;
;
;/* Demo to Control General of Output-8
;/* Movelight LED on Port Output-8
;/* Address Port of IORQ Decode For CP-Z80 V1
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset = LOW
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ:  EQU     00H                 ; Chips Select Decode = 00H
MR1A:       EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (1st = MR1A)
MR2A:       EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (2nd = MR2A)
CSRA:       EQU     PORT_IORQ+01H       ; W = Clock Select Register-A
SRA:        EQU     PORT_IORQ+01H       ; R = Status Register-A
CRA:        EQU     PORT_IORQ+02H       ; W = Command Register-A
THRA:       EQU     PORT_IORQ+03H       ; W = TX Holding Register-A
RHRA:       EQU     PORT_IORQ+03H       ; R = RX Holding Register-A
ACR:        EQU     PORT_IORQ+04H       ; W = Aux Control Register
IPCR:       EQU     PORT_IORQ+04H       ; R = Input Port Change Register
IMR:        EQU     PORT_IORQ+05H       ; W = Interupt Mask Register
ISR:        EQU     PORT_IORQ+05H       ; R = Interupt Status Register
CRUR:       EQU     PORT_IORQ+06H       ; W/R = Timer Upper
CTLR:       EQU     PORT_IORQ+07H       ; W/R = Timer Lower
;
MR1B:       EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (1st = MR1B)
MR2B:       EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (2nd = MR2B)
CSRB:       EQU     PORT_IORQ+09H       ; W = Clock Select Register-B
SRB:        EQU     PORT_IORQ+09H       ; R = Status Register-B
CRB:        EQU     PORT_IORQ+0AH       ; W = Clock Select Register-B
THRB:       EQU     PORT_IORQ+0BH       ; W = TX Holding Register-B
RHRB:       EQU     PORT_IORQ+0BH       ; R = RX Holding Register-B
OPCR:       EQU     PORT_IORQ+0DH       ; W = Output Port Config Register
INPUT:      EQU     PORT_IORQ+0DH       ; R = Input Port
SET_OUT8:   EQU     PORT_IORQ+0EH       ; W = Set Output Port Bit
STRT_CNT:   EQU     PORT_IORQ+0EH       ; R = Strat Counter
CLR_OUT8:   EQU     PORT_IORQ+0FH       ; W = Clear Output Port Bit
STOP_CNT:   EQU     PORT_IORQ+0FH       ; R = Stop Counter

            CPU     "Z80.TBL"
            HOF     "INT8"
            ORG     0000H               ; Start at Monitor Z80
            ;
MAIN:       LD      SP,9FFFH            ; Stack = 8K
            LD      A,00000000B         ; All Bit Output = General Output
            OUT     (OPCR),A
            LD      A,11111111B         ; Clear All Output Port
            OUT     (CLR_OUT8),A
            ;
LOOP_OUT1:  LD      B,8                 ; 8-Bit Output Counter
            LD      HL,TAB_OUT          ; Table Data Output
            ;
LOOP_OUT2:  LD      A,(HL)              ; Get Data
            CPL                         ; Toggle Logic Output
            ;
            PUSH    AF                  ; Save Data Output
            LD      A,11111111B
            OUT     (SET_OUT8),A        ; Clear Old Data Output Pin
            POP     AF                  ; Restore Data Output
            OUT     (CLR_OUT8),A        ; Write New Data Output Pin
            CALL    DELAY
            INC     HL
            DJNZ    LOOP_OUT2
            JR      LOOP_OUT1

;/***********************/;
;/* Data Output Control */;
;/***********************/;
;
TAB_OUT:    DFB     01H,02H,04H,08H
            DFB     10H,20H,40H,80H

;/**************/;
;/* Delay Time */;
;/**************/;
;
DELAY:      PUSH    AF
            PUSH    HL
            LD      HL,0FFFFH
DLY1:       DEC     HL
            LD      A,H
            OR      L
            JR      NZ,DLY1
            POP     HL
            POP     AF
            RET

            END
            
