;/***********************************/;
;/* Demo Program For CP-Z80  V1.0   */;
;/* File Name : CTS-RTS.ASM         */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : Cross32 V4.0        */;
;/* Execute   : Run on Monitor Z80  */;
;/* Function  : RXD,TXD Async.      */;
;/* (Used CTS&RTS Hardware Control) */;
;/***********************************/;
;
;/* Aysnchronous Format Data = 9600,N,8,1,P
;/* Receive & Transmitt in Polling Mode
;/* Receive Data & Echo Receive to Terminal
;/* Address Port of IORQ Decode For CP-Z80 V1
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset = LOW
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ:  EQU     00H                 ; Chips Select Decode = 00H
MR1A:       EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (1st = MR1A)
MR2A:       EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (2nd = MR2A)
CSRA:       EQU     PORT_IORQ+01H       ; W = Clock Select Register-A
SRA:        EQU     PORT_IORQ+01H       ; R = Status Register-A
CRA:        EQU     PORT_IORQ+02H       ; W = Command Register-A
THRA:       EQU     PORT_IORQ+03H       ; W = TX Holding Register-A
RHRA:       EQU     PORT_IORQ+03H       ; R = RX Holding Register-A
ACR:        EQU     PORT_IORQ+04H       ; W = Aux Control Register
IPCR:       EQU     PORT_IORQ+04H       ; R = Input Port Change Register
IMR:        EQU     PORT_IORQ+05H       ; W = Interupt Mask Register
ISR:        EQU     PORT_IORQ+05H       ; R = Interupt Status Register
CRUR:       EQU     PORT_IORQ+06H       ; W/R = Timer Upper
CTLR:       EQU     PORT_IORQ+07H       ; W/R = Timer Lower
;
MR1B:       EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (1st = MR1B)
MR2B:       EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (2nd = MR2B)
CSRB:       EQU     PORT_IORQ+09H       ; W = Clock Select Register-B
SRB:        EQU     PORT_IORQ+09H       ; R = Status Register-B
CRB:        EQU     PORT_IORQ+0AH       ; W = Clock Select Register-B
THRB:       EQU     PORT_IORQ+0BH       ; W = TX Holding Register-B
RHRB:       EQU     PORT_IORQ+0BH       ; R = RX Holding Register-B
OPCR:       EQU     PORT_IORQ+0DH       ; W = Output Port Config Register
INPUT:      EQU     PORT_IORQ+0DH       ; R = Input Port
SET_OUT:    EQU     PORT_IORQ+0EH       ; W = Set Output Port Bit
STRT_CNT:   EQU     PORT_IORQ+0EH       ; R = Strat Counter
CLR_OUT:    EQU     PORT_IORQ+0FH       ; W = Clear Output Port Bit
STOP_CNT:   EQU     PORT_IORQ+0FH       ; R = Stop Counter

            CPU     "Z80.TBL"
            HOF     "INT8"
            ORG     0000H               ; Start at Monitor Z80
            ;
MAIN:       LD      SP,9FFFH            ; Stack = 8K
            CALL    INIT_2681           ; Initial SCN2681 9600,N,8,1
            ;
WAIT_DAT1:  CALL    RXA_2681            ; Wait Receive Channel-A
            CP      00H
            JR      Z,WAIT_DAT2
            CP      0DH
            JR      NZ,ECHO_DAT1
            CALL    PRN_MSG1
            JP      WAIT_DAT1
            ;
ECHO_DAT1:  CALL    TXA_2681            ; Echo Receive-A
            JP      WAIT_DAT1
            ;
WAIT_DAT2:  CALL    RXB_2681            ; Wait Receive Channel-B
            CP      00H
            JR      Z,WAIT_DAT1
            CP      0DH
            JR      NZ,ECHO_DAT2
            CALL    PRN_MSG2
            JP      WAIT_DAT1
            ;
ECHO_DAT2:  CALL    TXB_2681            ; Echo Receive-B
            JP      WAIT_DAT1


;/********************/;
;/* Print Block Data */;
;/* Out : Async Ch-A */;
;/********************/;
;
PRN_MSG1:   LD      HL,TAB_MSG1
GET_MSG1:   LD      A,(HL)
            CP      00H
            JR      Z,END_MSG1
            CALL    TXA_2681            ; Print Byte
            INC     HL
            JP      GET_MSG1
END_MSG1:   RET

;/********************/;
;/* Print Block Data */;
;/* Out : Async Ch-B */;
;/********************/;
;
PRN_MSG2:   LD      HL,TAB_MSG2
GET_MSG2:   LD      A,(HL)
            CP      00H
            JR      Z,END_MSG2
            CALL    TXB_2681            ; Print Byte
            INC     HL
            JP      GET_MSG2
END_MSG2:   RET

TAB_MSG1:   DFB     0DH,0AH
            DFB     "This is Channel-A of SCN2681"
            DFB     0DH,0AH,00H
            ;
TAB_MSG2:   DFB     0DH,0AH
            DFB     "This is Channel-B of SCN2681"
            DFB     0DH,0AH,00H

;/*************************/;
;/* Initial SCN2681 DUART */;
;/*      9600,N,8,1,P     */;
;/*  Async. Channel-A,B   */;
;/*************************/;
;
INIT_2681:  LD      A,01000101B         ; Reset Error Status & Enable TX,RX
            OUT     (CRA),A
            OUT     (CRB),A
            LD      A,00010101B         ; MR Pointer = MR1 & Enable TX,RX
            OUT     (CRA),A
            OUT     (CRB),A
            LD      A,10010011B         ; Active RTS,Non Parity,8 Bit Data
            OUT     (MR1A),A
            OUT     (MR1B),A
            LD      A,00010111B         ; Normal Mode,Active CTS,1-Stop
            OUT     (MR2A),A
            OUT     (MR2B),A
            LD      A,00000011B         ; Enable CTSAN,CTSBN
            OUT     (SET_OUT),A         ; After This OP0,OP1 Control By CTS
            ;
            LD      A,10111011B         ; RX,TX Baud = 9600 (X-TAL 3.6864MHz)
            OUT     (CSRA),A
            OUT     (CSRB),A
            LD      A,11110000B         ; Timer=X=TAL/16 & Disable IP Interupt
            OUT     (ACR),A             ; Baudrate Set2(75-19.2Bps)
            LD      A,00000000B         ; Disable All Interupt
            OUT     (IMR),A             ; Interupt Mask Register
            RET

;/********************************/;
;/* Transmit ASCII 1Byte to 2681 */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : Async. Ch-A       */;
;/********************************/;
;
TXA_2681:   PUSH    AF
TXA_EMTY:   IN      A,(SRA)             ; Read Status
            BIT     3,A
            JR      Z,TXA_EMTY          ; Wait TxEMT
            POP     AF
            OUT     (THRA),A            ; Send Character
            RET

;/********************************/;
;/* Transmit ASCII 1Byte to 2681 */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : Async. Ch-B       */;
;/********************************/;
;
TXB_2681:   PUSH    AF
TXB_EMTY:   IN      A,(SRB)             ; Read Status
            BIT     3,A
            JR      Z,TXB_EMTY          ; Wait TxEMT
            POP     AF
            OUT     (THRB),A            ; Send Character
            RET

;/*************************/;
;/* Receive Data From SCI */;
;/* INPUT  : Async. Ch-A  */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RXA_2681:   IN      A,(SRA)             ; Read status reg
            BIT     0,A
            JR      NZ,READ_RXA         ; RxRDY = "1" Jump
            LD      A,00H
            JP      EXIT_RXA
READ_RXA:   IN      A,(RHRA)            ; Read Data
EXIT_RXA:   RET

;/*************************/;
;/* Receive Data From SCI */;
;/* INPUT  : Async. Ch-B  */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RXB_2681:   IN      A,(SRB)             ; Read status reg
            BIT     0,A
            JR      NZ,READ_RXB         ; RxRDY = "1" Jump
            LD      A,00H
            JP      EXIT_RXB
READ_RXB:   IN      A,(RHRB)            ; Read Data
EXIT_RXB:   RET

            END
            
