;/***********************************/;
;/* Demo Program For CP-68HC11 V2.0 */;
;/* File Name : TIMER.ASM           */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : AS11NEW.EXE         */;
;/* Execute   : Run on Debug 68HC11 */;
;/* Function  : Timer Mode Active   */;
;/*  (Not Used Hardware Handshake)  */;
;/***********************************/;
;
;/* Address Port of IORQ Decode For CP-68HC11 V2.0
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset=LOW
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ   EQU     $1800               ; IORQ of CP-68HC11 V2.0
MR1A        EQU     PORT_IORQ+$00       ; R/W = Mode Register-A (1st = MR1A)
MR2A        EQU     PORT_IORQ+$00       ; R/W = Mode Register-A (2nd = MR2A)
CSRA        EQU     PORT_IORQ+$01       ; W = Clock Select Register-A
SRA         EQU     PORT_IORQ+$01       ; R = Status Register-A
CRA         EQU     PORT_IORQ+$02       ; W = Command Register-A
THRA        EQU     PORT_IORQ+$03       ; W = TX Holding Register-A
RHRA        EQU     PORT_IORQ+$03       ; R = RX Holding Register-A
ACR         EQU     PORT_IORQ+$04       ; W = Aux Control Register
IPCR        EQU     PORT_IORQ+$04       ; R = Input Port Change Register
IMR         EQU     PORT_IORQ+$05       ; W = Interupt Mask Register
ISR         EQU     PORT_IORQ+$05       ; R = Interupt Status Register
CTUR        EQU     PORT_IORQ+$06       ; W/R = Timer Upper
CTLR        EQU     PORT_IORQ+$07       ; W/R = Timer Lower
;
MR1B        EQU     PORT_IORQ+$08       ; R/W = Mode Register-B (1st = MR1B)
MR2B        EQU     PORT_IORQ+$08       ; R/W = Mode Register-B (2nd = MR2B)
CSRB        EQU     PORT_IORQ+$09       ; W = Clock Select Register-B
SRB         EQU     PORT_IORQ+$09       ; R = Status Register-B
CRB         EQU     PORT_IORQ+$0A       ; W = Clock Select Register-B
THRB        EQU     PORT_IORQ+$0B       ; W = TX Holding Register-B
RHRB        EQU     PORT_IORQ+$0B       ; R = RX Holding Register-B
OPCR        EQU     PORT_IORQ+$0D       ; W = Output Port Config Register
INPUT       EQU     PORT_IORQ+$0D       ; R = Input Port
SET_OUT     EQU     PORT_IORQ+$0E       ; W = Set Output Port Bit
STRT_CNT    EQU     PORT_IORQ+$0E       ; R = Strat Counter
CLR_OUT     EQU     PORT_IORQ+$0F       ; W = Clear Output Port Bit
STOP_CNT    EQU     PORT_IORQ+$0F       ; R = Stop Counter

            ORG     $2200               ; Start at Debugger 68HC11
            ;
MAIN        JSR     INIT_TIMER          ; Initial SCN2681 9600,N,8,1
            ;Ex1 N of 1KHz in Timer/1X
            ;    N    = 3.6864MHz/(2x1KHz)
            ;         = 1843.2
            ;    App. = 1843 = 733H
            ;Ex2 N of 1KHz in Timer/16X
            ;    N    = 3.6864MHz/(2x16x1KHz)
            ;         = 115.2 = 73H
            LDAA    #$07                ; 11843.2 = 733H
            STAA    CTUR
            LDAA    #$33
            STAA    CTLR
            LDAA    STRT_CNT            ; Start Timer
            ;
LOOP        BRA     LOOP                ; Loop OP3 = 1KHz

;/****************************/;
;/* Initial SCN2681 to Timer */;
;/* Timer Source = XTAL(1X)  */;
;/* Timer Output = OP3       */;
;/****************************/;
;
INIT_TIMER  ;LDAA    #%01110000          ; Timer = X-TAL/16 & Disable IP Interupt
            LDAA    #%01100000          ; Timer = X-TAL & Disable IP Interupt
            STAA    ACR
            LDAA    #%00000000          ; Disable All Interupt
            STAA    IMR                 ; Interupt Mask Register
            LDAA    #%00000100          ; OP3 = Timer Output
            STAA    OPCR
            RTS

            END

