;/***********************************/;
;/* Demo Program For CP-68HC11 V2.0 */;
;/* File Name : RXTX-INT.ASM        */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : AS11NEW.EXE         */;
;/* Execute   : Run on Debug 68HC11 */;
;/* Function  : Async. RxD,TxD Demo */;
;/*  (Not Used Hardware Handshake)  */;
;/***********************************/;
;
;/* Aysnchronous Format Data = 9600,N,8,1,P
;/* Receive & Transmitt in Interrupt Mode (IRQ)
;/* Receive Data & Echo Receive to Terminal
;/* Address Port of IORQ Decode For CP-68HC11 V2.0
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset = LOW
;/* Set Jumper JP3 Interrupt = INT
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ   EQU     $1800               ; IORQ of CP-68HC11 V2.0
MR1A        EQU     PORT_IORQ+$00       ; R/W = Mode Register-A (1st = MR1A)
MR2A        EQU     PORT_IORQ+$00       ; R/W = Mode Register-A (2nd = MR2A)
CSRA        EQU     PORT_IORQ+$01       ; W = Clock Select Register-A
SRA         EQU     PORT_IORQ+$01       ; R = Status Register-A
CRA         EQU     PORT_IORQ+$02       ; W = Command Register-A
THRA        EQU     PORT_IORQ+$03       ; W = TX Holding Register-A
RHRA        EQU     PORT_IORQ+$03       ; R = RX Holding Register-A
ACR         EQU     PORT_IORQ+$04       ; W = Aux Control Register
IPCR        EQU     PORT_IORQ+$04       ; R = Input Port Change Register
IMR         EQU     PORT_IORQ+$05       ; W = Interupt Mask Register
ISR         EQU     PORT_IORQ+$05       ; R = Interupt Status Register
CTUR        EQU     PORT_IORQ+$06       ; W/R = Timer Upper
CTLR        EQU     PORT_IORQ+$07       ; W/R = Timer Lower
;
MR1B        EQU     PORT_IORQ+$08       ; R/W = Mode Register-B (1st = MR1B)
MR2B        EQU     PORT_IORQ+$08       ; R/W = Mode Register-B (2nd = MR2B)
CSRB        EQU     PORT_IORQ+$09       ; W = Clock Select Register-B
SRB         EQU     PORT_IORQ+$09       ; R = Status Register-B
CRB         EQU     PORT_IORQ+$0A       ; W = Clock Select Register-B
THRB        EQU     PORT_IORQ+$0B       ; W = TX Holding Register-B
RHRB        EQU     PORT_IORQ+$0B       ; R = RX Holding Register-B
OPCR        EQU     PORT_IORQ+$0D       ; W = Output Port Config Register
READ_IN7    EQU     PORT_IORQ+$0D       ; R = Input Port
SET_OUT8    EQU     PORT_IORQ+$0E       ; W = Set Output Port Bit
STRT_CNT    EQU     PORT_IORQ+$0E       ; R = Strat Counter
CLR_OUT8    EQU     PORT_IORQ+$0F       ; W = Clear Output Port Bit
STOP_CNT    EQU     PORT_IORQ+$0F       ; R = Stop Counter

            ORG     $2200               ; Start at Debugger 68HC11
            ;
MAIN        LDAA    #$7E                ; External Jump Opcode
            STAA    $20EE
            LDX     #INT_2681           ; IRQ Service Routine
            STX     $20EF
            JSR     INIT_2681           ; Initial SCN2681 9600,N,8,1
            ;
            JSR     PRN_DAT_A
            FCB     $0D,$0A
            FCC     'Power-On Channel-A of SCN2681'
            FCB     $0D,$0A,$00
            ;
            JSR     PRN_DAT_B
            FCB     $0D,$0A
            FCC     'Power-On Channel-B of SCN2681'
            FCB     $0D,$0A,$00
            ;
            CLI                         ; Enable Global Interrupt
            BRA     *                   ; Loop For Interrupt

;/*************************/;
;/* Initial SCN2681 DUART */;
;/*      9600,N,8,1,P     */;
;/*  Async. Channel-A,B   */;
;/*************************/;
;
INIT_2681   LDAA    #%01000101          ; Reset Error Status & Enable TX,RX
            STAA    CRA
            STAA    CRB
            LDAA    #%00010101          ; MR Pointer = MR1 & Enable TX,RX
            STAA    CRA
            STAA    CRB
            LDAA    #%00010011          ; No RTS,No Parity,8 Bit Data
            STAA    MR1A
            STAA    MR1B
            LDAA    #%00000111          ; Normal Mode,No RTS&CTS,1-Stop
            STAA    MR2A
            STAA    MR2B
            ;
            LDAA    #%10111011          ; RX,TX Baud = 9600 (X-TAL 3.6864MHz)
            STAA    CSRA
            STAA    CSRB
            LDAA    #%11110000          ; Timer=X=TAL/16 & Disable IP Interupt
            STAA    ACR                 ; Baudrate Set2(75-19.2Bps)
            LDAA    #%00100010          ; Enable RxRDYA,RxRDYB Interupt
            STAA    IMR                 ; Interupt Mask Register
            RTS

;/********************************/;
;/* Transmit ASCII 1Byte to 2681 */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : Async. Ch-A       */;
;/********************************/;
;
TXA_2681    PSHB
TXA_EMTY    LDAB    SRA                 ; Read Status
            ANDB    #%00001000
            BEQ     TXA_EMTY            ; Wait TxEMT
            STAA    THRA                ; Send Character
            PULB
            RTS

;/********************************/;
;/* Transmit ASCII 1Byte to 2681 */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : Async. Ch-B       */;
;/********************************/;
;
TXB_2681    PSHB
TXB_EMTY    LDAB    SRB                 ; Read Status
            ANDB    #%00001000
            BEQ     TXB_EMTY            ; Wait TxEMT
            STAA    THRB                ; Send Character
            PULB
            RTS

;/***********************/;
;/* IRQ Service Routine */;
;/*  Active By SCN2681  */;
;/***********************/;
;
INT_2681    LDAA    ISR                 ; Read Reason of Interrupt
            ANDA    #%00100010          ; Check RxRDYA,RxRDYA Only
            CMPA    #%00100000          ; RxRDYB = "1" ?
            BEQ     GET_DAT2
            ;
            LDAA    RHRA                ; Read Channal-A
            CMPA    #$0D
            BNE     ECHO_DAT1
            JSR     PRN_DAT_A
            FCB     $0D,$0A
            FCC     'This is Channel-A of SCN2681'
            FCB     $0D,$0A,$00
            BRA     INT_EXIT
            ;
ECHO_DAT1   JSR     TXA_2681            ; Echo Receive-A
            BRA     INT_EXIT
            ;
GET_DAT2    LDAA    RHRB                ; Read Channal-B
            CMPA    #$0D
            BNE     ECHO_DAT2
            JSR     PRN_DAT_B
            FCB     $0D,$0A
            FCC     'This is Channel-B of SCN2681'
            FCB     $0D,$0A,$00
            BRA     INT_EXIT
            ;
ECHO_DAT2   JSR     TXB_2681            ; Echo Receive-B
INT_EXIT    RTI

;/*******************************/;
;/* Print Out Data to 2681 Port */;
;/* Usage     : JSR   PRN_DAT_A */;
;/*           : FCC   'xxxxxx'  */;
;/*           : FCB   $00       */;
;/* Register  : ACCA            */;
;/* Call Sub  : TXA_2681        */;
;/* Note      : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRN_DAT_A   PULX                            ; Pop Stack (PC Value)
PRN_DAT1A   LDAA    0,X                     ; Get Data For Print
            CMPA    #$00                    ; Check Last Byte
            BNE     PRN_DAT2A               ; Jump if not Last Byte
            BRA     PRN_DAT3A
PRN_DAT2A   JSR     TXA_2681                ; Send Data
            INX
            BRA     PRN_DAT1A
PRN_DAT3A   INX                             ; Point to Next Instruction
            PSHX                            ; Push Stack (PC Value)
            RTS

;/*******************************/;
;/* Print Out Data to 2681 Port */;
;/* Usage     : JSR   PRN_DAT_B */;
;/*           : FCC   'xxxxxx'  */;
;/*           : FCB   $00       */;
;/* Register  : ACCA            */;
;/* Call Sub  : TXB_2681        */;
;/* Note      : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRN_DAT_B   PULX                            ; Pop Stack (PC Value)
PRN_DAT1B   LDAA    0,X                     ; Get Data For Print
            CMPA    #$00                    ; Check Last Byte
            BNE     PRN_DAT2B               ; Jump if not Last Byte
            BRA     PRN_DAT3B
PRN_DAT2B   JSR     TXB_2681                ; Send Data
            INX
            BRA     PRN_DAT1B
PRN_DAT3B   INX                             ; Point to Next Instruction
            PSHX                            ; Push Stack (PC Value)
            RTS

            END

