;/***********************************/;
;/* Demo Program For CP-68HC11 V2.0 */;
;/* File Name : DEMORXTX.ASM        */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : AS11NEW.EXE         */;
;/* Execute   : Run on Debug 68HC11 */;
;/* Function  : Async. RxD,TxD Demo */;
;/*  (Not Used Hardware Handshake)  */;
;/***********************************/;
;
;/* Aysnchronous Format Data = 9600,N,8,1,P
;/* Receive & Transmitt in Polling Mode
;/* Receive Data & Echo Receive to Terminal
;/* Address Port of IORQ Decode For CP-68HC11 V2.0
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset = LOW
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ   EQU     $1800               ; IORQ of CP-68HC11 V2.0
MR1A        EQU     PORT_IORQ+$00       ; R/W = Mode Register-A (1st = MR1A)
MR2A        EQU     PORT_IORQ+$00       ; R/W = Mode Register-A (2nd = MR2A)
CSRA        EQU     PORT_IORQ+$01       ; W = Clock Select Register-A
SRA         EQU     PORT_IORQ+$01       ; R = Status Register-A
CRA         EQU     PORT_IORQ+$02       ; W = Command Register-A
THRA        EQU     PORT_IORQ+$03       ; W = TX Holding Register-A
RHRA        EQU     PORT_IORQ+$03       ; R = RX Holding Register-A
ACR         EQU     PORT_IORQ+$04       ; W = Aux Control Register
IPCR        EQU     PORT_IORQ+$04       ; R = Input Port Change Register
IMR         EQU     PORT_IORQ+$05       ; W = Interupt Mask Register
ISR         EQU     PORT_IORQ+$05       ; R = Interupt Status Register
CTUR        EQU     PORT_IORQ+$06       ; W/R = Timer Upper
CTLR        EQU     PORT_IORQ+$07       ; W/R = Timer Lower
;
MR1B        EQU     PORT_IORQ+$08       ; R/W = Mode Register-B (1st = MR1B)
MR2B        EQU     PORT_IORQ+$08       ; R/W = Mode Register-B (2nd = MR2B)
CSRB        EQU     PORT_IORQ+$09       ; W = Clock Select Register-B
SRB         EQU     PORT_IORQ+$09       ; R = Status Register-B
CRB         EQU     PORT_IORQ+$0A       ; W = Clock Select Register-B
THRB        EQU     PORT_IORQ+$0B       ; W = TX Holding Register-B
RHRB        EQU     PORT_IORQ+$0B       ; R = RX Holding Register-B
OPCR        EQU     PORT_IORQ+$0D       ; W = Output Port Config Register
READ_IN7    EQU     PORT_IORQ+$0D       ; R = Input Port
SET_OUT8    EQU     PORT_IORQ+$0E       ; W = Set Output Port Bit
STRT_CNT    EQU     PORT_IORQ+$0E       ; R = Strat Counter
CLR_OUT8    EQU     PORT_IORQ+$0F       ; W = Clear Output Port Bit
STOP_CNT    EQU     PORT_IORQ+$0F       ; R = Stop Counter

            ORG     $2200               ; Start at Debugger 68HC11
            ;
MAIN        JSR     INIT_2681           ; Initial SCN2681 9600,N,8,1
            JSR     PRN_DAT_A
            FCB     $0D,$0A
            FCC     'Power-On Channel-A of SCN2681'
            FCB     $0D,$0A,$00
            ;
            JSR     PRN_DAT_B
            FCB     $0D,$0A
            FCC     'Power-On Channel-B of SCN2681'
            FCB     $0D,$0A,$00
            ;
WAIT_DAT1   JSR     RXA_2681            ; Wait Receive Channel-A
            CMPA    #$00
            BEQ     WAIT_DAT2
            CMPA    #$0D
            BNE     ECHO_DAT1
            JSR     PRN_DAT_A
            FCB     $0D,$0A
            FCC     'This is Channel-A of SCN2681'
            FCB     $0D,$0A,$00
            BRA     WAIT_DAT1
            ;
ECHO_DAT1   JSR     TXA_2681            ; Echo Receive-A
            BRA     WAIT_DAT1
            ;
WAIT_DAT2   JSR     RXB_2681            ; Wait Receive Channel-B
            CMPA    #$00
            BEQ     WAIT_DAT1
            CMPA    #$0D
            BNE     ECHO_DAT2
            JSR     PRN_DAT_B
            FCB     $0D,$0A
            FCC     'This is Channel-B of SCN2681'
            FCB     $0D,$0A,$00
            BRA     WAIT_DAT1
            ;
ECHO_DAT2   JSR     TXB_2681            ; Echo Receive-B
            BRA     WAIT_DAT1

;/*************************/;
;/* Initial SCN2681 DUART */;
;/*      9600,N,8,1,P     */;
;/*  Async. Channel-A,B   */;
;/*************************/;
;
INIT_2681   LDAA    #%01000101          ; Reset Error Status & Enable TX,RX
            STAA    CRA
            STAA    CRB
            LDAA    #%00010101          ; MR Pointer = MR1 & Enable TX,RX
            STAA    CRA
            STAA    CRB
            LDAA    #%00010011          ; No RTS,No Parity,8 Bit Data
            STAA    MR1A
            STAA    MR1B
            LDAA    #%00000111          ; Normal Mode,No RTS&CTS,1-Stop
            STAA    MR2A
            STAA    MR2B
            ;
            LDAA    #%10111011          ; RX,TX Baud = 9600 (X-TAL 3.6864MHz)
            STAA    CSRA
            STAA    CSRB
            LDAA    #%11110000          ; Timer=X=TAL/16 & Disable IP Interupt
            STAA    ACR                 ; Baudrate Set2(75-19.2Bps)
            LDAA    #%00000000          ; Disable All Interupt
            STAA    IMR                 ; Interupt Mask Register
            RTS

;/********************************/;
;/* Transmit ASCII 1Byte to 2681 */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : Async. Ch-A       */;
;/********************************/;
;
TXA_2681    PSHB
TXA_EMTY    LDAB    SRA                 ; Read Status
            ANDB    #%00001000
            BEQ     TXA_EMTY            ; Wait TxEMT
            STAA    THRA                ; Send Character
            PULB
            RTS

;/********************************/;
;/* Transmit ASCII 1Byte to 2681 */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : Async. Ch-B       */;
;/********************************/;
;
TXB_2681    PSHB
TXB_EMTY    LDAB    SRB                 ; Read Status
            ANDB    #%00001000
            BEQ     TXB_EMTY            ; Wait TxEMT
            STAA    THRB                ; Send Character
            PULB
            RTS

;/*************************/;
;/* Receive Data From SCI */;
;/* INPUT  : Async. Ch-A  */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RXA_2681    LDAA    SRA                 ; Read status reg
            ANDA    #%00000001          ; RxRDY
            BNE     READ_RXA            ; RxRDY = "1" Jump
            CLRA
            BRA     EXIT_RXA
READ_RXA    LDAA    RHRA                ; Read Data
EXIT_RXA    RTS

;/*************************/;
;/* Receive Data From SCI */;
;/* INPUT  : Async. Ch-B  */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RXB_2681    LDAA    SRB                 ; Read status reg
            ANDA    #%00000001          ; RxRDY
            BNE     READ_RXB            ; RxRDY = "1" Jump
            CLRA
            BRA     EXIT_RXB
READ_RXB    LDAA    RHRB                ; Read Data
EXIT_RXB    RTS

;/*******************************/;
;/* Print Out Data to 2681 Port */;
;/* Usage     : JSR   PRN_DAT_A */;
;/*           : FCC   'xxxxxx'  */;
;/*           : FCB   $00       */;
;/* Register  : ACCA            */;
;/* Call Sub  : TXA_2681        */;
;/* Note      : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRN_DAT_A   PULX                            ; Pop Stack (PC Value)
PRN_DAT1A   LDAA    0,X                     ; Get Data For Print
            CMPA    #$00                    ; Check Last Byte
            BNE     PRN_DAT2A               ; Jump if not Last Byte
            BRA     PRN_DAT3A
PRN_DAT2A   JSR     TXA_2681                ; Send Data
            INX
            BRA     PRN_DAT1A
PRN_DAT3A   INX                             ; Point to Next Instruction
            PSHX                            ; Push Stack (PC Value)
            RTS

;/*******************************/;
;/* Print Out Data to 2681 Port */;
;/* Usage     : JSR   PRN_DAT_B */;
;/*           : FCC   'xxxxxx'  */;
;/*           : FCB   $00       */;
;/* Register  : ACCA            */;
;/* Call Sub  : TXB_2681        */;
;/* Note      : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRN_DAT_B   PULX                            ; Pop Stack (PC Value)
PRN_DAT1B   LDAA    0,X                     ; Get Data For Print
            CMPA    #$00                    ; Check Last Byte
            BNE     PRN_DAT2B               ; Jump if not Last Byte
            BRA     PRN_DAT3B
PRN_DAT2B   JSR     TXB_2681                ; Send Data
            INX
            BRA     PRN_DAT1B
PRN_DAT3B   INX                             ; Point to Next Instruction
            PSHX                            ; Push Stack (PC Value)
            RTS

            END

