;/***********************************/;
;/* Demo Program For CP-68HC11 V2.0 */;
;/* File Name : DEMOOUT8.ASM        */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : AS11NEW.EXE         */;
;/* Execute   : Run on Debug 68HC11 */;
;/* Function  : General Output-8    */;
;/***********************************/;
;
;/* Demo to Control General of Output-8
;/* Movelight LED on Port Output-8
;/* Address Port of IORQ Decode For CP-68HC11 V2.0
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset = LOW
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ   EQU     $1800               ; IORQ of CP-68HC11 V2.0
MR1A        EQU     PORT_IORQ+$00       ; R/W = Mode Register-A (1st = MR1A)
MR2A        EQU     PORT_IORQ+$00       ; R/W = Mode Register-A (2nd = MR2A)
CSRA        EQU     PORT_IORQ+$01       ; W = Clock Select Register-A
SRA         EQU     PORT_IORQ+$01       ; R = Status Register-A
CRA         EQU     PORT_IORQ+$02       ; W = Command Register-A
THRA        EQU     PORT_IORQ+$03       ; W = TX Holding Register-A
RHRA        EQU     PORT_IORQ+$03       ; R = RX Holding Register-A
ACR         EQU     PORT_IORQ+$04       ; W = Aux Control Register
IPCR        EQU     PORT_IORQ+$04       ; R = Input Port Change Register
IMR         EQU     PORT_IORQ+$05       ; W = Interupt Mask Register
ISR         EQU     PORT_IORQ+$05       ; R = Interupt Status Register
CTUR        EQU     PORT_IORQ+$06       ; W/R = Timer Upper
CTLR        EQU     PORT_IORQ+$07       ; W/R = Timer Lower
;
MR1B        EQU     PORT_IORQ+$08       ; R/W = Mode Register-B (1st = MR1B)
MR2B        EQU     PORT_IORQ+$08       ; R/W = Mode Register-B (2nd = MR2B)
CSRB        EQU     PORT_IORQ+$09       ; W = Clock Select Register-B
SRB         EQU     PORT_IORQ+$09       ; R = Status Register-B
CRB         EQU     PORT_IORQ+$0A       ; W = Clock Select Register-B
THRB        EQU     PORT_IORQ+$0B       ; W = TX Holding Register-B
RHRB        EQU     PORT_IORQ+$0B       ; R = RX Holding Register-B
OPCR        EQU     PORT_IORQ+$0D       ; W = Output Port Config Register
READ_IN7    EQU     PORT_IORQ+$0D       ; R = Input Port
SET_OUT8    EQU     PORT_IORQ+$0E       ; W = Set Output Port Bit
STRT_CNT    EQU     PORT_IORQ+$0E       ; R = Strat Counter
CLR_OUT8    EQU     PORT_IORQ+$0F       ; W = Clear Output Port Bit
STOP_CNT    EQU     PORT_IORQ+$0F       ; R = Stop Counter

            ORG     $2200               ; Start at Debugger 68HC11
OUT_2681    LDAA    #%00000000          ; All Bit Output = General Output
            STAA    OPCR
            LDAA    #%11111111          ; Clear All Output Port
            STAA    CLR_OUT8
            ;
LOOP_OUT1   LDAB    #8                  ; 8-Bit Output Counter
            LDY     #TAB_OUT            ; Table Data Output
            ;
LOOP_OUT2   LDAA    0,Y                 ; Get Data
            COMA                        ; Toggle Logic Output
            ;
            PSHA                        ; Save Data Output
            LDAA    #%11111111
            STAA    SET_OUT8            ; Clear Old Data Output Pin
            PULA                        ; Restore Data Output
            STAA    CLR_OUT8            ; Write New Data Output Pin
            JSR     DELAY
            ;
            INY
            DECB
            BNE     LOOP_OUT2
            BRA     LOOP_OUT1

;/***********************/;
;/* Data Output Control */;
;/***********************/;
;
TAB_OUT     FCB     $01,$02,$04,$08
            FCB     $10,$20,$40,$80

;/**********************/;
;/* Delay Time 1Second */;
;/**********************/;
;
DELAY       PSHB                        ; Save Register
            PSHX
            LDAB    #100                ; 10mS x 100 = 1Second
DLY1        LDX     #$0D06              ; 10mS Count
DLY2        DEX
            BNE     DLY2
            DECB
            BNE     DLY1
            PULX                        ; Restore Register
            PULB
            RTS

            END




