;/***********************************/;
;/* Demo Program For CP-68HC11 V2.0 */;
;/* File Name : DEMOIN7.ASM         */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : AS11NEW.EXE         */;
;/* Execute   : Run on Debug 68HC11 */;
;/* Function  : General Input-7     */;
;/***********************************/;
;
;/* Demo to Read General Input-7
;/* Read Input & Display on SCI Port of 68HC11
;/* Address Port of IORQ Decode For CP-68HC11 V2.0
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset = LOW
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ   EQU     $1800               ; IORQ of CP-68HC11 V2.0
MR1A        EQU     PORT_IORQ+$00       ; R/W = Mode Register-A (1st = MR1A)
MR2A        EQU     PORT_IORQ+$00       ; R/W = Mode Register-A (2nd = MR2A)
CSRA        EQU     PORT_IORQ+$01       ; W = Clock Select Register-A
SRA         EQU     PORT_IORQ+$01       ; R = Status Register-A
CRA         EQU     PORT_IORQ+$02       ; W = Command Register-A
THRA        EQU     PORT_IORQ+$03       ; W = TX Holding Register-A
RHRA        EQU     PORT_IORQ+$03       ; R = RX Holding Register-A
ACR         EQU     PORT_IORQ+$04       ; W = Aux Control Register
IPCR        EQU     PORT_IORQ+$04       ; R = Input Port Change Register
IMR         EQU     PORT_IORQ+$05       ; W = Interupt Mask Register
ISR         EQU     PORT_IORQ+$05       ; R = Interupt Status Register
CTUR        EQU     PORT_IORQ+$06       ; W/R = Timer Upper
CTLR        EQU     PORT_IORQ+$07       ; W/R = Timer Lower
;
MR1B        EQU     PORT_IORQ+$08       ; R/W = Mode Register-B (1st = MR1B)
MR2B        EQU     PORT_IORQ+$08       ; R/W = Mode Register-B (2nd = MR2B)
CSRB        EQU     PORT_IORQ+$09       ; W = Clock Select Register-B
SRB         EQU     PORT_IORQ+$09       ; R = Status Register-B
CRB         EQU     PORT_IORQ+$0A       ; W = Clock Select Register-B
THRB        EQU     PORT_IORQ+$0B       ; W = TX Holding Register-B
RHRB        EQU     PORT_IORQ+$0B       ; R = RX Holding Register-B
OPCR        EQU     PORT_IORQ+$0D       ; W = Output Port Config Register
READ_IN7    EQU     PORT_IORQ+$0D       ; R = Input Port
SET_OUT8    EQU     PORT_IORQ+$0E       ; W = Set Output Port Bit
STRT_CNT    EQU     PORT_IORQ+$0E       ; R = Strat Counter
CLR_OUT8    EQU     PORT_IORQ+$0F       ; W = Clear Output Port Bit
STOP_CNT    EQU     PORT_IORQ+$0F       ; R = Stop Counter
;
BAUD        EQU     $102B               ; SCI Baud rate control Reg.
SCCR1       EQU     $102C               ; SCI Control Register1
SCCR2       EQU     $102D               ; SCI Control Register2
SCSR        EQU     $102E               ; SCI Status Register
SCDR        EQU     $102F               ; SCI Data (RDR=Read,TDR=Write)

            ORG     $00
INPUT_BUF   RMB     1                   ; Buffer old Input Read

            ORG     $2200               ; Start at Debugger 68HC11
MAIN        JSR     INIT_SCI            ; Initial SCI 9600,N,8,1
            JSR     PRINT_SCI
            FCB     $0D,$0A,$0D,$0A
            FCC     '**Input-7**'       ; Message on Header
            FCB     $0D,$0A,$00
            ;
READ_INP    LDAA    READ_IN7            ; Read Input-7
            CMPA    INPUT_BUF
            BEQ     READ_INP            ; Not Change Loop
            STAA    INPUT_BUF           ; Update Buffer
            ;
SHOW_INP    LDAB    INPUT_BUF
            COMB                        ; Invert Logic
            BEQ     READ_INP            ; Not Display 00H
            LSLB                        ; Shift Bit-7 to Carry
            LDAA    #'X'                ; Display Bit-7
            JSR     TX_SCI
            CLRA
            LSLB                        ; Shift Bit-6 to Carry
            ADCA    #$30                ; Convert to ASCII
            JSR     TX_SCI
            CLRA
            LSLB                        ; Shift Bit-5 to Carry
            ADCA    #$30                ; Convert to ASCII
            JSR     TX_SCI
            CLRA
            LSLB                        ; Shift Bit-4 to Carry
            ADCA    #$30                ; Convert to ASCII
            JSR     TX_SCI
            CLRA
            LSLB                        ; Shift Bit-3 to Carry
            ADCA    #$30                ; Convert to ASCII
            JSR     TX_SCI
            CLRA
            LSLB                        ; Shift Bit-2 to Carry
            ADCA    #$30                ; Convert to ASCII
            JSR     TX_SCI
            CLRA
            LSLB                        ; Shift Bit-1 to Carry
            ADCA    #$30                ; Convert to ASCII
            JSR     TX_SCI
            CLRA
            LSLB                        ; Shift Bit-0 to Carry
            ADCA    #$30                ; Convert to ASCII
            JSR     TX_SCI
            LDAA    #$0D
            JSR     TX_SCI
            BRA     READ_INP
            
;/********************************/;
;/* Print ASCII data to LCD Port */;
;/* Usage    : JSR  PRINT_SCI    */;
;/*          : FCC  'xxxxxxxx'   */;
;/*          : FCB  $00          */;
;/* Note     : last byte = $00   */;
;/********************************/;
;
PRINT_SCI   PULX                        ; Pop Stack
            PSHA
            PSHB
PRINT1      LDAA    0,X                 ; Get Data For Print
            CMPA    #$00                ; Check Last Byte
            BNE     PRINT2              ; Jump if not Last Byte
            BRA     PRINT3
PRINT2      JSR     TX_SCI              ; Write Data to LCD
            INX
            BRA     PRINT1
PRINT3      INX
            PULB
            PULA
            PSHX                        ; Push Stack
            RTS

;/***************************************/;
;/* Initial the SCI Port for 68HC11 CPU */;
;/* Baud rate  : Crystal Oscilator 8MHz */;
;/* Format SCI : Data 8 bit, 1 Stop bit */;
;/***************************************/;
;
INIT_SCI    LDAA    #%00110000          ; Set Baud rate 9600
            ;LDAA    #%00110001          ; Set Baud rate 4800
            ;LDAA    #%00110010          ; Set Baud rate 2400
            ;LDAA    #%00110011          ; Set Baud rate 1200
            STAA    BAUD
            LDAA    #$00
            STAA    SCCR1               ; Set 8bit data,1 Stop bit
            LDAA    #$0C                ; Enable RXD,TXD pin
            STAA    SCCR2
            RTS

;/********************************/;
;/* Transmit ASCII 1byte to SCI  */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : ASCII to SCI Port */;
;/* Register : ACCA,ACCB         */;
;/********************************/;
;
TX_SCI      PSHB
TX_SCI1     LDAB    SCSR                ; Read Status
            BITB    #$80
            BEQ     TX_SCI1             ; Wait Ready to Send (TDRE=1)
            STAA    SCDR                ; Send character to SCI
            PULB
            RTS

;/*************************/;
;/* Receive data from SCI */;
;/* INPUT  : SCI Port     */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RX_SCI      LDAA    SCSR                ; Read status reg
            ANDA    #$20                ; Check RDRF
            BEQ     RX_SCI              ; Loop if no Data
            LDAA    SCDR                ; Read Data
            RTS

            END



