;/***********************************/;
;/* Demo Program For ET-CPSB31 V2.0 */;
;/* File Name : TIMER.ASM           */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : SXA51.EXE           */;
;/* Execute   : Run on Debug 8031   */;
;/* Function  : Timer Mode Active   */;
;/***********************************/;
;
;/* Demo to Control General of Output-8
;/* Movelight LED on Port Output-8
;/* Address Port of IORQ Decode For CP-SB31V2 V2.0
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset = High
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ   EQU     0E000H              ; IORQ of CP-68HC11 V2.0
MR1A        EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (1st = MR1A)
MR2A        EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (2nd = MR2A)
CSRA        EQU     PORT_IORQ+01H       ; W = Clock Select Register-A
SRA         EQU     PORT_IORQ+01H       ; R = Status Register-A
CRA         EQU     PORT_IORQ+02H       ; W = Command Register-A
THRA        EQU     PORT_IORQ+03H       ; W = TX Holding Register-A
RHRA        EQU     PORT_IORQ+03H       ; R = RX Holding Register-A
ACR         EQU     PORT_IORQ+04H       ; W = Aux Control Register
IPCR        EQU     PORT_IORQ+04H       ; R = Input Port Change Register
IMR         EQU     PORT_IORQ+05H       ; W = Interupt Mask Register
ISR         EQU     PORT_IORQ+05H       ; R = Interupt Status Register
CTUR        EQU     PORT_IORQ+06H       ; W/R = Timer Upper
CTLR        EQU     PORT_IORQ+07H       ; W/R = Timer Lower
;
MR1B        EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (1st = MR1B)
MR2B        EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (2nd = MR2B)
CSRB        EQU     PORT_IORQ+09H       ; W = Clock Select Register-B
SRB         EQU     PORT_IORQ+09H       ; R = Status Register-B
CRB         EQU     PORT_IORQ+0AH       ; W = Clock Select Register-B
THRB        EQU     PORT_IORQ+0BH       ; W = TX Holding Register-B
RHRB        EQU     PORT_IORQ+0BH       ; R = RX Holding Register-B
OPCR        EQU     PORT_IORQ+0DH       ; W = Output Port Config Register
INPUT7      EQU     PORT_IORQ+0DH       ; R = Input Port
SET_OUT8    EQU     PORT_IORQ+0EH       ; W = Set Output Port Bit
STRT_CNT    EQU     PORT_IORQ+0EH       ; R = Strat Counter
CLR_OUT8    EQU     PORT_IORQ+0FH       ; W = Clear Output Port Bit
STOP_CNT    EQU     PORT_IORQ+0FH       ; R = Stop Counter

            ORG     2200H               ; Start at Debugger 8031
            ;
MAIN:       LCALL   INIT_TIMER
            ;Ex1 N of 1KHz in Timer/1X
            ;    N    = 3.6864MHz/(2x1KHz)
            ;         = 1843.2
            ;    App. = 1843 = 733H
            ;Ex2 N of 1KHz in Timer/16X
            ;    N    = 3.6864MHz/(2x16x1KHz)
            ;         = 115.2 = 73H
            MOV     A,#07H              ; 11843.2 = 733H
            MOV     DPTR,#CTUR
            MOVX    @DPTR,A
            MOV     A,#33H
            MOV     DPTR,#CTLR
            MOVX    @DPTR,A
            MOV     DPTR,#STRT_CNT      ; Start Timer
            MOVX    A,@DPTR
            ;
LOOP:       SJMP    LOOP                ; Loop OP3 = 1KHz

;/****************************/;
;/* Initial SCN2681 to Timer */;
;/* Timer Source = XTAL(1X)  */;
;/* Timer Output = OP3       */;
;/****************************/;
;
INIT_TIMER: ;MOV     A,#01110000B        ; Timer = X-TAL/16 & Disable IP Interupt
            MOV     A,#01100000B        ; Timer = X-TAL & Disable IP Interupt
            MOV     DPTR,#ACR
            MOVX    @DPTR,A
            MOV     A,#00000000B        ; Disable All Interupt
            MOV     DPTR,#IMR           ; Interupt Mask Register
            MOVX    @DPTR,A
            MOV     A,#00000100B        ; OP3 = Timer Output
            MOV     DPTR,#OPCR
            MOVX    @DPTR,A
            RET

            END


