;/***********************************/;
;/* Demo Program For ET-CPSB31 V2.0 */;
;/* File Name : DEMOOUT8.ASM        */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : SXA51.EXE           */;
;/* Execute   : Run on Debug 8031   */;
;/* Function  : General Output-8    */;
;/***********************************/;
;
;/* Demo to Control General of Output-8
;/* Movelight LED on Port Output-8
;/* Address Port of IORQ Decode For CP-SB31V2 V2.0
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset = High
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ   EQU     0E000H              ; IORQ of CP-68HC11 V2.0
MR1A        EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (1st = MR1A)
MR2A        EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (2nd = MR2A)
CSRA        EQU     PORT_IORQ+01H       ; W = Clock Select Register-A
SRA         EQU     PORT_IORQ+01H       ; R = Status Register-A
CRA         EQU     PORT_IORQ+02H       ; W = Command Register-A
THRA        EQU     PORT_IORQ+03H       ; W = TX Holding Register-A
RHRA        EQU     PORT_IORQ+03H       ; R = RX Holding Register-A
ACR         EQU     PORT_IORQ+04H       ; W = Aux Control Register
IPCR        EQU     PORT_IORQ+04H       ; R = Input Port Change Register
IMR         EQU     PORT_IORQ+05H       ; W = Interupt Mask Register
ISR         EQU     PORT_IORQ+05H       ; R = Interupt Status Register
CRUR        EQU     PORT_IORQ+06H       ; W/R = Timer Upper
CTLR        EQU     PORT_IORQ+07H       ; W/R = Timer Lower
;
MR1B        EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (1st = MR1B)
MR2B        EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (2nd = MR2B)
CSRB        EQU     PORT_IORQ+09H       ; W = Clock Select Register-B
SRB         EQU     PORT_IORQ+09H       ; R = Status Register-B
CRB         EQU     PORT_IORQ+0AH       ; W = Clock Select Register-B
THRB        EQU     PORT_IORQ+0BH       ; W = TX Holding Register-B
RHRB        EQU     PORT_IORQ+0BH       ; R = RX Holding Register-B
OPCR        EQU     PORT_IORQ+0DH       ; W = Output Port Config Register
INPUT7      EQU     PORT_IORQ+0DH       ; R = Input Port
SET_OUT8    EQU     PORT_IORQ+0EH       ; W = Set Output Port Bit
STRT_CNT    EQU     PORT_IORQ+0EH       ; R = Strat Counter
CLR_OUT8    EQU     PORT_IORQ+0FH       ; W = Clear Output Port Bit
STOP_CNT    EQU     PORT_IORQ+0FH       ; R = Stop Counter

            ORG     2200H               ; Start at Debugger 8031
            ;
OUT_2681:   MOV     DPTR,#OPCR
            MOV     A,#00000000B        ; All Bit Output = General Output
            MOVX    @DPTR,A
            MOV     DPTR,#CLR_OUT8
            MOV     A,#11111111B        ; Clear All Output Port
            MOVX    @DPTR,A
            ;
LOOP_OUT1:  MOV     R2,#8               ; 8-Bit Output Counter
            MOV     DPTR,#TAB_OUT       ; Table Data Output
            ;
LOOP_OUT2:  CLR     A
            MOVC    A,@A+DPTR           ; Get Data
            CPL     A                   ; Toggle Logic Output
            ;
            PUSH    DPH                 ; Save Data Output
            PUSH    DPL
            PUSH    ACC
            ;
            MOV     A,#11111111B
            MOV     DPTR,#SET_OUT8      ; Clear Old Data Output Pin
            MOVX    @DPTR,A
            ;
            MOV     DPTR,#CLR_OUT8      ; Write New Data Output Pin
            POP     ACC                 ; Restore Data Output
            MOVX    @DPTR,A
            POP     DPL
            POP     DPH
            ;
            LCALL   DELAY
            ;
            INC     DPTR
            DJNZ    R2,LOOP_OUT2
            SJMP    LOOP_OUT1

;/***********************/;
;/* Data Output Control */;
;/***********************/;
;
TAB_OUT:    DB      01H,02H,04H,08H
            DB      10H,20H,40H,80H

;/**************/;
;/* Delay Time */;
;/**************/;
;
DELAY:      MOV     R3,#5
DLY0:       MOV     R4,#0
DLY1:       MOV     R5,#0
            DJNZ    R5,$
            DJNZ    R4,DLY1
            DJNZ    R3,DLY0
            RET

            END

