;/***********************************/;
;/* Demo Program For ET-CPSB31 V2.0 */;
;/* File Name : DEMOIN7.ASM         */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : SXA51.EXE           */;
;/* Execute   : Run on Debug 8031   */;
;/* Function  : General Input-7     */;
;/***********************************/;
;
;/* Demo to Read General Input-7
;/* Read Input & Display on SCI Port of 68HC11
;/* Address Port of IORQ Decode For CP-SB31V2 V2.0
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset = High
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ   EQU     0E000H              ; IORQ of CP-68HC11 V2.0
MR1A        EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (1st = MR1A)
MR2A        EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (2nd = MR2A)
CSRA        EQU     PORT_IORQ+01H       ; W = Clock Select Register-A
SRA         EQU     PORT_IORQ+01H       ; R = Status Register-A
CRA         EQU     PORT_IORQ+02H       ; W = Command Register-A
THRA        EQU     PORT_IORQ+03H       ; W = TX Holding Register-A
RHRA        EQU     PORT_IORQ+03H       ; R = RX Holding Register-A
ACR         EQU     PORT_IORQ+04H       ; W = Aux Control Register
IPCR        EQU     PORT_IORQ+04H       ; R = Input Port Change Register
IMR         EQU     PORT_IORQ+05H       ; W = Interupt Mask Register
ISR         EQU     PORT_IORQ+05H       ; R = Interupt Status Register
CRUR        EQU     PORT_IORQ+06H       ; W/R = Timer Upper
CTLR        EQU     PORT_IORQ+07H       ; W/R = Timer Lower
;
MR1B        EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (1st = MR1B)
MR2B        EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (2nd = MR2B)
CSRB        EQU     PORT_IORQ+09H       ; W = Clock Select Register-B
SRB         EQU     PORT_IORQ+09H       ; R = Status Register-B
CRB         EQU     PORT_IORQ+0AH       ; W = Clock Select Register-B
THRB        EQU     PORT_IORQ+0BH       ; W = TX Holding Register-B
RHRB        EQU     PORT_IORQ+0BH       ; R = RX Holding Register-B
OPCR        EQU     PORT_IORQ+0DH       ; W = Output Port Config Register
READ_IN7    EQU     PORT_IORQ+0DH       ; R = Input Port
SET_OUT8    EQU     PORT_IORQ+0EH       ; W = Set Output Port Bit
STRT_CNT    EQU     PORT_IORQ+0EH       ; R = Strat Counter
CLR_OUT8    EQU     PORT_IORQ+0FH       ; W = Clear Output Port Bit
STOP_CNT    EQU     PORT_IORQ+0FH       ; R = Stop Counter

INPUT_BUF   EQU     22H                 ; Buffer old Input Read

            ORG     2200H               ; Start at Debugger 8031
            ;
MAIN:       MOV     A,#0FDH             ; Set baud rate 9600
            MOV     TH1,A
            MOV     TL1,A
            MOV     TMOD,#00100000B     ; Timer1 Mode 1
            CLR     ES                  ; Disable Serial Interupt
            CLR     ET1                 ; Disable Timer1 Interupt
            SETB    TR1                 ; Set Timer1 Control
            MOV     SCON,#01010000B     ; Serial Mode 1
            ;
            LCALL   PRN_DATA
            DB      0DH,0AH,0DH,0AH
            DB      '**Input-7**'       ; Message on Header
            DB      0DH,0AH,00H
            ;
READ_INP:   MOV     DPTR,#READ_IN7      ; Read Input-7
            MOVX    A,@DPTR
            CJNE    A,INPUT_BUF,UPDATE_INP
            SJMP    READ_INP            ; Not Change Loop
            ;
UPDATE_INP: MOV     INPUT_BUF,A         ; Update Buffer
            MOV     A,INPUT_BUF
            CPL     A                   ; Invert Logic
            CJNE    A,#00H,SHOW_INP
            SJMP    READ_INP            ; Not Display 00H
            ;
SHOW_INP:   RLC     A                   ; Shift Bit-7 to Carry
            PUSH    ACC
            MOV     A,#'X'              ; Display Bit-7
            LCALL   TX_BYTE
            POP     ACC
            RLC     A                   ; Shift Bit-6 to Carry
            PUSH    ACC
            CLR     A
            ADDC    A,#30H              ; Convert to ASCII
            LCALL   TX_BYTE
            POP     ACC
            RLC     A                   ; Shift Bit-5 to Carry
            PUSH    ACC
            CLR     A
            ADDC    A,#30H              ; Convert to ASCII
            LCALL   TX_BYTE
            POP     ACC
            RLC     A                   ; Shift Bit-4 to Carry
            PUSH    ACC
            CLR     A
            ADDC    A,#30H              ; Convert to ASCII
            LCALL   TX_BYTE
            POP     ACC
            RLC     A                   ; Shift Bit-3 to Carry
            PUSH    ACC
            CLR     A
            ADDC    A,#30H              ; Convert to ASCII
            LCALL   TX_BYTE
            POP     ACC
            RLC     A                   ; Shift Bit-2 to Carry
            PUSH    ACC
            CLR     A
            ADDC    A,#30H              ; Convert to ASCII
            LCALL   TX_BYTE
            POP     ACC
            RLC     A                   ; Shift Bit-1 to Carry
            PUSH    ACC
            CLR     A
            ADDC    A,#30H              ; Convert to ASCII
            LCALL   TX_BYTE
            POP     ACC
            RLC     A                   ; Shift Bit-0 to Carry
            CLR     A
            ADDC    A,#30H              ; Convert to ASCII
            LCALL   TX_BYTE
            MOV     A,#0DH
            LCALL   TX_BYTE
            SJMP    READ_INP
            
;/********************************/;
;/* Print Out Data to MCS51 Port */;
;/* Usage     : LCALL PRN_DATA   */;
;/*           : DB    'xxxxxx'   */;
;/*           : DB    $00        */;
;/* Register  : ACC              */;
;/* Call Sub  : TX_BYTE          */;
;/* Note      : Last byte = 00   */;
;/*           : For EXT. Memory  */;
;/********************************/;
;
PRN_DATA:   POP     DPH                 ; Pop Stack
            POP     DPL
PRN_DATA1:  CLR     A
            MOVC    A,@A+DPTR
            CJNE    A,#00H,PRN_DATA2
            SJMP    PRN_DATA3
PRN_DATA2:  PUSH    DPH
            PUSH    DPL
            LCALL   TX_BYTE
            POP     DPL
            POP     DPH
            INC     DPTR
            SJMP    PRN_DATA1
PRN_DATA3:  PUSH    DPL                 ; Push PC
            PUSH    DPH
            RET

;/*************************/;
;/* Send 1-Byte to RS-232 */;
;/* Input   : ACC         */;
;/* Output  : Serial port */;
;/*************************/;
;
TX_BYTE:    MOV    SBUF,A
            JNB    TI,$
            CLR    TI
            RET

            END





