;/***********************************/;
;/* Demo Program For ET-CPSB31 V2.0 */;
;/* File Name : CTS-RTS.ASM         */;
;/* Hardware  : ET-RS232 V2.0(2681) */;
;/* Assembler : SXA51.EXE           */;
;/* Execute   : Run on Debug 8031   */;
;/* Function  : RXD,TXD Async.      */;
;/* (Used CTS&RTS Hardware Control) */;
;/***********************************/;
;
;/* Aysnchronous Format Data = 9600,N,8,1,P
;/* Receive & Transmitt in Polling Mode
;/* Receive Data & Echo Receive to Terminal
;/* Address Port of IORQ Decode For CP-SB31 V2.0
;/* Set Jumper JP1 Decode on ET-RS232 V2.0 = 00H
;/* Set Jumper JP2 Reset = High
;/* Address For Write/Read Register SCN2681
;/* R   = Port For Read
;/* W   = Port For Write
;/* R/W = Port For Read & Write
PORT_IORQ   EQU     0E000H              ; IORQ of CP-SB31 V2.0
MR1A        EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (1st = MR1A)
MR2A        EQU     PORT_IORQ+00H       ; R/W = Mode Register-A (2nd = MR2A)
CSRA        EQU     PORT_IORQ+01H       ; W = Clock Select Register-A
SRA         EQU     PORT_IORQ+01H       ; R = Status Register-A
CRA         EQU     PORT_IORQ+02H       ; W = Command Register-A
THRA        EQU     PORT_IORQ+03H       ; W = TX Holding Register-A
RHRA        EQU     PORT_IORQ+03H       ; R = RX Holding Register-A
ACR         EQU     PORT_IORQ+04H       ; W = Aux Control Register
IPCR        EQU     PORT_IORQ+04H       ; R = Input Port Change Register
IMR         EQU     PORT_IORQ+05H       ; W = Interupt Mask Register
ISR         EQU     PORT_IORQ+05H       ; R = Interupt Status Register
CRUR        EQU     PORT_IORQ+06H       ; W/R = Timer Upper
CTLR        EQU     PORT_IORQ+07H       ; W/R = Timer Lower
;
MR1B        EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (1st = MR1B)
MR2B        EQU     PORT_IORQ+08H       ; R/W = Mode Register-B (2nd = MR2B)
CSRB        EQU     PORT_IORQ+09H       ; W = Clock Select Register-B
SRB         EQU     PORT_IORQ+09H       ; R = Status Register-B
CRB         EQU     PORT_IORQ+0AH       ; W = Clock Select Register-B
THRB        EQU     PORT_IORQ+0BH       ; W = TX Holding Register-B
RHRB        EQU     PORT_IORQ+0BH       ; R = RX Holding Register-B
OPCR        EQU     PORT_IORQ+0DH       ; W = Output Port Config Register
INPUT7      EQU     PORT_IORQ+0DH       ; R = Input Port
SET_OUT8    EQU     PORT_IORQ+0EH       ; W = Set Output Port Bit
STRT_CNT    EQU     PORT_IORQ+0EH       ; R = Strat Counter
CLR_OUT8    EQU     PORT_IORQ+0FH       ; W = Clear Output Port Bit
STOP_CNT    EQU     PORT_IORQ+0FH       ; R = Stop Counter

            ORG     2200H               ; Start at Debugger 8031
            ;
MAIN:       LCALL   INIT_2681           ; Initial SCN2681 9600,N,8,1
            ;
WAIT_DAT1:  LCALL   RXA_2681            ; Wait Receive Channel-A
            CJNE    A,#00H,CHK_DAT1
            SJMP    WAIT_DAT2
CHK_DAT1:   CJNE    A,#0DH,ECHO_DAT1
            LCALL   PRN_DAT_A
            DB      0DH,0AH
            DB      'This is Channel-A of SCN2681'
            DB      0DH,0AH,00H
            SJMP    WAIT_DAT1
            ;
ECHO_DAT1:  LCALL   TXA_2681            ; Echo Receive-A
            SJMP    WAIT_DAT1
            ;
WAIT_DAT2:  LCALL   RXB_2681            ; Wait Receive Channel-B
            CJNE    A,#00H,CHK_DAT2
            SJMP    WAIT_DAT1
CHK_DAT2:   CJNE    A,#0DH,ECHO_DAT2
            LCALL   PRN_DAT_B
            DB      0DH,0AH
            DB      'This is Channel-B of SCN2681'
            DB      0DH,0AH,00H
            SJMP    WAIT_DAT1
            ;
ECHO_DAT2:  LCALL   TXB_2681            ; Echo Receive-B
            SJMP    WAIT_DAT1

;/*************************/;
;/* Initial SCN2681 DUART */;
;/*      9600,N,8,1,P     */;
;/*  Async. Channel-A,B   */;
;/*************************/;
;
INIT_2681:  MOV     A,#01000101B        ; Reset Error Status & Enable TX,RX
            MOV     DPTR,#CRA
            MOVX    @DPTR,A
            MOV     DPTR,#CRB
            MOVX    @DPTR,A
            MOV     A,#00010101B        ; MR Pointer = MR1 & Enable TX,RX
            MOV     DPTR,#CRA
            MOVX    @DPTR,A
            MOV     DPTR,#CRB
            MOVX    @DPTR,A
            MOV     A,#10010011B        ; Active RTS,Non Parity,8 Bit Data
            MOV     DPTR,#MR1A
            MOVX    @DPTR,A
            MOV     DPTR,#MR1B
            MOVX    @DPTR,A
            MOV     A,#00010111B        ; Normal Mode,Active CTS,1-Stop
            MOV     DPTR,#MR2A
            MOVX    @DPTR,A
            MOV     DPTR,#MR2B
            MOVX    @DPTR,A
            MOV     A,#00000011B        ; Enable RTSAN,RTSBN
            MOV     DPTR,#SET_OUT8      ; After This OP0,OP1 Control By RTS
            MOVX    @DPTR,A
            ;
            MOV     A,#10111011B        ; RX,TX Baud = 9600 (X-TAL 3.6864MHz)
            MOV     DPTR,#CSRA
            MOVX    @DPTR,A
            MOV     DPTR,#CSRB
            MOVX    @DPTR,A
            MOV     A,#11110000B        ; Timer=X=TAL/16 & Disable IP Interupt
            MOV     DPTR,#ACR           ; Baudrate Set2(75-19.2Bps)
            MOVX    @DPTR,A
            MOV     A,#00000000B        ; Disable All Interupt
            MOV     DPTR,#IMR           ; Interupt Mask Register
            MOVX    @DPTR,A
            RET

;/********************************/;
;/* Transmit ASCII 1Byte to 2681 */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : Async. Ch-A       */;
;/********************************/;
;
TXA_2681:   PUSH    ACC
            MOV     DPTR,#SRA           ; Read Status
TXA_EMTY:   MOVX    A,@DPTR
            JNB     ACC.3,TXA_EMTY      ; Wait TxEMT
            POP     ACC
            MOV     DPTR,#THRA          ; Send Character
            MOVX    @DPTR,A
            RET

;/********************************/;
;/* Transmit ASCII 1Byte to 2681 */;
;/* Input    : ACCA (ASCII Code) */;
;/* Output   : Async. Ch-B       */;
;/********************************/;
;
TXB_2681:   PUSH    ACC
            MOV     DPTR,#SRB           ; Read Status
TXB_EMTY:   MOVX    A,@DPTR
            JNB     ACC.3,TXB_EMTY      ; Wait TxEMT
            POP     ACC
            MOV     DPTR,#THRB          ; Send Character
            MOVX    @DPTR,A
            RET

;/*************************/;
;/* Receive Data From SCI */;
;/* INPUT  : Async. Ch-A  */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RXA_2681:   MOV     DPTR,#SRA           ; Read status reg
            MOVX    A,@DPTR
            JB      ACC.0,READ_RXA      ; if RxRDY = "1" Jump
            CLR     A
            SJMP    EXIT_RXA
READ_RXA:   MOV     DPTR,#RHRA          ; Read Data
            MOVX    A,@DPTR
EXIT_RXA:   RET

;/*************************/;
;/* Receive Data From SCI */;
;/* INPUT  : Async. Ch-B  */;
;/* OUTPUT : ACCA         */;
;/*************************/;
;
RXB_2681:   MOV     DPTR,#SRB           ; Read status reg
            MOVX    A,@DPTR
            JB      ACC.0,READ_RXB      ; if RxRDY = "1" Jump
            CLR     A
            SJMP    EXIT_RXB
READ_RXB:   MOV     DPTR,#RHRB          ; Read Data
            MOVX    A,@DPTR
EXIT_RXB:   RET

;/*******************************/;
;/* Print Out Data to 2681 Port */;
;/* Usage     : LCALL PRN_DAT_A */;
;/*           : DB    'xxxxxx'  */;
;/*           : DB    $00       */;
;/* Register  : ACC             */;
;/* Call Sub  : TXA_2681        */;
;/* Note      : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRN_DAT_A:  POP     DPH                 ; Pop Stack
            POP     DPL
PRN_DAT1A:  CLR     A
            MOVC    A,@A+DPTR
            CJNE    A,#00H,PRN_DAT2A
            SJMP    PRN_DAT3A
PRN_DAT2A:  PUSH    DPH
            PUSH    DPL
            LCALL   TXA_2681
            POP     DPL
            POP     DPH
            INC     DPTR
            SJMP    PRN_DAT1A
PRN_DAT3A:  PUSH    DPL                 ; Push PC
            PUSH    DPH
            RET

;/*******************************/;
;/* Print Out Data to 2681 Port */;
;/* Usage     : LCALL PRN_DAT_B */;
;/*           : DB    'xxxxxx'  */;
;/*           : DB    $00       */;
;/* Register  : ACC             */;
;/* Call Sub  : TXB_2681        */;
;/* Note      : Last byte = 00  */;
;/*           : For EXT. Memory */;
;/*******************************/;
;
PRN_DAT_B:  POP     DPH                 ; Pop Stack
            POP     DPL
PRN_DAT1B:  CLR     A
            MOVC    A,@A+DPTR
            CJNE    A,#00H,PRN_DAT2B
            SJMP    PRN_DAT3B
PRN_DAT2B:  PUSH    DPH
            PUSH    DPL
            LCALL   TXB_2681
            POP     DPL
            POP     DPH
            INC     DPTR
            SJMP    PRN_DAT1B
PRN_DAT3B:  PUSH    DPL                 ; Push PC
            PUSH    DPH
            RET

            END




