;/***********************************/;
;/* Demo Software For Mini ET-REM8  */;
;/* Files Name  : DSP8EX5.ASM       */;
;/* Board & CPU : AT89C2051         */;
;/*  (Mini Remote Display 8-Digit)  */;
;/* Assembler   : SXA51             */;
;/* Function    : Read/Write EEPROM */;
;/*             : Display to RS232  */;
;/***********************************/;
;
;/* Port For Control 93X46 */;
EEP_DIN     EQU     P1.1                    ; Data Input of EEPROM
EEP_DOUT    EQU     ACC.1                   ; Data Output of EEPROM
EEP_CLOCK   EQU     P1.2                    ; Serial clock
EEP_CS      EQU     P1.3                    ; Chip select of EEPROM
RTC_RESET   EQU     P1.0                    ; RTC Reset Pin
PORT_EEP    EQU     P1                      ; Port Data I/O EEPROM
;
ADDRESS     EQU     20H
DATA        EQU     21H
COUNT       EQU     22H
LINE        EQU     23H

            ORG     0000H
MAIN:       MOV     SP,#128-32              ; Initial Stack 32 Byte
            MOV     P1,#0FFH
            CLR     RTC_RESET
            CLR     EEP_CS                  ; CS Active = "1"
            CLR     EEP_CLOCK               ; 1st Clock = Rising Edge
            LCALL   READ_WORD
INIT_SER:   MOV     A,#0FDH                 ; Set baud rate 9600
            MOV     TH1,A
            MOV     TL1,A
            MOV     TMOD,#00100000B         ; Timer1 Mode 1
            CLR     ES                      ; Disable serial interupt
            CLR     ET1                     ; Disable timer1 interupt
            SETB    TR1                     ; Set timer1 control
            MOV     SCON,#01010000B         ; Serial mode 1
            ;
            LCALL   PRINT_SER
            DB      0CH,0DH,0AH
            DB      'Hardware  ET-REM8',0DH,0AH
            DB      'ETT CO.,LTD',0DH,0AH
            DB      'Test Serial eeprom 93xx46 (128x8)'
            DB      0DH,0AH,0DH,0AH,00H
            ;
            LCALL   PRINT_SER
            DB      'Write 01H to Address 00H',00H
            MOV     B,#01H                  ; Data To Write eeprom
            MOV     A,#00H                  ; Address EEprom
            LCALL   WRITE_WORD              ; Write Data to eeprom
            LCALL   PRINT_SER
            DB      0DH,0AH
            DB      'Read eeprom Address 00H = ',00H
            MOV     A,#00H                  ; Address to Read eeprom
            LCALL   READ_WORD               ; Read Data From eeprom
            MOV     A,B                     ; Data 1-Byte
            LCALL   TX_2ASC
            ;
            LCALL   PRINT_SER
            DB      0DH,0AH,0DH,0AH
            DB      'Write 23H to Address 7FH',00H
            MOV     B,#23H                  ; Data To Write eeprom
            MOV     A,#7FH                  ; Address EEprom
            LCALL   WRITE_WORD              ; Write Data to eeprom
            LCALL   PRINT_SER
            DB      0DH,0AH
            DB      'Read eeprom Address 7FH = ',00H
            MOV     A,#7FH                  ; Address to Read eeprom
            LCALL   READ_WORD               ; Read Data From eeprom
            MOV     A,B                     ; Data 1-Byte
            LCALL   TX_2ASC
            ;
            SJMP    $

;/***********************************/;
;/* Subroutine for EEPROM 93AA46    */;
;/* 8-Bits Organization (128x8)     */;
;/* Reference to Microchips Data Ic */;
;/* EWEN  : Erase/Write Enable      */;
;/* EWDS  : Erase/Write Disable     */;
;/* WRITE : Write Data 8-Bit 1-Byte */;
;/* ERASE : Erase Data 8-Bit 1-Byte */;
;/* READ_WORD  : Read 8-Bit 1-Byte  */;
;/* WRITE_WORD : Write 8-Bit 1-Byte */;
;/***********************************/;
;
;/**********************/;
;/*    EWEN Command    */;
;/* Erase/Write Enable */;
;/**********************/;
;
EWEN:       CLR     EEP_DIN
            SETB    EEP_CS                  ; Erase/Write Enable command
            SETB    EEP_DIN
            LCALL   CLOCK                   ; 1
            CLR     EEP_DIN
            LCALL   CLOCK                   ; 0
            LCALL   CLOCK                   ; 0
            SETB    EEP_DIN
            LCALL   CLOCK                   ; 1
            LCALL   CLOCK                   ; 1
            CLR     EEP_DIN
            LCALL   CLOCK                   ; X(0)
            LCALL   CLOCK                   ; X(0)
            LCALL   CLOCK                   ; X(0)
            LCALL   CLOCK                   ; X(0)
            LCALL   CLOCK                   ; X(0)
            CLR     EEP_CS                  ; Standby
            RET

;/***********************/;
;/*     EWDS Command    */;
;/* Erase/Write Disable */;
;/***********************/;
;
EWDS:       CLR     EEP_DIN
            SETB    EEP_CS                  ; Erase/Write Disable command
            SETB    EEP_DIN
            LCALL   CLOCK                   ; 1
            CLR     EEP_DIN
            LCALL   CLOCK                   ; 0
            LCALL   CLOCK                   ; 0
            LCALL   CLOCK                   ; 0
            LCALL   CLOCK                   ; 0
            LCALL   CLOCK                   ; X(0)
            LCALL   CLOCK                   ; X(0)
            LCALL   CLOCK                   ; X(0)
            LCALL   CLOCK                   ; X(0)
            LCALL   CLOCK                   ; X(0)
            CLR     EEP_CS
            RET

;/*********************************/;
;/* WRITE DATA TO EEPROM (93AA46) */;
;/* Input    : ACC  = Address     */;
;/*          : B    = Data(8-Bit) */;
;/* Reg.     : ACC,B,R2           */;
;/*********************************/;
;
WRITE:      CLR     EEP_DIN
            SETB    EEP_CS                  ; Write command
            SETB    EEP_DIN
            LCALL   CLOCK                   ; 1
            CLR     EEP_DIN
            LCALL   CLOCK                   ; 0
            SETB    EEP_DIN
            LCALL   CLOCK                   ; 1
            RL      A                       ; Shift A6 to A7
            MOV     R2,#7
            CLR     CY
WREEP1:     RLC     A                       ; Write  address 7 bit
            MOV     EEP_DIN,C
            LCALL   CLOCK
            DJNZ    R2,WREEP1               ; Repeat write address
            ;
            MOV     R2,#8                   ; Write data 8 bit in B
            MOV     A,B
WREEP2:     RLC     A                       ; Write data D7..D0
            MOV     EEP_DIN,C
            LCALL   CLOCK
            DJNZ    R2,WREEP2
            ;
            CLR     EEP_DIN
            CLR     EEP_CS
            LCALL   CLOCK                   ; TCSL
            SETB    EEP_CS
WR_STAT:    LCALL   CLOCK                   ; wait ready state
            SETB    EEP_DIN
            MOV     A,PORT_EEP
            MOV     C,EEP_DOUT
            JNC     WR_STAT                 ; Repeat if Busy
            CLR     EEP_CS                  ; OK ready So Standby
            RET

;/**************************/;
;/*        Erase byte      */;
;/* Input : ACC = Address  */;
;/* Reg.  : ACC,R2         */;
;/**************************/;
;
ERASE:      CLR     EEP_DIN
            SETB    EEP_CS                  ; Erase command
            SETB    EEP_DIN
            LCALL   CLOCK                   ; 1
            LCALL   CLOCK                   ; 1
            LCALL   CLOCK                   ; 1
            RL      A                       ; Shift A6 to A7
            MOV     R2,#7
            CLR     CY
RAS1:       RLC     A                       ; Write Address 7 bit
            MOV     EEP_DIN,C
            LCALL   CLOCK
            DJNZ    R2,RAS1
            CLR     EEP_DIN
            CLR     EEP_CS
            LCALL   CLOCK                   ; TCLS
            SETB    EEP_CS
BUSY:       LCALL   CLOCK
            SETB    EEP_DIN
            MOV     A,PORT_EEP
            MOV     C,EEP_DOUT
            JNC     BUSY                    ; Loop if Busy
            CLR     EEP_CS                  ; OK Ready So Standby
            RET

;/*********************************/;
;/* READ DATA FROM EEPROM(93AA46) */;
;/* Input    : ACC = Address      */;
;/* Output   : B   = Data (8-Bit) */;
;/* Reg.     : ACC,B,R2           */;
;/*********************************/;
;
READ_WORD:  CLR     EEP_DIN
            SETB    EEP_CS                  ; Read Command
            SETB    EEP_DIN
            LCALL   CLOCK                   ; 1
            LCALL   CLOCK                   ; 1
            CLR     EEP_DIN
            LCALL   CLOCK                   ; 0
            RL      A                       ; Shift A6 to A7
            MOV     R2,#7
            CLR     CY
RDEEP1:     RLC     A                       ; Write address 7 bit
            MOV     EEP_DIN,C
            LCALL   CLOCK
            DJNZ    R2,RDEEP1               ; Repeat write address
            CLR     EEP_DIN
            MOV     R1,#0
            MOV     R2,#8
RDEEP2:     LCALL   CLOCK                   ; Read data D0..D7
            SETB    EEP_DIN
            MOV     A,PORT_EEP
            MOV     C,EEP_DOUT              ; Read data out bit
            MOV     A,R1
            RLC     A
            MOV     R1,A
            DJNZ    R2,RDEEP2
            MOV     B,R1                    ; 1st Byte
            MOV     DPH,#0                  ; Dont Care 2nd Byte
            CLR     EEP_CS
            RET

;/***************************/;
;/* Write 'WORD' To EEPROM  */;
;/* Input : B    = Data     */;
;/*       : ACC  = Address  */;
;/* Reg.  : ACC,B,R2        */;
;/***************************/;
;
WRITE_WORD: PUSH    ACC
            LCALL   EWEN                    ; Erase/Write Enable
            POP     ACC                     ; Get address
            PUSH    ACC                     ; Save address
            LCALL   ERASE                   ; Erase before write
            POP     ACC                     ; Get address
            LCALL   WRITE                   ; Write
            LCALL   EWDS                    ; Erase/Write Disable
            RET

;/******************/;
;/*  Serial clock  */;
;/******************/;
;
CLOCK:      SETB    EEP_CLOCK               ; SK = hi
            NOP
            NOP
            NOP
            NOP
            CLR     EEP_CLOCK               ; SK = low
            NOP
            NOP
            NOP
            NOP
            RET


;************************************
;*  Print Data data to Serial Port  *
;*  to display buffer.              *
;*  Usage    : LCALL PRINT_SER      *
;*           : DB   'xxxx',00       *
;*  Register : ACC                  *
;*  Note     : last byte must be 00 *
;************************************
;
PRINT_SER:  POP     DPH
            POP     DPL
PRINT1:     CLR     A
            MOVC    A,@A+DPTR
            CJNE    A,#00H,PRINT2
            SJMP    PRINT3
PRINT2:     LCALL   TX_BYTE
            INC     DPTR
            SJMP    PRINT1
PRINT3:     PUSH    DPL
            PUSH    DPH
            RET

;****************************
;* Receive Data From RS-232 *
;* Input   :  Serial Port   *
;* Output  :  ACC           *
;****************************
;
RX_BYTE:    PUSH   IE
            JNB    RI,$             ; Wait data
            CLR    RI
            MOV    A,SBUF
            POP    IE
            RET

;*************************
;* Send 1-Byte to RS-232 *
;* Input   : ACC         *
;* Output  : Serial port *
;*************************
;
TX_BYTE:    PUSH   IE
            CLR    TI
            MOV    SBUF,A
            JNB    TI,$
            CLR    TI
            POP    IE
            RET

;******************************
;*    Send 2 byte of ASCII    *
;*  Input : ACC (HEX)         *
;*  Example : A = A3H         *
;*          : send 41H,33H    *
;******************************
;
TX_2ASC:    LCALL   HEX_2ASC
            LCALL   TX_BYTE
            MOV     A,B
            LCALL   TX_BYTE
            RET

;******************************
;*   Convert HEX to ASCII     *
;* Input    :  A              *
;* Output   :  A (high-byte)  *
;*          :  B (low-byte)   *
;******************************
;
HEX_2ASC:   PUSH    ACC
            LCALL   HEX_TO_ASC
            MOV     B,A              ; B = Lo byte
            POP     ACC
            SWAP    A
            LCALL   HEX_TO_ASC
            RET

;********************************
;*  Convert hex (0-F) to ASCII  *
;*  Input   : ACC (HEX code)    *
;*  Output  : ACC (ASCII code)  *
;********************************
;
HEX_TO_ASC: PUSH    PSW
            CLR     CY
            ANL     A,#00001111B
            CJNE    A,#09H,HTOA1
            SETB    CY
HTOA1:      JNB     CY,HTOA2       ;> 0AH
            ORL     A,#30H         ;< 0AH
            SJMP    END_HTOA
HTOA2:      SUBB    A,#09H         ;> 0AH
            ORL     A,#40H
END_HTOA:   POP     PSW
            RET

            END




            

