;/***********************************/;
;/* Demo Software For Mini ET-REM8  */;
;/* Files Name  : DSP8EX4.ASM       */;
;/* Board & CPU : AT89C2051         */;
;/*  (Mini Remote Display 8-Digit)  */;
;/* Assembler   : SXA51             */;
;/* Function    : Digital Clock     */;
;/***********************************/;
;
;/* Port For Control MAX7219 */;
MAX_DATA    EQU     P1.4                    ; Data Input
MAX_CLOCK   EQU     P1.5                    ; Clock Input
MAX_LOAD    EQU     P1.6                    ; Load Input
;
;/* Port For Control DS1202 */;
RTC_RESET   EQU     P1.0                    ; RTC Reset/CS
RTC_DATA    EQU     P1.1                    ; RTC Data I/O
RTC_CLOCK   EQU     P1.2                    ; RTC Clock
EEP_CS      EQU     P1.3                    ; Chip Select 93XX
RST_WATCH   EQU     P1.7                    ; Watchdog Reset
;
SECOND      EQU     00H                     ; Second 00-59
MINUTE      EQU     01H                     ; Minute 00-59
HOUR        EQU     02H                     ; Hour 01-12 or 00-23
DATE        EQU     03H                     ; Data 01-28/29 or 01-30 or 01-31
MONTH       EQU     04H                     ; Month 01-12
DAY         EQU     05H                     ; Day 01-07
YEAR        EQU     06H                     ; Year 00-99
CTRL_RTC    EQU     07H                     ; Write Protect Enable/Disable

            ORG     20H                     ; Internal RAM of CPU
FLAG_BUF:   DS      1                       ; Flag Status
DSP_BUFF:   DS      8
SEC_CNT:    DS      1                       ; Time (1-Second) Buffer Count
STACK:      DS      32                      ; Stack Area
;
STAS_DSP    EQU     FLAG_BUF.0              ; Status Display
UPDATE      EQU     FLAG_BUF.1
            
            ORG     0000H                   ; Reset Vector of CPU
            LJMP    MAIN
            ;
            ORG     000BH                   ; Timer0 Vector Interupt
            LJMP    TIMER_INT
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     FLAG_BUF,#0
            MOV     P1,#0FFH
            SETB    RTC_CLOCK               ; Initial Port RTC-DS1202
            SETB    RTC_DATA
            CLR     RTC_RESET
            CLR     EEP_CS                  ; Disable EEPROM CS
            LCALL   INIT_MAX                ; Initial MAX7219
            ;
            LCALL   DISABLE                 ; Write Protect OFF
            MOV     A,#SECOND
            LCALL   READ_RTC
            CLR     ACC.7                   ; Disable Clock Halt Flag
            MOV     B,A
            MOV     A,#SECOND
            LCALL   WRITE_RTC
            LCALL   ENABLE                  ; Write Protect ON
            ;
            MOV     TMOD,#00000001B         ; Timer0 Mode1 (16Bit)
            MOV     SEC_CNT,#50             ; 0.5-Second Counter (10mS x 50)
            MOV     TH0,#0DBH               ; 10 mSec Period
            MOV     TL0,#0FFH
            SETB    ET0                     ; Enable Timer0 Interupt
            SETB    TR0                     ; Start Timer Count
            SETB    EA                      ; Enable Global Interupt
            ;
LOOP:       JB      UPDATE,DSP_TIME
            SJMP    LOOP
            ;
DSP_TIME:   MOV     A,#HOUR                 ; Get Hour Time
            LCALL   READ_RTC
            PUSH    ACC
            SWAP    A
            ANL     A,#0FH
            MOV     DSP_BUFF+0,A
            POP     ACC
            ANL     A,#0FH
            MOV     DSP_BUFF+1,A
            ;
            JNB     STAS_DSP,DSP_TIM1
            MOV     DSP_BUFF+2,#0AH         ; "-"
            SJMP    DSP_TIM2
DSP_TIM1:   MOV     DSP_BUFF+2,#0BH         ; Blank
            ;
DSP_TIM2:   MOV     A,#MINUTE               ; Get Minute Time
            LCALL   READ_RTC
            PUSH    ACC
            SWAP    A
            ANL     A,#0FH
            MOV     DSP_BUFF+3,A
            POP     ACC
            ANL     A,#0FH
            MOV     DSP_BUFF+4,A
            ;
            JNB     STAS_DSP,DSP_TIM3
            MOV     DSP_BUFF+5,#0AH         ; "-"
            SJMP    DSP_TIM4
DSP_TIM3:   MOV     DSP_BUFF+5,#0BH         ; Blank
            ;
DSP_TIM4:   MOV     A,#SECOND               ; Get Second Time
            LCALL   READ_RTC
            PUSH    ACC
            SWAP    A
            ANL     A,#0FH
            MOV     DSP_BUFF+6,A
            POP     ACC
            ANL     A,#0FH
            MOV     DSP_BUFF+7,A
            LCALL   DISPLAY
            CLR     UPDATE
            SJMP    LOOP


;/********************/;
;/* Initial MAX7219  */;
;/********************/;
;
INIT_MAX:   MOV     DPTR,#0A0FH             ; Intensity (Max)
            LCALL   SHF_MAX
            MOV     DPTR,#0B07H             ; Scan Limit (8digit)
            LCALL   SHF_MAX
            MOV     DPTR,#0900H             ; Set Mode (No Decode BCD)
            LCALL   SHF_MAX
            MOV     DPTR,#0C01H             ; Not Shutdown (Normal Opr.)
            LCALL   SHF_MAX
            MOV     DPTR,#0F00H             ; Not Display test (Normal Opr.)
            LCALL   SHF_MAX
            RET

;/*************************/;
;/* Shift Data to MAX7219 */;
;/* Input : DPH = Address */;
;/*       : DPL = Data    */;
;/* Reg.  : DPTR,R2,ACC   */;
;/*************************/;
;
SHF_MAX:    MOV     R2,#8                   ; Counter Address out
            MOV     A,DPH
            CLR     CY
            CLR     MAX_CLOCK
            CLR     MAX_LOAD
SHF_MAX1:   RLC     A                       ; Shift Out D15..D8
            MOV     MAX_DATA,C
            SETB    MAX_CLOCK               ; Shift clock
            CLR     MAX_CLOCK
            DJNZ    R2,SHF_MAX1
            MOV     R2,#8                   ; Counter data out
            MOV     A,DPL
            CLR     CY
SHF_MAX2:   RLC     A                       ; Shift Out D7..D0
            MOV     MAX_DATA,C
            SETB    MAX_CLOCK               ; Shift Clock
            CLR     MAX_CLOCK
            DJNZ    R2,SHF_MAX2
            SETB    MAX_LOAD                ; Latch Data
            CLR     MAX_LOAD
            RET

;/*************************/;
;/* Table of Display Code */;
;/*    Dp A B C D E F G   */;
;/*    D7 ...........D0   */;
;/*************************/;
;
TAB_SEG:    DB      7EH,30H,6DH,79H         ; 0 1 2 3
            DB      33H,5BH,5FH,70H         ; 4 5 6 7
            DB      7FH,7BH,01H,00H         ; 8 9 -

;/*****************************/;
;/* Display 7-Segment 8-Digit */;
;/* Input : DSP_BUFF (8-Byte) */;
;/*****************************/;
;
DISPLAY:    MOV     R7,#8
            MOV     R1,#08H                 ; Digit 1
            MOV     R0,#DSP_BUFF            ; Buffer digit1
DSP1:       MOV     A,@R0
            ANL     A,#01111111B            ; Ignore Dp
            MOV     DPTR,#TAB_SEG
            MOVC    A,@A+DPTR
            MOV     DPH,R1                  ; Address
            MOV     DPL,A                   ; Data
            MOV     A,@R0
            ANL     A,#10000000B            ; Check Dp
            ORL     A,DPL
            MOV     DPL,A
            LCALL   SHF_MAX
            INC     R0                      ; Next Buffer
            DEC     R1                      ; Next Digit
            DJNZ    R7,DSP1
            RET

;/****************************/;
;/* Read Ram From RTC-DS1202 */;
;/* Input    : ACC = Address */;
;/* Output   : ACC = Data    */;
;/* Reg.     : ACC,B,R2      */;
;/****************************/;
;
READ_RAM:   LCALL   START_RST           ; Start Communication
            MOV     R2,#8
            RL      A                   ; Shift A0 to A1
            SETB    ACC.7               ; Command Status
            SETB    ACC.6               ; Ram Accress
            SETB    ACC.0               ; Read Command
            CLR     CY
READ_RAM1:  LCALL   CLOCK_LO            ; Falling Clock
            RRC     A                   ; Send D0..D7 (Read-Command)
            MOV     RTC_DATA,C          ; Prepare Port
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,READ_RAM1        ; Repeat Send Read-Command
            ;
            MOV     B,#0
            MOV     R2,#8
READ_RAM2:  SETB    RTC_DATA            ; Initial for Input
            NOP
            NOP
            LCALL   CLOCK_LO            ; Read data D0..D7 (Data)
            NOP                         ; Wait Data From RTC
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            MOV     C,RTC_DATA          ; Read data out bit
            MOV     A,B
            RRC     A                   ; Read D0..D7
            MOV     B,A                 ; Backup Data
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,READ_RAM2
            MOV     A,B                 ; Data Output 1-Byte
            LCALL   STOP_RST            ; Disable Communication
            RET

;/***************************/;
;/* Write Ram to RTC-DS1202 */;
;/* Input   : ACC = Address */;
;/*         : B = Data      */;
;/* Reg.    : ACC,B,R2      */;
;/***************************/;
;
WRITE_RAM:  LCALL   START_RST           ; Enable Communication
            MOV     R2,#8
            RL      A                   ; Shift A0 to A1
            SETB    ACC.7               ; Command Status
            SETB    ACC.6               ; Ram Accress
            CLR     ACC.0               ; Write Command
            CLR     CY
WRITE_RAM1: LCALL   CLOCK_LO            ; Falling Clock
            RRC     A                   ; Send D0..D7 (Write-Command)
            MOV     RTC_DATA,C
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,WRITE_RAM1       ; Repeat write Command
            ;
            MOV     A,B                 ; Get Data For Send
            MOV     R2,#8
            CLR     CY
WRITE_RAM2: LCALL   CLOCK_LO            ; Falling Clock
            RRC     A                   ; Write D0..D7
            MOV     RTC_DATA,C
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI
            DJNZ    R2,WRITE_RAM2       ; Repeat write Data
            LCALL   STOP_RST            ; Disable Communication
            RET

;/****************************/;
;/* Read RTC From RTC-DS1202 */;
;/* Input    : ACC = Address */;
;/* Output   : ACC = Data    */;
;/* Reg.     : ACC,B,R2      */;
;/****************************/;
;
READ_RTC:   LCALL   START_RST           ; Start Communication
            MOV     R2,#8
            RL      A                   ; Shift A0 to A1
            SETB    ACC.7               ; Command Status
            CLR     ACC.6               ; Ram Accress
            SETB    ACC.0               ; Read Command
            CLR     CY
READ_RTC1:  LCALL   CLOCK_LO            ; Falling Clock
            RRC     A                   ; Send D0..D7 (Read-Command)
            MOV     RTC_DATA,C          ; Prepare Port
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI            ; Clock
            DJNZ    R2,READ_RTC1        ; Repeat write Command
            ;
            MOV     B,#0
            MOV     R2,#8
READ_RTC2:  SETB    RTC_DATA            ; Initial for Input
            NOP
            NOP
            SETB    RTC_DATA            ; Initial for Input
            LCALL   CLOCK_LO            ; Read data D0..D7 (Data)
            NOP                         ; Wait Data From RTC
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            MOV     C,RTC_DATA          ; Read data out bit
            MOV     A,B
            RRC     A                   ; Read D0..D7
            MOV     B,A                 ; Backup Data
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,READ_RTC2
            MOV     A,B                 ; Data Output 1-Byte
            LCALL   STOP_RST            ; Disable Communication
            RET

;/***************************/;
;/* Write RTC to RTC-DS1202 */;
;/* Input   : ACC = Address */;
;/*         : B = Data      */;
;/* Reg.    : ACC,B,R2      */;
;/***************************/;
;
WRITE_RTC:  LCALL   START_RST           ; Enable Communication
            MOV     R2,#8
            RL      A                   ; Shift A0 to A1
            SETB    ACC.7               ; Command Status
            CLR     ACC.6               ; Ram Accress
            CLR     ACC.0               ; Write Command
            CLR     CY
WRITE_RTC1: LCALL   CLOCK_LO            ; Falling Clock
            RRC     A                   ; Write D0..D7 (Command)
            MOV     RTC_DATA,C
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,WRITE_RTC1       ; Repeat write Command
            ;
            MOV     A,B                 ; Get Data
            MOV     R2,#8
            CLR     CY
WRITE_RTC2: LCALL   CLOCK_LO
            RRC     A                   ; Write D0..D7
            MOV     RTC_DATA,C
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,WRITE_RTC2       ; Repeat write Data
            LCALL   STOP_RST            ; Disable Communication
            RET

;/*************************/;
;/* Write Protect Disable */;
;/* Now You Can Write RTC */;
;/* Reg.    : ACC,B,R2    */;
;/*************************/;
;
DISABLE:    MOV     A,#CTRL_RTC
            MOV     B,#00H              ; Disable Write-Protect
            LCALL   WRITE_RTC
            RET

;/************************/;
;/* Write Protect Enable */;
;/* You Can't Write RTC  */;
;/* Reg.    : ACC,B,R2   */;
;/************************/;
;
ENABLE:     MOV     A,#CTRL_RTC
            MOV     B,#80H              ; Enable Write-Protect
            LCALL   WRITE_RTC
            RET

;/*****************/;
;/*  RTC Clock    */;
;/*  Falling Edge */;
;/*****************/;
;
CLOCK_LO:   CLR     RST_WATCH           ; Reset Watch-Dog
            SETB    RST_WATCH           ; Enable Watch-Dog
            CLR     RTC_CLOCK           ; Falling Clock
            NOP
            NOP
            NOP
            NOP
            RET

;/***************/;
;/* RTC Clock   */;
;/* Rising Edge */;
;/***************/;
;
CLOCK_HI:   CLR     RST_WATCH           ; Reset Watch-Dog
            SETB    RST_WATCH           ; Enable Watch-Dog
            SETB    RTC_CLOCK           ; Rising Clock
            NOP
            NOP
            NOP
            NOP
            RET

;/*************************/;
;/* Initial Reset & Clock */;
;/* For Start Communicate */;
;/*************************/;
;
START_RST:  CLR     RST_WATCH           ; Reset Watch-Dog
            SETB    RST_WATCH           ; Enable Watch-Dog
            CLR     RTC_RESET
            CLR     RTC_CLOCK
            NOP
            NOP
            NOP
            NOP
            SETB    RTC_RESET           ; Enable Communication
            NOP
            NOP
            NOP
            NOP
            RET

;/*************************/;
;/* Initial Reset & Clock */;
;/*  For Stop Communicate */;
;/*************************/;
;
STOP_RST:   CLR     RST_WATCH           ; Reset Watch-Dog
            SETB    RST_WATCH           ; Enable Watch-Dog
            SETB    RTC_CLOCK
            NOP
            NOP
            NOP
            NOP
            CLR     RTC_RESET           ; Disable Communication
            NOP
            NOP
            NOP
            NOP
            RET

;/******************************/;
;/* Timer 0 : 1 Second Service */;
;/*    Interupt Every 10 mSec  */;
;/* Auto Reload Every 1 Second */;
;/******************************/;
;
TIMER_INT:  MOV     TH0,#0DBH               ; 10 mSec Period Auto Reload
            MOV     TL0,#0FFH
            DJNZ    SEC_CNT+0,END_TIME      ; Check Time = 0.5 Second?
            MOV     SEC_CNT+0,#50           ; 10mSec x 50 = 0.5 Second
            CPL     STAS_DSP                ; Toggle Status Display
            SETB    UPDATE                  ; Update Time
END_TIME:   RETI

            END

