;/***********************************/;
;/* Demo Software For Mini ET-REM8  */;
;/* Files Name  : DSP8EX1.ASM       */;
;/* Board & CPU : AT89C2051         */;
;/*  (Mini Remote Display 8-Digit)  */;
;/* Assembler   : SXA51             */;
;/* Function    : Test Display      */;
;/***********************************/;
;
;/* Port For Control MAX7219 */;
MAX_DATA    EQU     P1.4                    ; Data Input
MAX_CLOCK   EQU     P1.5                    ; Clock Input
MAX_LOAD    EQU     P1.6                    ; Load Input

            ORG     20H                     ; Internal RAM of CPU
DSP_BUFF:   DS      8
STACK:      DS      32                      ; Stack Area
            
            ORG     0000H                   ; Reset Vector of CPU
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     P1,#0FFH
            LCALL   INIT_MAX                ; Initial MAX7219
            ;
            MOV     DSP_BUFF+0,#0           ; Display Code
            MOV     DSP_BUFF+1,#1
            MOV     DSP_BUFF+2,#2
            MOV     DSP_BUFF+3,#3
            MOV     DSP_BUFF+4,#4
            MOV     DSP_BUFF+5,#5
            MOV     DSP_BUFF+6,#6
            MOV     DSP_BUFF+7,#7
            ;
DISPLAY:    MOV     R7,#8
            MOV     R1,#08H                 ; Digit 1
            MOV     R0,#DSP_BUFF            ; Buffer digit1
DSP1:       MOV     A,@R0
            ANL     A,#01111111B            ; Ignore Dp
            MOV     DPTR,#TAB_SEG
            MOVC    A,@A+DPTR
            MOV     DPH,R1                  ; Address
            MOV     DPL,A                   ; Data
            MOV     A,@R0
            ANL     A,#10000000B            ; Check Dp
            ORL     A,DPL
            MOV     DPL,A
            LCALL   SHF_MAX
            INC     R0                      ; Next Buffer
            DEC     R1                      ; Next Digit
            DJNZ    R7,DSP1
            SJMP    $

;/********************/;
;/* Initial MAX7219  */;
;/********************/;
;
INIT_MAX:   MOV     DPTR,#0A0FH             ; Intensity (Max)
            LCALL   SHF_MAX
            MOV     DPTR,#0B07H             ; Scan Limit (8digit)
            LCALL   SHF_MAX
            MOV     DPTR,#0900H             ; Set Mode (No Decode BCD)
            LCALL   SHF_MAX
            MOV     DPTR,#0C01H             ; Not Shutdown (Normal Opr.)
            LCALL   SHF_MAX
            MOV     DPTR,#0F00H             ; Not Display test (Normal Opr.)
            LCALL   SHF_MAX
            RET

;/*************************/;
;/* Shift Data to MAX7219 */;
;/* Input : DPH = Address */;
;/*       : DPL = Data    */;
;/* Reg.  : DPTR,R2,ACC   */;
;/*************************/;
;
SHF_MAX:    MOV     R2,#8                   ; Counter Address out
            MOV     A,DPH
            CLR     CY
            CLR     MAX_CLOCK
            CLR     MAX_LOAD
SHF_MAX1:   RLC     A                       ; Shift Out D15..D8
            MOV     MAX_DATA,C
            SETB    MAX_CLOCK               ; Shift clock
            CLR     MAX_CLOCK
            DJNZ    R2,SHF_MAX1
            MOV     R2,#8                   ; Counter data out
            MOV     A,DPL
            CLR     CY
SHF_MAX2:   RLC     A                       ; Shift Out D7..D0
            MOV     MAX_DATA,C
            SETB    MAX_CLOCK               ; Shift Clock
            CLR     MAX_CLOCK
            DJNZ    R2,SHF_MAX2
            SETB    MAX_LOAD                ; Latch Data
            CLR     MAX_LOAD
            RET

;/*************************/;
;/* Table of Display Code */;
;/*    Dp A B C D E F G   */;
;/*    D7 ...........D0   */;
;/*************************/;
;
TAB_SEG:    DB      7EH,30H,6DH,79H         ; 0 1 2 3
            DB      33H,5BH,5FH,70H         ; 4 5 6 7
            DB      7FH,7BH,77H,1FH         ; 8 9 A B
            DB      4EH,3DH,4FH,47H         ; C D E F

            END
            
