;/**********************************/;
;/* Monitor For Display 14-Segment */;
;/* Files Name  : DSP14EX5.ASM     */;
;/* Board & CPU : AT89C51          */;
;/* (Display 14-Segment / 8-Digit) */;
;/* Assembler   : SXA51            */;
;/* Function    : Digital Clock    */;
;/**********************************/;
;
;/* Port For Control Display */;
RST_WATCH   EQU     P1.0                    ; Reset Watchdog
DISPLAY1    EQU     P1.1                    ; Latch Display1
DISPLAY2    EQU     P1.2                    ; Latch Display2
GATE_DSP    EQU     P1.3                    ; Enable Display
;/* Port For Control 93LC56B */;
EEP_CS      EQU     P1.4                    ; Chip select of EEPROM
EEP_CLOCK   EQU     P1.5                    ; Serial clock
EEP_DIN     EQU     P1.6                    ; Data Input of EEPROM
EEP_DOUT    EQU     ACC.6                   ; Data Output of EEPROM
PORT_EEP    EQU     P1                      ; Port Data I/O EEPROM
;/* Port For Control DS1202 */;
RTC_CLOCK   EQU     P1.5
RTC_DATA    EQU     P1.6
RTC_RESET   EQU     P1.7
;
SPEAKER     EQU     P3.6                    ; Speaker
DIR_485     EQU     P3.7

            ORG     20H                     ; Internal RAM of CPU
FLAG_BUF:   DS      1                       ; Flag Status
SEC_CNT:    DS      1                       ; Time (1-Second) Buffer Count
DSP_BUFF:   DS      8                       ; Display Buffer
SCAN_CNT:   DS      1
SCAN_BUF:   DS      1
DIG_BUFF:   DS      1
MOVE_CNT:   DS      1
MOVE_INX:   DS      1
STACK:      DS      32
;
STAS_DSP    EQU     FLAG_BUF.0              ; Status Display
UPDATE      EQU     FLAG_BUF.1
;
;/* Constant Value */;
SECOND      EQU     00H                     ; Second 00-59
MINUTE      EQU     01H                     ; Minute 00-59
HOUR        EQU     02H                     ; Hour 01-12 or 00-23
DATE        EQU     03H                     ; Data 01-28/29 or 01-30 or 01-31
MONTH       EQU     04H                     ; Month 01-12
DAY         EQU     05H                     ; Day 01-07
YEAR        EQU     06H                     ; Year 00-99
CTRL_RTC    EQU     07H                     ; Write Protect Enable/Disable
            
            ORG     0000H                   ; Reset Vector of CPU
            LJMP    MAIN
            ORG     000BH                   ; Timer0 Vector Interupt
            LJMP    SCAN_DSP
            ORG     001BH                   ; Timer1 Vector Interupt
            LJMP    TIMER_INT
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     FLAG_BUF,#0
            MOV     P0,#000H
            MOV     P1,#0FFH
            MOV     P2,#000H
            SETB    RTC_CLOCK               ; Initial Port RTC-DS1202
            SETB    RTC_DATA
            CLR     RTC_RESET
            CLR     EEP_CS                  ; Disable EEPROM CS
            ;
            MOV     TMOD,#00010001B         ; Timer0,1 Mode1 (16Bit)
            MOV     TH0,#0FCH               ; 1 milliSec Period For Timer0
            MOV     TL0,#066H
            MOV     SCAN_CNT,#08H           ; Scan Count = 8-Digit
            MOV     SCAN_BUF,#01H           ; Scan ULN2803 = Colum0
            MOV     DIG_BUFF,#DSP_BUFF      ; Display Buffer = DG-0
            SETB    ET0                     ; Enable Timer0 Interupt
            SETB    TR0                     ; Strat Timer0
            MOV     SEC_CNT,#50             ; 0.5-Second Counter (10mS x 50)
            MOV     TH1,#0DBH               ; 10 mSec Period
            MOV     TL1,#0FFH
            SETB    ET1                     ; Enable Timer1 Interupt
            SETB    TR1                     ; Start Timer1 Count
            SETB    EA                      ; Enable Global Interupt
            ;
            MOV     R2,#8
            MOV     R0,#DSP_BUFF
            MOV     A,#0AH
CLR_DSPY:   MOV     @R0,A
            INC     R0
            DJNZ    R2,CLR_DSPY
            ;
;            LCALL   DISABLE                 ; Write Protect OFF
;            MOV     A,#SECOND
;            LCALL   READ_RTC
;            CLR     ACC.7                   ; Disable Clock Halt Flag
;            MOV     B,A
;            MOV     A,#SECOND
;            LCALL   WRITE_RTC
;            ;
;            MOV     A,#YEAR
;            MOV     B,#98H
;            LCALL   WRITE_RTC
;            MOV     A,#MONTH
;            MOV     B,#08H
;            LCALL   WRITE_RTC
;            MOV     A,#DATE
;            MOV     B,#25H
;            LCALL   WRITE_RTC
;            ;
;            MOV     A,#HOUR
;            MOV     B,#12H
;            LCALL   WRITE_RTC
;            MOV     A,#MINUTE
;            MOV     B,#20H
;            LCALL   WRITE_RTC
;            MOV     A,#SECOND
;            MOV     B,#00H
;            LCALL   WRITE_RTC
;            ;
;            LCALL   ENABLE                  ; Write Protect ON
            ;
LOOP:       JB      UPDATE,DSP_TIME
            SJMP    LOOP
            ;
DSP_TIME:   MOV     A,#HOUR                 ; Get Hour Time
            LCALL   READ_RTC
            PUSH    ACC
            SWAP    A
            ANL     A,#0FH
            MOV     DSP_BUFF+0,A
            POP     ACC
            ANL     A,#0FH
            MOV     DSP_BUFF+1,A
            ;
            JNB     STAS_DSP,DSP_TIM1
            MOV     DSP_BUFF+2,#25H         ; "-"
            SJMP    DSP_TIM2
DSP_TIM1:   MOV     DSP_BUFF+2,#0AH         ; Blank
            ;
DSP_TIM2:   MOV     A,#MINUTE               ; Get Minute Time
            LCALL   READ_RTC
            PUSH    ACC
            SWAP    A
            ANL     A,#0FH
            MOV     DSP_BUFF+3,A
            POP     ACC
            ANL     A,#0FH
            MOV     DSP_BUFF+4,A
            ;
            JNB     STAS_DSP,DSP_TIM3
            MOV     DSP_BUFF+5,#25H         ; "-"
            SJMP    DSP_TIM4
DSP_TIM3:   MOV     DSP_BUFF+5,#0AH         ; Blank
            ;
DSP_TIM4:   MOV     A,#SECOND               ; Get Second Time
            LCALL   READ_RTC
            PUSH    ACC
            SWAP    A
            ANL     A,#0FH
            MOV     DSP_BUFF+6,A
            POP     ACC
            ANL     A,#0FH
            MOV     DSP_BUFF+7,A
            CLR     UPDATE
            SJMP    LOOP

;/*********************/;
;/* Shift Left Buffer */;
;/*   DSP_BUFF+0..7   */;
;/* MSB <- LSB <- ACC */;
;/*********************/;
;
SHF_BUFF:   PUSH    ACC
            MOV     R0,#DSP_BUFF+0
            MOV     R1,#DSP_BUFF+1
            MOV     R2,#7
SHF_BUF1:   MOV     A,@R1
            MOV     @R0,A
            INC     R0
            INC     R1
            DJNZ    R2,SHF_BUF1
            POP     ACC
            MOV     @R0,A
            RET

;/*****************************/;
;/* Timer0 : Service Routines */;
;/* Interupt Every 1 milliSec */;
;/* Scan Display on Interrupt */;
;/* Display 7-Segment 8-Digit */;
;/* Input : DSP_BUFF (8-Byte) */;
;/*       : DIG_BUFF (^DSP8)  */;
;/*       : SCAN_BUF (Colum)  */;
;/*       : SCAN_CNT (Count)  */;
;/*****************************/;
;
SCAN_DSP:   PUSH    PSW                     ; Save Register
            PUSH    DPH
            PUSH    DPL
            PUSH    ACC
            PUSH    B
            SETB    RS0                     ; Select Register Bank-1
            ;
            MOV     TH0,#0FCH               ; 1 milliSec Auto Reload
            MOV     TL0,#066H
            MOV     R0,DIG_BUFF             ; Buffer Display Code
            ;
SCAN_DS1:   SETB    GATE_DSP                ; Disable Data Display
            MOV     P2,#00H                 ; Disable Colum Display
            MOV     DPTR,#TAB_14SEG
            MOV     A,@R0
            MOV     B,#2                    ; 2 Byte / 1 Code
            MUL     AB
            MOV     B,A                     ; Save Pointer
            MOVC    A,@A+DPTR               ; Get High Byte From Table
            MOV     P0,A
            CLR     DISPLAY2                ; Latch High Byte Display
            SETB    DISPLAY2
            MOV     A,B                     ; Get Pointer
            INC     A                       ; Adjust to Low Byte
            MOVC    A,@A+DPTR               ; Get Low Byte From Table
            MOV     P0,A
            CLR     DISPLAY1                ; Latch Low Byte Display
            SETB    DISPLAY1
            MOV     P2,SCAN_BUF             ; Scan Display
            CLR     GATE_DSP                ; Enable Scan Display
            ;
            INC     DIG_BUFF                ; Next Digit Scan
            MOV     A,SCAN_BUF
            RL      A
            MOV     SCAN_BUF,A
            DJNZ    SCAN_CNT,SCAN_DS2
            MOV     SCAN_CNT,#08H           ; Scan Count = 8-Digit
            MOV     SCAN_BUF,#01H           ; Scan ULN2803 = Colum0
            MOV     DIG_BUFF,#DSP_BUFF      ; Display Buffer = DG-0
            ;
SCAN_DS2:   POP     B
            POP     ACC
            POP     DPL
            POP     DPH
            POP     PSW
            RETI

;/******************************/;
;/* Timer 1 0.5 Second Service */;
;/*    Interupt Every 10 mSec  */;
;/* Auto Reload Every0.5Second */;
;/******************************/;
;
TIMER_INT:  MOV     TH1,#0DBH               ; 10 mSec Period Auto Reload
            MOV     TL1,#0FFH
            DJNZ    SEC_CNT+0,END_TIME      ; Check Time = 0.5 Second?
            MOV     SEC_CNT+0,#50           ; 10mSec x 50 = 0.5 Second
            CPL     STAS_DSP                ; Toggle Status Display
            SETB    UPDATE                  ; Update Time
END_TIME:   RETI

;/*************************/;
;/*           A            /;
;/*        -------         /;
;/*      | I  J  K |       /;
;/*    F |  \ | /  | B     /;
;/*      |   ...   |       /;
;/*        -G- -H-         /;
;/*      |   ...   |       /;
;/*    E |  / | \  | C     /;
;/*      | L  M  N |       /;
;/*        -------   **    /;
;/*           D      Dp    /;
;/*                        /;
;/*************************/;
;/* Table of Display Code */;
;/* 1st Byte = High Byte  */;
;/* 2nd Byte = Low Byte   */;
;/* Hi = Dp x N M L K J I */;
;/* Lo =  H G F E D C B A */;
;/* Data D7 ...........D0 */;
;/* Data in This Table is */;
;/* Hi1,Lo1,Hi2,Lo2.....  */;
;/*************************/;
;
TAB_14SEG:  DB      00CH,03FH,000H,006H     ; 0     1
            DB      008H,08BH,000H,08FH     ; 2     3
            DB      000H,0E6H,020H,069H     ; 4     5
            DB      000H,0FDH,00CH,001H     ; 6     7
            DB      000H,0FFH,000H,0EFH     ; 8     9
            DB      000H,000H,000H,0F7H     ; Sp    A
            DB      012H,08FH,000H,039H     ; B     C
            DB      012H,00FH,000H,079H     ; D     E
            DB      000H,071H,000H,0BDH     ; F     G
            DB      000H,0F6H,012H,009H     ; H     I
            DB      000H,01EH,024H,070H     ; J     K
            DB      000H,038H,005H,036H     ; L     M
            DB      021H,036H,000H,03FH     ; N     O
            DB      000H,0F3H,020H,03FH     ; P     Q
            DB      020H,0F3H,000H,0EDH     ; R     S
            DB      012H,001H,000H,03EH     ; T     U
            DB      00CH,030H,028H,036H     ; V     W
            DB      02DH,000H,015H,000H     ; X     Y
            DB      00CH,009H,000H,0C0H     ; Z     -

;/*********************/;
;/** Reset Watch-Dog **/;
;/*********************/;
;
WATCHDOG:   CLR     RST_WATCH               ; Reset Watch-Dog
            SETB    RST_WATCH               ; Enable Watch-Dog
            RET



;/****************************/;
;/* Read Ram From RTC-DS1202 */;
;/* Input    : ACC = Address */;
;/* Output   : ACC = Data    */;
;/* Reg.     : ACC,B,R2      */;
;/****************************/;
;
READ_RAM:   LCALL   START_RST           ; Start Communication
            MOV     R2,#8
            RL      A                   ; Shift A0 to A1
            SETB    ACC.7               ; Command Status
            SETB    ACC.6               ; Ram Accress
            SETB    ACC.0               ; Read Command
            CLR     CY
READ_RAM1:  LCALL   CLOCK_LO            ; Falling Clock
            RRC     A                   ; Send D0..D7 (Read-Command)
            MOV     RTC_DATA,C          ; Prepare Port
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,READ_RAM1        ; Repeat Send Read-Command
            ;
            MOV     B,#0
            MOV     R2,#8
READ_RAM2:  SETB    RTC_DATA            ; Initial for Input
            NOP
            NOP
            LCALL   CLOCK_LO            ; Read data D0..D7 (Data)
            NOP                         ; Wait Data From RTC
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            MOV     C,RTC_DATA          ; Read data out bit
            MOV     A,B
            RRC     A                   ; Read D0..D7
            MOV     B,A                 ; Backup Data
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,READ_RAM2
            MOV     A,B                 ; Data Output 1-Byte
            LCALL   STOP_RST            ; Disable Communication
            RET

;/***************************/;
;/* Write Ram to RTC-DS1202 */;
;/* Input   : ACC = Address */;
;/*         : B = Data      */;
;/* Reg.    : ACC,B,R2      */;
;/***************************/;
;
WRITE_RAM:  LCALL   START_RST           ; Enable Communication
            MOV     R2,#8
            RL      A                   ; Shift A0 to A1
            SETB    ACC.7               ; Command Status
            SETB    ACC.6               ; Ram Accress
            CLR     ACC.0               ; Write Command
            CLR     CY
WRITE_RAM1: LCALL   CLOCK_LO            ; Falling Clock
            RRC     A                   ; Send D0..D7 (Write-Command)
            MOV     RTC_DATA,C
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,WRITE_RAM1       ; Repeat write Command
            ;
            MOV     A,B                 ; Get Data For Send
            MOV     R2,#8
            CLR     CY
WRITE_RAM2: LCALL   CLOCK_LO            ; Falling Clock
            RRC     A                   ; Write D0..D7
            MOV     RTC_DATA,C
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI
            DJNZ    R2,WRITE_RAM2       ; Repeat write Data
            LCALL   STOP_RST            ; Disable Communication
            RET

;/****************************/;
;/* Read RTC From RTC-DS1202 */;
;/* Input    : ACC = Address */;
;/* Output   : ACC = Data    */;
;/* Reg.     : ACC,B,R2      */;
;/****************************/;
;
READ_RTC:   LCALL   START_RST           ; Start Communication
            MOV     R2,#8
            RL      A                   ; Shift A0 to A1
            SETB    ACC.7               ; Command Status
            CLR     ACC.6               ; Ram Accress
            SETB    ACC.0               ; Read Command
            CLR     CY
READ_RTC1:  LCALL   CLOCK_LO            ; Falling Clock
            RRC     A                   ; Send D0..D7 (Read-Command)
            MOV     RTC_DATA,C          ; Prepare Port
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI            ; Clock
            DJNZ    R2,READ_RTC1        ; Repeat write Command
            ;
            MOV     B,#0
            MOV     R2,#8
READ_RTC2:  SETB    RTC_DATA            ; Initial for Input
            NOP
            NOP
            SETB    RTC_DATA            ; Initial for Input
            LCALL   CLOCK_LO            ; Read data D0..D7 (Data)
            NOP                         ; Wait Data From RTC
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            MOV     C,RTC_DATA          ; Read data out bit
            MOV     A,B
            RRC     A                   ; Read D0..D7
            MOV     B,A                 ; Backup Data
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,READ_RTC2
            MOV     A,B                 ; Data Output 1-Byte
            LCALL   STOP_RST            ; Disable Communication
            RET

;/***************************/;
;/* Write RTC to RTC-DS1202 */;
;/* Input   : ACC = Address */;
;/*         : B = Data      */;
;/* Reg.    : ACC,B,R2      */;
;/***************************/;
;
WRITE_RTC:  LCALL   START_RST           ; Enable Communication
            MOV     R2,#8
            RL      A                   ; Shift A0 to A1
            SETB    ACC.7               ; Command Status
            CLR     ACC.6               ; Ram Accress
            CLR     ACC.0               ; Write Command
            CLR     CY
WRITE_RTC1: LCALL   CLOCK_LO            ; Falling Clock
            RRC     A                   ; Write D0..D7 (Command)
            MOV     RTC_DATA,C
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,WRITE_RTC1       ; Repeat write Command
            ;
            MOV     A,B                 ; Get Data
            MOV     R2,#8
            CLR     CY
WRITE_RTC2: LCALL   CLOCK_LO
            RRC     A                   ; Write D0..D7
            MOV     RTC_DATA,C
            NOP                         ; Wait Bus Ready
            NOP
            NOP
            NOP
            LCALL   CLOCK_HI            ; Rising Clock
            DJNZ    R2,WRITE_RTC2       ; Repeat write Data
            LCALL   STOP_RST            ; Disable Communication
            RET

;/*************************/;
;/* Write Protect Disable */;
;/* Now You Can Write RTC */;
;/* Reg.    : ACC,B,R2    */;
;/*************************/;
;
DISABLE:    MOV     A,#CTRL_RTC
            MOV     B,#00H              ; Disable Write-Protect
            LCALL   WRITE_RTC
            RET

;/************************/;
;/* Write Protect Enable */;
;/* You Can't Write RTC  */;
;/* Reg.    : ACC,B,R2   */;
;/************************/;
;
ENABLE:     MOV     A,#CTRL_RTC
            MOV     B,#80H              ; Enable Write-Protect
            LCALL   WRITE_RTC
            RET

;/*****************/;
;/*  RTC Clock    */;
;/*  Falling Edge */;
;/*****************/;
;
CLOCK_LO:   CLR     RST_WATCH           ; Reset Watch-Dog
            SETB    RST_WATCH           ; Enable Watch-Dog
            CLR     RTC_CLOCK           ; Falling Clock
            NOP
            NOP
            NOP
            NOP
            RET

;/***************/;
;/* RTC Clock   */;
;/* Rising Edge */;
;/***************/;
;
CLOCK_HI:   CLR     RST_WATCH           ; Reset Watch-Dog
            SETB    RST_WATCH           ; Enable Watch-Dog
            SETB    RTC_CLOCK           ; Rising Clock
            NOP
            NOP
            NOP
            NOP
            RET

;/*************************/;
;/* Initial Reset & Clock */;
;/* For Start Communicate */;
;/*************************/;
;
START_RST:  CLR     RST_WATCH           ; Reset Watch-Dog
            SETB    RST_WATCH           ; Enable Watch-Dog
            CLR     RTC_RESET
            CLR     RTC_CLOCK
            NOP
            NOP
            NOP
            NOP
            SETB    RTC_RESET           ; Enable Communication
            NOP
            NOP
            NOP
            NOP
            RET

;/*************************/;
;/* Initial Reset & Clock */;
;/*  For Stop Communicate */;
;/*************************/;
;
STOP_RST:   CLR     RST_WATCH           ; Reset Watch-Dog
            SETB    RST_WATCH           ; Enable Watch-Dog
            SETB    RTC_CLOCK
            NOP
            NOP
            NOP
            NOP
            CLR     RTC_RESET           ; Disable Communication
            NOP
            NOP
            NOP
            NOP
            RET

            END



