;****************************************************************************
; PIC14000 Header
;       Copyright 1995, 1997 microEngineering Labs, Inc.
;****************************************************************************

					; *** Default Device Specifications
		DEVICE  3FFF3FFFh       ; All Fuse Bits On
		DEVICE  50080003h       ; 14-Bit, 4K Code, 0 EE, ID = 3

					; *** DEVICE Device Definitions
PIC14000        equ     50080003h       ; 14-Bit, 4K Code, 0 EE, ID = 3

					; *** DEVICE Fuses Definitions
RC_OSC          equ     3FFE0001h       ; XX XXXX XXXX XXX1
HS_OSC          equ     3FFE0000h       ; XX XXXX XXXX XXX0
WDT_ON          equ     3FFB0004h       ; XX XXXX XXXX X1XX
WDT_OFF         equ     3FFB0000h       ; XX XXXX XXXX X0XX
PWRT_OFF        equ     3FF70008h       ; XX XXXX XXXX 1XXX
PWRT_ON         equ     3FF70000h       ; XX XXXX XXXX 0XXX
PROTECT_OFF     equ     004F3FB0h       ; 11 1111 1X11 XXXX
PROTECT_ON      equ     004F0000h       ; 00 0000 0X00 XXXX

					; *** Register Names
INDF            equ     00h             ; Indirect Data
TMR0            equ     01h             ; Real Time Clock/Counter
PCL             equ     02h             ; Program Counter (LSB)
STATUS          equ     03h             ; Status Flags
FSR             equ     04h             ; File Select Register
PORTA           equ     05h             ; Port A Data
RA              equ     05h
PORTC           equ     07h             ; Port C Data
RC              equ     07h
PORTD           equ     08h             ; Port D Data
RD              equ     08h
PCLATH          equ     0Ah             ; Program Counter (MSB)
INTCON          equ     0Bh             ; Interrupt Control
PIR1            equ     0Ch             : Peripheral Interrupt Flags 1
ADTMRL          equ     0Eh             ; A/D Capture Timer Data (LSB)
ADTMRH          equ     0Fh             ; A/D Capture Timer Data (MSB)
I2CBUF          equ     13h             ; I2C Data
I2CCON          equ     14h             ; I2C Control
ADCAPL          equ     15h             ; A/D Capture Latch (LSB)
ADCAPH          equ     16h             ; A/D Capture Latch (MSB)
ADCON0          equ     1Fh             ; A/D Control 0
OPTION          equ     81h             ; OPTION Register
TRISA           equ     85h             ; Port A Tristate Control
TRISC           equ     87h             ; Port C Tristate Control
TRISD           equ     88h             ; Port D Tristate Control
PIE1            equ     8Ch             ; Peripheral Interrupt Enables 1
PCON            equ     8Eh             ; Power Control
SLPCON          equ     8Fh             ; Sleep Control
I2CADD          equ     93h             ; I2C Address
I2CSTAT         equ     94h             ; I2C Status Flags
LDACA           equ     9Bh             ;
LDACB           equ     9Ch             ;
CHGCON          equ     9Dh             ;
MISC            equ     9Eh             ;
ADCON1          equ     9Fh             ; A/D Control 1

					; *** STATUS Bits
C               equ     STATUS.0        ; Carry
DC              equ     STATUS.1        ; Digit (Half) Carry
Z               equ     STATUS.2        ; Zero
PD              equ     STATUS.3        ; Power Down
TO              equ     STATUS.4        ; Time Out
RP0             equ     STATUS.5        ; Direct Data Page Select 0
RP1             equ     STATUS.6        ; Direct Data Page Select 1
IRP             equ     STATUS.7        ; Indirect Data Page Select

					; *** INTCON Bits
T0IF            equ     INTCON.2        ; TMR0 Overflow Interrupt Flag
T0IE            equ     INTCON.5        ; TMR0 Overflow Interrupt Enable
PEIE            equ     INTCON.6        ; Peripheral Interrupt Enable
GIE             equ     INTCON.7        ; Global Interrupt Enable

					; *** PIR1 Bits
OVFIF           equ     PIR1.0          ; A/D Counter Overflow Interrupt Flag
ADCIF           equ     PIR1.1          ; A/D Conversion Complete Capture Interrupt Flag
RCIF            equ     PIR1.2          ; Port C Interrupt On Change Flag
I2CIF           equ     PIR1.3          ; I2C Port Interrupt Flag
PBIF            equ     PIR1.4          ; External Push Button Interrupt Flag
WUIF            equ     PIR1.7          ; Wake-up On Current Flow Interrupt Flag

                                        ; *** I2CCON Bits
I2CM0           equ     SSPCON.0        ; I2C Mode Select (4 Bits)
I2CM1           equ     SSPCON.1
I2CM2           equ     SSPCON.2
I2CM3           equ     SSPCON.3
CKP             equ     SSPCON.4        ; Clock Polarity Select
I2CEN           equ     SSPCON.5        ; I2C Enable
I2COV           equ     SSPCON.6        ; I2C Receive Overflow Flag
WCOL            equ     SSPCON.7        ; Write Collision Detect

					; *** ADCON0 Bits
ADZERO          equ     ADCON0.0        ; A/D Zero Select Control
ADRST           equ     ADCON0.1        ; A/D Reset Control Bit
AMUXOE          equ     ADCON0.2        ; Analog Mux Output Enable
ADCS0           equ     ADCON0.4        ; A/D Channel Select (4 Bits)
ADCS1           equ     ADCON0.5
ADCS2           equ     ADCON0.6
ADCS3           equ     ADCON0.7

					; *** OPTION Bits
PS0             equ     OPTION.0        ; Prescaler Divisor Select (3 Bits)
PS1             equ     OPTION.1
PS2             equ     OPTION.2
PSA             equ     OPTION.3        ; Prescaler Assignment
T0SE            equ     OPTION.4        ; Timer0 Source Edge Select
T0CS            equ     OPTION.5        ; Timer0 Clock Source Select
RCPU            equ     OPTION.7        ; Port C Pull-Up Enable

					; *** PIE1 Bits
OVFIE           equ     PIE1.0          ; A/D Counter Overflow Interrupt Enable
ADCIE           equ     PIE1.1          ; A/D Conversion Complete Capture Interrupt Enable
RCIE            equ     PIE1.2          ; Port C Interrupt On Change Enable
I2CIE           equ     PIE1.3          ; I2C Port Interrupt Enable
PBIE            equ     PIE1.4          ; External Push Button Interrupt Enable
WUIE            equ     PIE1.7          ; Wake-up On Current Flow Interrupt Enable

					; *** PCON Bits
LVD             equ     PCON.0          ; Low Voltage Detect Flag
POR             equ     PCON.1          ; Power-On Reset Flag

                                        ; *** SLPCON Bits
ADOFF           equ     SLPCON.0        ; A/D Module Power Control
TEMPOFF         equ     SLPCON.1        ; On-chip Temperature Sensor Power Control
CWUOFF          equ     SLPCON.2        ; Charge Controller/Current Flow Detect Power Control
OSCOFF          equ     SLPCON.3        ; Internal Oscillator On/Off During Sleep Mode
BIASOFF         equ     SLPCON.4        ; Summing Junction Current Bias Source Power Control
REFOFF          equ     SLPCON.5        ; References Power Control
HIBEN           equ     SLPCON.7        ; Hibernate Mode Select

                                        ; *** I2CSTAT Bits
BF              equ     I2CSTAT.0       ; I2C Buffer Full Flag
UA              equ     I2CSTAT.1       ; I2C Update Address Flag
R_W             equ     I2CSTAT.2       ; I2C Read/Write Status
S               equ     I2CSTAT.3       ; I2C Start Flag
P               equ     I2CSTAT.4       ; I2C Stop Flag
D_A             equ     I2CSTAT.5       ; I2C Data/Address Flag

                                        ; *** LDACA Bits
LDASEL0         equ     LDACA.0         ; DAC A Voltage Select Bits (8 Bits)
LDASEL1         equ     LDACA.1
LDASEL2         equ     LDACA.2
LDASEL3         equ     LDACA.3
LDASEL4         equ     LDACA.4
LDASEL5         equ     LDACA.5
LDASEL6         equ     LDACA.6
LDASEL7         equ     LDACA.7

                                        ; *** LDACB Bits
LDBSEL0         equ     LDBCA.0         ; DAC B Voltage Select Bits (8 Bits)
LDBSEL1         equ     LDBCA.1
LDBSEL2         equ     LDBCA.2
LDBSEL3         equ     LDBCA.3
LDBSEL4         equ     LDBCA.4
LDBSEL5         equ     LDBCA.5
LDBSEL6         equ     LDBCA.6
LDBSEL7         equ     LDBCA.7

                                        ; *** CHGCON Bits
CPOLA           equ     CHGCON.0        ; Charge Control Polarity Bit A
CCAEN           equ     CHGCON.1        ; Charge Control Function Enable Bit A
CCOMPA          equ     CHGCON.2        ; Charge Control Comparator Output A
CPOLB           equ     CHGCON.4        ; Charge Control Polarity Bit B
CCBEN           equ     CHGCON.5        ; Charge Control Function Enable Bit B
CCOMPB          equ     CHGCON.6        ; Charge Control Comparator Output B

                                        ; *** MISC Bits
OSC1            equ     MISC.0          ; OSC1 Input Port Bit
OSC2            equ     MISC.1          ; OSC2 Input Port Bit
INCLKEN         equ     MISC.2          ; Oscillator Output Select
SMBUS           equ     MISC.3          ; SMBus-Compatibility Select
I2CSEL          equ     MISC.4          ; I2C Port Select Bit
SPGNDA          equ     MISC.5          ; Serial Port Ground Select
SPGNDB          equ     MISC.6          ; Serial Port Ground Select
SMHOG           equ     MISC.7          ; SMHOG Enable

					; *** ADCON1 Bits
ACFG0           equ     ADCON1.0        ; Port A Configuration Selects (2 Bits)
ACFG1           equ     ADCON1.1
ACFG2           equ     ADCON1.2        ; Port D Configuration Selects (2 Bits)
PCFG3           equ     ADCON1.3
ADDAC0          equ     ADCON1.4        ; A/D Current DAC Selects (4 Bits)
ADDAC1          equ     ADCON1.5
ADDAC2          equ     ADCON1.6
ADDAC3          equ     ADCON1.7
