;****************************************************************************
; PIC12C67x Family Header
;       Copyright 1995, 1997 microEngineering Labs, Inc.
;****************************************************************************

					; *** Default Device Specifications
                DEVICE  3FFF3FFFh       ; All Fuse Bits On
                DEVICE  50020001h       ; 14-Bit,  1K Code, 0 EE, ID = 1

					; *** DEVICE Device Definitions
PIC12C671       equ     50020001h       ; 14-Bit,  1K Code, 0 EE, ID = 1
PIC12C672       equ     50040002h       ; 14-Bit,  2K Code, 0 EE, ID = 2

					; *** DEVICE Fuses Definitions
EXTRC_OSC       equ     3FFC0003h       ; XX XXXX XXXX XX11
INTRC_OSC       equ     3FFC0002h       ; XX XXXX XXXX XX10
XT_OSC          equ     3FFC0001h       ; XX XXXX XXXX XX01
LP_OSC          equ     3FFC0000h       ; XX XXXX XXXX XX00
WDT_ON          equ     3FFB0004h       ; XX XXXX XXXX X1XX
WDT_OFF         equ     3FFB0000h       ; XX XXXX XXXX X0XX
PWRT_OFF        equ     3FF70008h       ; XX XXXX XXXX 1XXX
PWRT_ON         equ     3FF70000h       ; XX XXXX XXXX 0XXX
PROTECT_OFF     equ     00CF3F30h       ; 11 1111 XX11 XXXX
PROTECT_ON      equ     00CF0000h       ; 00 0000 XX00 XXXX
MCLR_ON         equ     3FBF0040h       ; XX XXXX X1XX XXXX
MCLR_OFF        equ     3FBF0000h       ; XX XXXX X0XX XXXX

					; *** Register Names
INDF            equ     00h             ; Indirect Data
TMR0            equ     01h             ; Real Time Clock/Counter
PCL             equ     02h             ; Program Counter (LSB)
STATUS          equ     03h             ; Status Flags
FSR             equ     04h             ; File Select Register
GPIO            equ     05h             ; General Purpose I/O Port
PCLATH          equ     0Ah             ; Program Counter (MSB)
INTCON          equ     0Bh             ; Interrupt Control
PIR1            equ     0Ch             : Peripheral Interrupt Flags 1
ADRES           equ     1Eh             ; A/D Result
ADCON0          equ     1Fh             ; A/D Control 0
OPTION          equ     81h             ; OPTION Register
TRISIO          equ     85h             ; GPIO Tristate Control
PIE1            equ     8Ch             ; Peripheral Interrupt Enables 1
PCON            equ     8Eh             ; Power Control
OSCCAL          equ     8Fh             ; Oscillator Calibration
ADCON1          equ     9Fh             ; A/D Control 1

					; *** STATUS Bits
C               equ     STATUS.0        ; Carry
DC              equ     STATUS.1        ; Digit (Half) Carry
Z               equ     STATUS.2        ; Zero
PD              equ     STATUS.3        ; Power Down
TO              equ     STATUS.4        ; Time Out
RP0             equ     STATUS.5        ; Direct Data Page Select 0
RP1             equ     STATUS.6        ; Direct Data Page Select 1
IRP             equ     STATUS.7        ; Indirect Data Page Select

					; *** INTCON Bits
GPIF            equ     INTCON.0        ; GPIO[0,1,3] Change Interrupt Flag
T0IF            equ     INTCON.2        ; TMR0 Overflow Interrupt Flag
RBIE            equ     INTCON.3        ; PORTB[4..7] Change Interrupt Enable
T0IE            equ     INTCON.5        ; TMR0 Overflow Interrupt Enable
PEIE            equ     INTCON.6        ; Peripheral Interrupt Enable
GIE             equ     INTCON.7        ; Global Interrupt Enable

					; *** PIR1 Bits
ADIF            equ     PIR1.6          ; A/D Interrupt Flag

					; *** ADCON0 Bits
ADON            equ     ADCON0.0        ; A/D Power Control
GO_DONE         equ     ADCON0.2        ; A/D GO/DONE Bit
CHS0            equ     ADCON0.3        ; A/D Channel Select (3 Bits)
CHS1            equ     ADCON0.4
ADCS0           equ     ADCON0.6        ; A/D Clock Select (2 Bits)
ADCS1           equ     ADCON0.7

					; *** OPTION Bits
PS0             equ     OPTION.0        ; Prescaler Divisor Select (3 Bits)
PS1             equ     OPTION.1
PS2             equ     OPTION.2
PSA             equ     OPTION.3        ; Prescaler Assignment
T0SE            equ     OPTION.4        ; Timer0 Source Edge Select
T0CS            equ     OPTION.5        ; Timer0 Clock Source Select
GPPU            equ     OPTION.7        ; Enable Weak Pullups

					; *** PIE1 Bits
ADIE            equ     PIE1.6          ; A/D Interrupt Enable

					; *** PCON Bits
POR             equ     PCON.1          ; Power-On Reset Flag

					; *** ADCON1 Bits
PCFG0           equ     ADCON1.0        ; A/D Configuration (3 Bits)
PCFG1           equ     ADCON1.1
PCFG2           equ     ADCON1.2

