' PROGRAM TEST  BOARD ET-BASIC STAMP V2.0
' TEST ATOD , RTC ,LCD
'
Symbol  TX7 = 7                                  ' Serial Output Channel
Symbol  RX6 = 6                                  ' Serial Input Channel
'
MAIN:
        Serout TX7,T2400,(13,10,13,10,"TEST BOARD ET-BASIC STAMP V2.0",13,10)
        Serout TX7,T2400,("  1=LCD",13,10)
        Serout TX7,T2400,("  2=A/D TLC1298",13,10)
        Serout TX7,T2400,("  3=PORT 34 PIN",13,10)
        
        Serout TX7,T2400,(" SELECT #!",13,10)

        Serin  RX6,T2400,B0
        IF B0 = "1" THEN LOOPLCD
        IF B0 = "2" THEN LOOPAD
        IF B0 = "3" THEN LOOPPORT

        GOTO MAIN
        PAUSE 100

loopPORT:
  pins=%00000000
	pause 1000
  high 0
	pause 1000	
  high 1
  pause 1000
 	high 2
	pause 1000
	high 3
	pause 1000
	high 4
	pause 1000
	high 5
	pause 1000
	high 6
	pause 1000
	high 7
	pause 1000
	pins=%11111111
	pause 1000 
	pins=%00000000
	pause 1000
  goto loopPORT


' PROGRAM TEST ET-BASIC STAMP V2.0
' LCD MODULE 16216H

SYMBOL   SHIFT      = 2   'Shift Clock pin
SYMBOL   LATCH      = 1   'Latch Clock pin
SYMBOL   DATA_IN    = 0   'Serial Input pin

SYMBOL   DSP_BUF    =    B0    'Buffer Data for Display
SYMBOL   INDEX_WR   =    B1
SYMBOL   DSP_BUFBUF =    B3
SYMBOL   CHAR       =    B4
SYMBOL   I          =    B5

LOOPLCD:      LET PINS = 0    'CLEAR OUTPUT LINE
            PAUSE 200       'WAIT 200MS POWER UP LCD RESET

INSLCD:     FOR I= 1 TO 3   'INIT LCD SET 4 BIT DATA
             DSP_BUF = %00000011
             GOSUB WR_E_PLUS
            NEXT I

            FOR I = 1 TO 3
             DSP_BUF = %00000010
             GOSUB WR_E_PLUS
            NEXT I

            CHAR=%00001111
            GOSUB WR_INS
            CHAR=%00000110
            GOSUB WR_INS
            CHAR=%00101100
            GOSUB WR_INS
            CHAR=%00000001
            GOSUB WR_INS

            FOR I = $40 TO $4F   'WRITE DATA TO LCD
             CHAR=I
             GOSUB WR_DATA
            NEXT I
		
            CHAR=%11000000       'GOTO COMMAND 40H LINE 2
            GOSUB WR_INS

            FOR I= $30 TO $3F    'WRITE DATA TO LCD
             CHAR = I
             GOSUB WR_DATA
            NEXT I
            GOTO MAIN

'
'WR_DATA = WRITE DATA CODE TO LCD
'
WR_DATA:        B2= CHAR/16
                DSP_BUF=B2
                GOSUB WRRS                  'E PLUS RS=1
                B2= CHAR & %00001111
                DSP_BUF =B2
                GOSUB WRRS
                RETURN
'                
'WR_INS = WRITE INS CODE TO LCD        
'
WR_INS:         B2= CHAR/16                    'shift right 4 bit
                DSP_BUF=B2
                GOSUB WR_E_PLUS
                B2= CHAR & %00001111
                DSP_BUF =B2
                GOSUB WR_E_PLUS
                RETURN
'
'WRRS        = WRITE E PLUS DATA TO LCD RS=1
'WR_E_PLUS   = WRITE E PLUS INS TO LCD RS=0
'
WRRS:           DSP_BUF = DSP_BUF*16
                DSP_BUF = DSP_BUF |  %00001100
                GOTO WR_E_PLUS2

WR_E_PLUS:      DSP_BUF = DSP_BUF*16            'shift left 4 bit
                DSP_BUF = DSP_BUF |  %00001000  'E=1
WR_E_PLUS2:     GOSUB WR_595
                DSP_BUF = DSP_BUF & %11110111   'E=0
                GOSUB WR_595
                RETURN
'
'WR_595 = Send Data 8 bit to 74HC595 for LCD  
'
WR_595:         FOR INDEX_WR = 1 TO 8       '8bit Data for Shift Out
                IF BIT7 = 0 THEN WR_LOW     'Shift D7..D0
WR_HIGH:        HIGH DATA_IN
                GOTO SHF_OUT
WR_LOW:         LOW DATA_IN
SHF_OUT:        PULSOUT SHIFT,5             'Shift Clock
                DSP_BUF = DSP_BUF*2         'Shift Left Data
                NEXT INDEX_WR               'Loop until 8bit data
                PULSOUT LATCH,5             'Latch Clock
                RETURN

' TEST ET-BASIC STAMP V2.0 ADC Test with LTC1298
'
'       W10     Conversion Result [0 = 0V,4095 = 5V]

Symbol  S7 = 7                                  ' Serial Output Channel

LoopAD:   CALL CS_AD
        Call AD0 : W0 = W10                     ' Read Input 0
        CALL CS_AD
        Call AD1 : W1 = W10                     ' Read Input 1

        Serout S7,T2400,("CH0 = ",#W0,"  CH1 = ",#W1,13,10)
        PAUSE 100
        Goto  LoopAD

'
ASM
_CS_AD   BCF PORTA.3        ;SET CS = 0
         GOTO DONE
ENDASM

END

