;*********************************************
;*        PRGRAM TEST FOR ET-EM_AT51         *
;*           ON BAORD CP-JR31                *
;*           TEST WITH ET-TEST I/O           *
;*           BUS 72IOZ80,(8155)              *
;*           CPU AT89S53                     *
;*********************************************
                        ORG     0000H        ;origin  start
                        ;
                        MOV     SP,#256-32   ;set sp = 32 byte
                        CLR     EA           ;not interrupt
                        ;
START:                  MOV     R2,#00H      ;power on delay 
PWR_DLY:                MOV     R3,#00H
PWR_DLY1:               DJNZ    R3,$
                        DJNZ    R2,PWR_DLY1
                        ;
MAIN:                   MOV     DPTR,#0E100H ;control port 8155
                        MOV     A,#0FH       ;pa,pb,pc out
                        MOVX    @DPTR,A
                        ;
MAIN1:                  MOV     A,#00H
                        ;
MAIN2:                  MOV     DPTR,#0E101H ;clear led out  PA
                        MOVX    @DPTR,A
                        MOV     DPTR,#0E102H ;clear led out  PB
                        MOVX    @DPTR,A
                        MOV     DPTR,#0E103H ;clear led out  PC 
                        MOVX    @DPTR,A
                        LCALL   DELAY
                        ;
MAINX:                  MOV     R2,#08H
                        MOV     R1,#01H
MAIN3:                  MOV     A,R1
                        MOV     DPTR,#LED
                        MOVC    A,@A+DPTR
                        MOV     DPTR,#0E101H ;out PA
                        MOVX    @DPTR,A
                        LCALL   DELAY
                        INC     R1
                        DJNZ    R2,MAIN3
                        ;
                        MOV     R2,#08H
                        MOV     R1,#01H
MAIN4:                  MOV     A,R1
                        MOV     DPTR,#LED
                        MOVC    A,@A+DPTR
                        MOV     DPTR,#0E102H ;out PB
                        MOVX    @DPTR,A
                        LCALL   DELAY
                        INC     R1
                        DJNZ    R2,MAIN4
                        ;
                        MOV     R2,#06H
                        MOV     R1,#01H
MAIN5:                  MOV     A,R1
                        MOV     DPTR,#LED
                        MOVC    A,@A+DPTR
                        MOV     DPTR,#0E103H ;out PC
                        MOVX    @DPTR,A
                        LCALL   DELAY
                        INC     R1
                        DJNZ    R2,MAIN5
                        ;
                        MOV     R2,#06H
                        MOV     R1,#05H
MAIN6:                  MOV     A,R1
                        MOV     DPTR,#LED
                        MOVC    A,@A+DPTR
                        MOV     DPTR,#0E103H ;out PC
                        MOVX    @DPTR,A
                        LCALL   DELAY
                        DEC     R1
                        DJNZ    R2,MAIN6
                        ;
                        MOV     R2,#08H
                        MOV     R1,#07H
MAIN7:                  MOV     A,R1
                        MOV     DPTR,#LED
                        MOVC    A,@A+DPTR
                        MOV     DPTR,#0E102H ;out PB
                        MOVX    @DPTR,A
                        LCALL   DELAY
                        DEC     R1
                        DJNZ    R2,MAIN7
                        ;
                        MOV     R2,#08H
                        MOV     R1,#07H
MAIN8:                  MOV     A,R1
                        MOV     DPTR,#LED
                        MOVC    A,@A+DPTR
                        MOV     DPTR,#0E101H ;out PA
                        MOVX    @DPTR,A
                        LCALL   DELAY
                        DEC     R1
                        DJNZ    R2,MAIN8
                        ;
                        LJMP    MAINX
                        ;
LED:                    DB      00H,01H,03H,07H,0FH,1FH,3FH,7FH,0FFH
                        ;
DELAY:                  PUSH   DPH           ;delay led
                        PUSH   DPL
                        MOV    DPTR,#0E000H
DLY:                    INC    DPTR
                        MOV    A,DPH
                        ORL    A,DPL
                        JNZ    DLY
                        POP    DPL
                        POP    DPH
                        RET
                        ;
                        END





