;******************************
;* Program Test Relay & Input *
;* HardWare  : CP-2051  V2.0  *
;* Complier  : SXA51          *
;******************************

            RELAY1      EQU     P1.0    ; Port Relay1 Control
            RELAY2      EQU     P1.1    ; Port Relay2 Control
            RELAY3      EQU     P1.2    ; Port Relay3 Control
            RELAY4      EQU     P1.3    ; Port Relay4 Control
            INPUT1      EQU     P1.4    ; Port Input1
            INPUT2      EQU     P1.5    ; Port Input2
            INPUT3      EQU     P1.6    ; Port Input3
            INPUT4      EQU     P1.7    ; Port Input4
            ENABLE      EQU     P3.5    ; Input Enable (T1)
            ;
            OLD_BUFF    EQU     20H     ; Old Input Buffer
            NEW_BUFF    EQU     21H     ; New Input Buffer


            ORG     0000H
            ;
MAIN:       MOV     SP,#128-32      ; Initial Stack 32 Byte
TEST_RY:    MOV     P1,#0F0H            ; Test Output Relay
            SETB    RELAY1              ; On Relay1
            LCALL   DELAY
            CLR     RELAY1
            SETB    RELAY2              ; On Relay2
            LCALL   DELAY
            CLR     RELAY2
            SETB    RELAY3              ; On Relay3
            LCALL   DELAY
            CLR     RELAY3
            SETB    RELAY4              ; On Relay4
            LCALL   DELAY
            CLR     RELAY4
            MOV     P1,#0F0H
            ;
            MOV     OLD_BUFF,#0F0H
SCAN_INP:   MOV     R1,#OLD_BUFF            ; buffer old
            CLR     ENABLE                  ; Input Enable
            SETB    INPUT1
            SETB    INPUT2
            SETB    INPUT3
            SETB    INPUT4
            MOV     A,P1                    ; Check Input opto-Isolate
            ANL     A,#0F0H
            MOV     NEW_BUFF,A
            SETB    ENABLE                  ; Input Disable
            CJNE    A,OLD_BUFF,OUT_RELAY
            SJMP    SCAN_INP
            ;
OUT_RELAY:  MOV     OLD_BUFF,A
            SWAP    A
            CPL     A
            MOV     P1,A
            SJMP    SCAN_INP

;**************
;* Delay Time *
;**************
;
DELAY:      MOV     R5,#10
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            DJNZ    R5,DEL1
            RET

            END

