            ;****************************************
            ;*     EXAMPLE PROGRAM FOR  CP-2051     *
            ;* Large Serial Display By ETT CO.,LTD. *
            ;* Used IC 74HC595 (SERIAL TO PARALLEL) *
            ;****************************************

            SERIAL  EQU     P1.3    ; Serial Input pin
            SHIFT   EQU     P1.2    ; Shift Clock pin
            LATCH1  EQU     P1.1    ; Latch Clock pin SO0..7
            LATCH2  EQU     P1.0    ; Latch Clock pin SO8..15
            ORG     00H

MAIN:       SETB    SERIAL
            SETB    SHIFT
            SETB    LATCH1
            SETB    LATCH2
            MOV     A,#0            ; Clear data
            LCALL   SER_OUT
            CLR     LATCH1          ; Latch SO0..SO7
            CLR     LATCH2          ; Latch SO8..SO15
            SETB    LATCH1
            SETB    LATCH2
            ;
LOOP:       MOV     R0,#00H         ; Movlight data
            MOV     R3,#10          ; Counter loop1
LOOP1:      MOV     A,R0
            MOV     DPTR,#TAB_DSP
            MOVC    A,@A+DPTR
            LCALL   SER_OUT
            CLR     LATCH1          ; Latch SO0..SO7
            SETB    LATCH1
            LCALL   DELAY
            INC     R0
            DJNZ    R3,LOOP1
            ;
            MOV     R0,#00H         ; Movlight data
            MOV     R3,#10          ; Counter loop2
LOOP2:      MOV     A,R0
            MOV     DPTR,#TAB_DSP
            MOVC    A,@A+DPTR
            LCALL   SER_OUT
            CLR     LATCH2          ; Latch SO8..SO15
            SETB    LATCH2
            LCALL   DELAY
            INC     R0
            DJNZ    R3,LOOP2
            ;
            MOV     R0,#00H         ; Movlight data
            MOV     R3,#10          ; Counter loop3
LOOP3:      MOV     A,R0
            MOV     DPTR,#TAB_DSP
            MOVC    A,@A+DPTR
            LCALL   SER_OUT
            CLR     LATCH1          ; Latch SO0..SO7
            CLR     LATCH2          ; Latch SO8..SO15
            SETB    LATCH1
            SETB    LATCH2
            LCALL   DELAY
            INC     R0
            DJNZ    R3,LOOP3
            SJMP    LOOP


            ;************************
            ;*  Serial data output  *
            ;*  Input  = ACC        *
            ;*  Output = Serial pin *
            ;*  Reg.   = ACC,R2     *
            ;************************
            ;
SER_OUT:    MOV     R2,#8           ; Counter data out
            CLR     CY
SHF_OUT1:   RLC     A               ; Shift Out data LSB..MSB
            MOV     SERIAL,C
            CLR     SHIFT           ; Shift Clock
            SETB    SHIFT
            DJNZ    R2,SHF_OUT1
            RET

TAB_DSP:    DB      00H,01H,02H,04H,08H
            DB      10H,20H,40H,80H,00H

DELAY:      MOV     R6,#0FFH
DEL1:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL1
            RET

            END

