;*******************************
;   PROGRAM TEST  DV128064     *
;   WITH CHARACTER THAI,ENG    *
;   PROGRAM ASM C16            *
;           BOARD CP-z80v2     *
;   BY  ETT CO.,LTD. 25/4/92   *
;*******************************
;
         CPU  "Z80.TBL"
         HOF  "INT8"
         ORG  0000H

; ********** VARIABLE SET **********
;
;FOR KEY
ENTERKEY: EQU  13H       ; ENTER KEY
END:      EQU  0FFH      ; END CHARACTER
;
;FOR LCD
LCDCTRL1: EQU  60H
LCDCTRL2: EQU  61H
LCDDATA1: EQU  62H
LCDDATA2: EQU  63H
LCDREAD1: EQU  64H
LCDREAD2: EQU  65H
;
DISPON:   EQU  3FH
DISPOFF:  EQU  3EH
STARTLN0: EQU  0C0H
LINE1:    EQU  0B8H
LINE2:    EQU  0B9H
LINE3:    EQU  0BAH
LINE4:    EQU  0BBH
LINE5:    EQU  0BCH
LINE6:    EQU  0BDH
LINE7:    EQU  0BEH
LINE8:    EQU  0BFH
STARTCL0: EQU  40H
SYSCAL:   EQU  10H
;
; ********** POWER-UP **********
POWER:   LD    HL,800H         ; POWER-UP DELAY IF RUN START RUN 0000H
POWER1:  DEC   HL
         LD    A,0
POWER2:  DEC   A
         JR    NZ,POWER2
         LD    A,L
         OR    H
         JR    NZ,POWER1
;
        LD   SP,9F00H      ; SET SYSTEM STACK IF PROGRAM RUN 0000H
;
         LD   A,80H
         OUT  (43H),A
         LD   A,0FFH
         OUT  (40H),A
         LD   A,80H          ;GOTO MON

RUN:     CALL INITLCD        ;INIT GLCD SET DISPLAY ON
         CALL CLRSCR         ;CLS SCREEN GLCD PADG1,PAGE2
         CALL TITLE          ;DISPLAY PAGE1=ENG,PAGE2=THAI
;
         LD   A,80H
         OUT  (43H),A
         LD   A,0FFH
         OUT  (40H),A
         LD   A,80H          ;GOTO MON
         HALT
;         RST  SYSCAL
;
;
;******* DISPLAY ENG AND THAI *******
;
TITLE:LD   HL,BLANK   ;ENG
      CALL PAGE1
      LD   A,LINE1
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE2
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE3
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE4
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE5
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE6
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE7
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE8
      CALL GOTOLINE
      CALL DISP8
;
      LD   HL,KAI      ;THAI
      CALL PAGE2
      LD   A,LINE1
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE2
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE3
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE4
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE5
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE6
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE7
      CALL GOTOLINE
      CALL DISP8
      LD   A,LINE8
      CALL GOTOLINE
      CALL DISP8
      RET
;
DISP8:   LD   B,8
DISP8_1: LD   (STBMAP),HL
         CALL DISPLAY
         LD   DE,0008
         ADD  HL,DE
         DJNZ DISP8_1
         RET
;
;*********** GOTO LINE# COL 1 ************
;    SET LINE #
;    INPUT LINE REG (A)
;
GOTOLINE: PUSH AF
          LD   A,(CPORT)
          LD   C,A
          POP  AF
          OUT  (C),A
          CALL WBF
          LD   A,STARTCL0
          OUT  (C),A
          RET
;
;*********** SET PAGE USER 1 ******
;
PAGE1:   PUSH AF
         LD   A,LCDCTRL1
         LD   (CPORT),A
         LD   A,LCDDATA1
         LD   (DPORT),A
         LD   A,LCDREAD1
         LD   (RPORT),A
         POP  AF
         RET
;
;*********** SET PAGE USER 2 ******
;
PAGE2:   PUSH AF
         LD   A,LCDCTRL2
         LD   (CPORT),A
         LD   A,LCDDATA2
         LD   (DPORT),A
         LD   A,LCDREAD2
         LD   (RPORT),A
         POP  AF
         RET

; ******* CLEAR SCREEN **************
;   CLEAR SCREEN PAGE1,PAGE2
;
CLRSCR:  PUSH AF
         CALL PAGE1
         LD   A,STARTLN0
         CALL GOTOLINE
         CALL CLEAR
         CALL PAGE2
         LD   A,STARTLN0
         CALL GOTOLINE
         CALL CLEAR
         POP AF
         RET
;
; ******* CLEAR SCREEN************
; SUB PROGRAM CLRSCR
CLEAR:   PUSH DE
         PUSH BC
         PUSH AF
         LD E,LINE1
         LD D,08H
ANOTHER: LD A,(CPORT)
         LD C,A
         LD A,E
         CALL WBF
         OUT (C),A
         LD   B,48H
         LD   A,(DPORT)
         LD   C,A
LLC:     LD   A,00H
         OUT  (C),A
         CALL WBF
         DJNZ LLC
         INC  E
         DEC  D
         LD   A,00H
         CP   D
         JR   NZ,ANOTHER
         POP  AF
         POP  BC
         POP  DE
         RET
;
; *********** INIT  LCD ***********
;
INITLCD: CALL PAGE1
         LD   A,(CPORT)
         LD   C,A
         LD   A,DISPON
         OUT  (C),A
         CALL WBF
         LD   A,STARTLN0
         OUT  (C),A
         CALL WBF
         CALL PAGE2
         LD   A,(CPORT)
         LD   C,A
         LD   A,DISPON
         OUT  (C),A
         CALL WBF
         LD   A,STARTLN0
         OUT  (C),A
         CALL WBF
         RET
;
; *********** CHECK BUSY FLAG LCD *********
;
WBF:     PUSH AF
         PUSH BC
BUSY1:   LD   A,(RPORT)
         LD   C,A
         IN   A,(C)
         NOP
         BIT  7,A
         JR   NZ,BUSY1
         POP  BC
         POP  AF
         RET
;
;************* DISPLAY LCD ONE CHAR ***********
;   DISPLAY ONE CHAR = 8 BYTE
;   INPUT DATA  = (STBMAP)
;
DISPLAY: PUSH AF
         PUSH BC
         PUSH IX
         LD   IX,(STBMAP)
         LD   B,08H
         LD   A,(DPORT)
         LD   C,A
OUTDAT:  LD   A,(IX+0)
         OUT  (C),A
         CALL WBF
         INC  IX
         DJNZ OUTDAT
         POP  IX
         POP  BC
         POP  AF
         RET
;
;************ DATA CHARACTERS GER ************

BLANK:          DFB 00H,00H,00H,00H ;BLANK
                DFB 00H,00H,00H,00H
TOKJAI:         DFB 00H,00H,0EH,0BFH ;!
                DFB 0EH,00H,00H,00H
KUMPUD:         DFB 00H,00H,07H,00H  ; "
                DFB 07H,00H,00H,00H
NUMBER:         DFB 00H,24H,0FFH,24H ; #
                DFB 24H,0FFH,24H,00H
DOLLAR:         DFB 08H,54H,54H,0FEH ; $
                DFB 54H,54H,20H,00H
PERCENT:        DFB 86H,46H,20H,10H  ; %
                DFB 08H,0C4H,0C2H,00H
AMPER:          DFB 60H,94H,8EH,9AH  ; &
                DFB 6EH,44H,0B0H,80H
APOS:           DFB 00H,00H,00H,05H  ; '
                DFB 03H,00H,00H,00H
WOPEN:          DFB 00H,00H,3CH,42H  ; (
                DFB 81H,00H,00H,00H
WCLOSE:         DFB 00H,00H,00H,81H  ; )
                DFB 42H,3CH,00H,00H
STAR:           DFB 00H,08H,2AH,1CH ; *
                DFB 1CH,2AH,08H,00H
PLUS:           DFB 00H,08H,08H,3EH ; +
                DFB 3EH,08H,08H,00H
COMMA:          DFB 00H,00H,00H,0A0H ;,
                DFB 60H,00H,00H,00H
MINUS:          DFB 00H,08H,08H,08H ; -
                DFB 08H,08H,08H,00H
STOP:           DFB 00H,00H,00H,0C0H ;.
                DFB 0C0H,00H,00H,00H
SLASH:          DFB 00H,0C0H,30H,18H ;/
                DFB 0CH,03H,00H,00H,
ZERO:           DFB 00H,7CH,0A2H,0B2H; 0
                DFB 9AH,8AH,7CH,00H
ONE:            DFB 00H,00H,82H,0FFH ; 1
                DFB 80H,00H,00H,00H
TWO:            DFB 00H,86H,0C1H,0A1H ; 2
                DFB 91H,89H,86H,00H
THREE:          DFB 00H,42H,81H,89H   ; 3
                DFB 89H,89H,76H,00H
FOUR:           DFB 60H,50H,48H,44H   ;4
                DFB 42H,0FFH,40H,00H
FIVE:           DFB 5FH,85H,85H,85H   ; 5
                DFB 85H,49H,30H,00H
SIX:            DFB 00H,7CH,92H,89H   ; 6
                DFB 89H,89H,70H,00H
SEVEN:          DFB 00H,03H,01H,0C1H  ;7
                DFB 31H,0DH,03H,00H
EIGHT:          DFB 00H,76H,89H,89H  ;8
                DFB 89H,89H,76H,00H
NINE:           DFB 00H,0EH,91H,91H ;9
                DFB 91H,49H,3EH,00H
COLON:          DFB 00H,00H,00H,66H ; :
                DFB 66H,00H,00H,00H
SEMI:           DFB 00H,00H,80H,76H ; ;
                DFB 36H,00H,00H,00H
LESS:           DFB 00H,00H,18H,24H ; <
                DFB 42H,81H,00H,00H
EQUAL:          DFB 00H,24H,24H,24H ; =
                DFB 24H,24H,00H,00H
MORE:           DFB 00H,00H,81H,42H ; >
                DFB 24H,18H,00H,00H
QUES:           DFB 00H,06H,09H,0DH ; ?
                DFB 0B5H,09H,06H,00H
ATAB:           DFB 0F8H,14H,12H,11H ; A
                DFB 12H,14H,0F8H,00H
BTAB:           DFB 81H,0FFH,89H,89H ; B
                DFB 89H,89H,76H,00H
CTAB:           DFB 00H,3CH,42H,81H  ; C
                DFB 81H,81H,42H,00H
DTAB:           DFB 81H,0FFH,81H,81H ; D
                DFB 81H,42H,3CH,00H
ETAB:           DFB 81H,0FFH,89H,89H ; E
                DFB 9DH,81H,0E3H,00H
FTAB:           DFB 81H,0FFH,89H,09H ; F
                DFB 1DH,01H,03H,00H
GTAB:           DFB 00H,7EH,81H,81H  ; G
                DFB 91H,51H,0F6H,00H
HTAB:           DFB 00H,0FFH,08H,08H ; H
                DFB 08H,08H,0FFH,00H
ITAB:           DFB 00H,00H,81H,0FFH ; I
                DFB 81H,00H,00H,00H
JTAB:           DFB 00H,40H,80H,80H  ; J
                DFB 81H,7FH,01H,00H
KTAB:           DFB 81H,0FFH,89H,14H ; K
                DFB 22H,0C1H,81H,80H
LTAB:           DFB 00H,81H,0FFH,81H ; L
                DFB 80H,80H,0C0H,00H
MTAB:           DFB 0FFH,02H,04H,18H ; M
                DFB 04H,02H,0FFH,00H
NTAB:           DFB 81H,0FFH,83H,0CH ; N
                DFB 18H,61H,0FFH,01H
OTAB:           DFB 00H, 7EH,81H,81H ; O
                DFB 81H,81H,7EH,00H
PTAB:           DFB 00H,81H,0FEH,91H ; P
                DFB 11H,11H,0EH,00H
QTAB:           DFB 00H,7EH,81H,91H  ; Q
                DFB 0A1H,0C1H,7FH,80H
RTAB:           DFB 81H,0FFH,89H,19H ; R
                DFB 29H,0C9H,86H,80H
STAB:           DFB 00H,0E6H,49H,89H ; S
                DFB 91H,92H,67H,00H
TTAB:           DFB 03H,01H,81H,0FFH ; T
                DFB 81H,01H,03H,00H
UTAB:           DFB 01H,7FH,81H,80H ; U
                DFB 80H,81H,7FH,01H
VTAB:           DFB 07H,18H,60H,80H ; V
                DFB 60H,18H,0FH,00H
WTAB:           DFB 3FH,0C0H,20H,10H ; W
                DFB 20H,0C0H,3FH,00H
XTAB:           DFB 0C3H,27H,18H,18H ; X
                DFB 18H,27H,0C3H,00H
YTAB:           DFB 01H,03H,84H,0F8H ; Y
                DFB 84H,03H,01H,00H
ZTAB:           DFB 0C3H,0A1H,91H,89H ; Z
                DFB 85H,83H,0C1H,00H
;
;         CHARACTERS THAI
;
KAI:            DFB 00H,0FAH,05H,01H
                DFB 01H,01H,0FEH,00H
KHAI:           DFB 00H,02H,05H,0FEH
                DFB 80H,7FH,00H,00H
BUFFALO:        DFB 0FEH,21H,11H,29H
                DFB 11H,01H,0FEH,00H
RAKANG:         DFB 62H,95H,0F2H,29H
                DFB 46H,80H,0FFH,00H
NGU:            DFB 00H,10H,20H,42H
                DFB 85H,0FEH,00H,00H
JAN:            DFB 02H,01H,09H,15H
                DFB 79H,81H,0FEH,00H
CHING:          DFB 12H,0E9H,0B1H,41H
                DFB 21H,0FEH,0A0H,40H
CHANG:          DFB 04H,0F2H,8AH,86H
                DFB 84H,0FAH,01H,01H
SOO:            DFB 02H,05H,02H,0FDH
                DFB 82H,7DH,00H,00H
CHER:           DFB 7AH,0A5H,41H,41H
                DFB 0A1H,7EH,40H,0FFH

YING:           DFB 7AH,0A5H,41H,01H
                DFB 0FEH,80H,80H,0FFH

YINGLOW:        DFB 00H,00H,00H,00H
                DFB 06H,06H,04H,02H

CHADA:          DFB 42H,0A5H,79H,01H
                DFB 01H,01H,0FEH,80H

CHADALOW:       DFB 00H,00H,02H,05H
                DFB 02H,05H,07H,00H

PATAK:          DFB 42H,0A5H,79H,01H
                DFB 81H,01H,0FEH,00H

PATAKLOW:       DFB 02H,05H,02H,05H
                DFB 02H,04H,07H,00H

TORTAN:         DFB 00H,02H,15H,2DH
                DFB 0F5H,85H,7AH,01H

TORTANLOW:      DFB 10H,28H,10H,28H
                DFB 14H,2AH,1EH,00H

MONTO:          DFB 02H,0E5H,12H,09H
                DFB 06H,02H,0FFH,00H

TORTHOA:        DFB 0FEH,11H,2AH,52H
                DFB 0A2H,7EH,40H,0BFH

NANE:           DFB 7AH,0A5H,41H,0FEH
                DFB 40H,0FFH,0A0H,40H

DEK:            DFB 0FEH,81H,49H,35H
                DFB 19H,01H,0FEH,00H

TORTOA:         DFB 0FEH,81H,49H,36H
                DFB 19H,01H,0FEH,00H

TUNG:           DFB 7AH,0A5H,41H,01H
                DFB 01H,01H,0FEH,00H

TAHAN:          DFB 02H,0F5H,0EH,04H
                DFB 02H,01H,0FEH,00H

TONG:           DFB 00H,02H,05H,0FDH
                DFB 85H,85H,0FAH,01H

HNOO:           DFB 02H,0F5H,8EH,40H
                DFB 20H,0FFH,0A0H,40H

BAIMAI:         DFB 02H,85H,0FEH,80H
                DFB 80H,80H,0FFH,00H

PLARHIGH:       DFB 00H,00H,00H,00H
                DFB 00H,00H,0F0H,00H

PLAR:           DFB 02H,05H,0FEH,80H
                DFB 80H,80H,0FFH,00H

PUNG:           DFB 00H,7EH,85H,42H
                DFB 40H,80H,7EH,00H

PHAHIGH:        DFB 00H,00H,00H,00H
                DFB 00H,00H,0F0H,00H

PHA:            DFB 00H,7EH,85H,42H
                DFB 40H,80H,7FH,00H

PAN:            DFB 02H,05H,0FEH,40H
                DFB 30H,40H,0FFH,00H

FUNHIGH:        DFB 00H,00H,00H,00H
                DFB 00H,00H,0F0H,00H

FUN:            DFB 02H,05H,0FEH,40H
                DFB 30H,40H,0FFH,00H

POA:            DFB 42H,0A5H,79H,01H
                DFB 01H,01H,0FEH,00H

MAR:            DFB 42H,0A5H,0FEH,20H
                DFB 20H,40H,0FFH,00H

YAK:            DFB 00H,6EH,95H,92H
                DFB 80H,80H,0FFH,00H

SHIP:           DFB 00H,02H,05H,05H
                DFB 45H,0A5H,7AH,01H

LU:             DFB 00H,7AH,0A5H,41H
                DFB 01H,01H,0FEH,00H

LULOW:          DFB 00H,00H,00H,00H
                DFB 00H,00H,0FH,00H

LING:           DFB 02H,71H,0A9H,45H
                DFB 09H,11H,0FEH,00H

WAN:            DFB 00H,02H,01H,01H
                DFB 41H,0A1H,7EH,00H

SALAHIGH:       DFB 00H,00H,00H,00H
                DFB 00H,80H,50H,20H

SALA:           DFB 7EH,81H,79H,15H
                DFB 09H,01H,0FEH,00H

RUSI:           DFB 02H,85H,0FEH,80H
                DFB 98H,90H,0FFH,10H

TIGERHIGH:      DFB 00H,00H,00H,00H
                DFB 00H,80H,50H,20H

TIGER:          DFB 02H,71H,0A9H,45H
                DFB 09H,11H,0FEH,00H

HEEP:           DFB 02H,0FDH,26H,10H
                DFB 0AH,0DH,0FAH,00H

JURAHIGH:       DFB 00H,00H,00H,00H
                DFB 40H,0A0H,0C0H,20H

JURA:           DFB 02H,0F5H,4EH,20H
                DFB 20H,40H,0FFH,00H

ANG:            DFB 00H,72H,0A9H,91H
                DFB 81H,81H,7EH,00H

HOOKHIGH:       DFB 00H,00H,00H,00H
                DFB 00H,00H,0A0H,40H

HOOK:           DFB 00H,72H,0ADH,95H
                DFB 83H,81H,7EH,00H

SARAA:          DFB 00H,66H,55H,0AAH
                DFB 88H,44H,22H,00H

TOAKUB:         DFB 00H,14H,14H,14H
                DFB 14H,14H,00H,00H

SARAAR:         DFB 00H,02H,01H,01H
                DFB 01H,01H,0FEH,00H

SARAUMHIGH:     DFB 20H,50H,50H,20H
                DFB 00H,00H,00H,00H

SARAUM:         DFB 00H,02H,01H,01H
                DFB 01H,01H,0FEH,00H

SARAAA:         DFB 00H,7FH,0A0H,40H
                DFB 00H,00H,00H,00H

SARAAIR:        DFB 00H,7FH,0A0H,40H
                DFB 7FH,0A0H,40H,00H

SARAOHIGH:      DFB 10H,28H,0E8H,08H
                DFB 08H,08H,00H,00H

SARAO:          DFB 00H,00H,0FFH,0C0H
                DFB 00H,00H,00H,00H

MAIMOONHIGH:    DFB 38H,34H,04H,0FCH
                DFB 00H,00H,00H,00H

MAIMOON:        DFB 00H,00H,00H,0FFH
                DFB 0C0H,00H,00H,00H

MALAIHIGH:      DFB 08H,10H,20H,10H
                DFB 0F8H,00H,00H,00H

MALAI:          DFB 00H,00H,00H,00H
                DFB 0FFH,0C0H,00H,00H

YAMOK:          DFB 00H,0F0H,0D0H,20H
                DFB 10H,10H,0F0H,00H

YAMOKLOW:       DFB 00H,00H,18H,04H
                DFB 02H,02H,01H,00H

PAIYAN:         DFB 08H,14H,10H,10H
                DFB 08H,04H,0FEH,00H

SARAU:          DFB 00H,00H,00H,00H
                DFB 04H,0AH,3CH,00H

SARAUU:         DFB 00H,00H,00H,04H
                DFB 0AH,3CH,20H,3EH

SARAI:          DFB 00H,30H,48H,48H
                DFB 48H,50H,60H,00H

SARAE:          DFB 30H,28H,28H,28H
                DFB 38H,3CH,00H,00H

SARAAU:         DFB 00H,03H,48H,48H
                DFB 48H,50H,68H,30H

SARAAUE:        DFB 00H,30H,48H,48H
                DFB 50H,58H,60H,78H

HUN:            DFB 00H,30H,68H,50H
                DFB 40H,40H,20H,10H
NAMFON:         DFB 00H,18H,24H,24H
                DFB 14H,08H,00H,00H
TAIKU:          DFB 70H,48H,28H,28H
                DFB 48H,68H,64H,00H
MAIAKE:         DFB 00H,00H,00H,00H
                DFB 00H,70H,00H,00H
MAITO:          DFB 00H,40H,68H,58H
                DFB 40H,40H,20H,10H
MAITEE:         DFB 78H,48H,10H,18H
                DFB 08H,78H,20H,1EH
JATAWA:         DFB 00H,00H,10H,10H
                DFB 7CH,10H,10H,00H
KARAN:          DFB 00H,70H,50H,10H
                DFB 10H,0CH,00H,00H
AKEUM:          DFB 00H,30H,48H,48H
                DFB 48H,30H,06H,00H
TOUM:           DFB 02H,36H,4CH,4CH
                DFB 4AH,31H,00H,00H
TEEUM:          DFB 06H,35H,4AH,49H
                DFB 4EH,34H,02H,01H
TAWAUM:         DFB 00H,30H,48H,4AH
                DFB 4AH,37H,02H,02H
AKEHAN:         DFB 70H,50H,70H,40H
                DFB 40H,4CH,20H,10H
TOHAN:          DFB 70H,52H,76H,44H
                DFB 44H,44H,22H,11H
TEEHAN:         DFB 70H,57H,75H,42H
                DFB 41H,47H,24H,17H
TAWAHAN:        DFB 70H,50H,74H,44H
                DFB 4EH,44H,20H,10H
AKEI:           DFB 00H,60H,50H,50H
                DFB 50H,50H,66H,00H
TOI:            DFB 00H,60H,52H,56H
                DFB 54H,54H,62H,01H
TEEI:           DFB 00H,6EH,5AH,54H
                DFB 52H,5EH,68H,07H
TAWAI:          DFB 00H,60H,50H,52H
                DFB 52H,57H,62H,02H
KARANI:         DFB 00H,60H,50H,50H
                DFB 50H,5CH,6AH,01H
AKEE:           DFB 60H,50H,50H,50H
                DFB 50H,50H,7BH,00H
TOE:            DFB 60H,52H,56H,54H
                DFB 54H,52H,79H,00H
TEEE:           DFB 6EH,5AH,54H,52H
                DFB 5EH,54H,7AH,01H
TAWAE:          DFB 60H,50H,52H,52H
                DFB 57H,52H,7AH,00H
;
;******** RAM AREA ***********
          ORG   8000H

CPORT:    DFS  1H
DPORT:    DFS  1H
RPORT:    DFS  1H
STBMAP:   DFS  2H
;
          END
