;
;***********************
;DEMO SOFT-WARE Z80180 *
;***********************
;
; ROM monitor program 00000-07FFFH
; RAM for use 18000,1EFFFH
; RAM stack for user&system 1F000-1FFFFH

; example flash LED at 8255 port 0C082H
; and  receive  the key board OF (serial port IBM PC)
; to Z80180 ASCI chanel 1 interrupt and send charecter
; from keyboard to display (ehco).

; timer reload chanel 0 interrup every 100 us for flash LED

;         main program is sleep mode
;

            .ORG 0
;
;*** REGTER I/O Z80180 ***
;
            .EQU TDR1,7      ;ASCI CHANEL1 TX
            .EQU RDR1,9      ;RX
            .EQU STAT1,5     ;STATUS
            .EQU CNTLA1,1    ;DATA FORMAT
            .EQU CNTLB1,3    ;BAUD RATE
;
            .EQU TMDR0L,0CH  ;TIMER0 BYTE LOW
            .EQU TMDR0H,0DH  ;TIMER0 BYTE HIGH
            .EQU RLDR0L,0EH  ;RELOAD BYTE LOW
            .EQU RLDR0H,0FH  ;RELOAD BYTE HIGH
            .EQU TCR,10H     ;TIMER CONTROL
;
            .EQU IL,33H      ;VECTOR LOW
            .EQU OMCR,3EH    ;OPERATION CONTROL
;
            .EQU CBAR,3AH    ;SET LOGICAL
            .EQU BBR,39H     ;BANK BASE
            .EQU CBR,38H     ;COMMON AREA 1
;
            .EQU STACK,0FF00H
            .EQU VECLOW,80H  ;VECTOR LOW
            .EQU LF,0AH      ;LINE FEED
            .EQU CR,0DH      ;CARRIER
            .EQU BEL,7       ;BELL
            .EQU TIMEL,0     ;TIMER 100 MS
            .EQU TIMEH,78H   ;
            .EQU PCTRL,0C083H  ;PORT CONTROL 8255
            .EQU PDATA,0C082H  ;PORT C OF 8255
;
;***********************
;     POWER UP DELAY   *
;***********************
;
START:      XOR  A           ;POWER UP
START1:     NOP
            DEC  A
            JR   NZ,START1
            JP   INIT
;
            .ORG VECLOW
;
;*** PRIORITY INTERRUPT ***
;
INT1:       .DRW EMPTY       ;EMPTY FOR NOT USE IN PROGRAM
INT2:       .DRW EMPTY
PRT0:       .DRW PRTINT      ;TIMER INT CHANEL0
PRT1:       .DRW EMPTY
DMA0:       .DRW EMPTY
DMA1:       .DRW EMPTY
CSIO:       .DRW EMPTY
ASCI0:      .DRW EMPTY
ASCI1:      .DRW TRXMIT      ;ASCI CHANEL 1 INT
;
EMPTY:      SLP              ;DUMY
;
;***********************
;   INITIAL PARAMETER  *
;***********************
;
INIT:       LD   A,0         ;for Z80180
            OUT0 (OMCR),A
            LD   A,0F8H      ;logical address
            OUT0 (CBAR),A
            LD   A,10H
            OUT0 (BBR),A     ;psysical bank 18000H
            OUT0 (CBR),A     ;psyical common area1 1F000H
;
            LD   SP,STACK    ;load stack for call program
            LD   A,VECLOW    ;set low vector
            OUT0 (IL),A
            CALL ASCSET      ;set serial port 1
            CALL SETPRT      ;set timer chanel 0
            LD   HL,TABLE
            CALL PRINT       ;display title
;
            LD   BC,PCTRL    ;set 8255 A,B,C (output)
            LD   A,80H
            OUT  (C),A
            LD   L,0         ;data LED flash
            EI              ;enabel INT
;
;***********************
;      MAIN PROGRAM    *
;***********************
;
MAIN:       SLP             ;sleep
            JR   MAIN
;
;*** PRINT TO CONSOLE ***
;
PRINT:      LD   A,(HL)      ;load charecter
PRINT0:     CALL CONOUT      ;send to display
            INC  HL
            LD   A,(HL)
            CP   0
            JR   NZ,PRINT0   ;end data ?
            RET              ;yes
;
;*** SEND 1 CHARECTER TO CONSOLE ***
;
CONOUT:     IN0  E,(STAT1)   ;check flag send
            BIT  1,E
            JR   Z,CONOUT    ;flag TDRE ASCI1 =1 ?
            OUT0 (TDR1),A    ;yes, send to display
            RET
;
;*** SET ASCI CHANEL1 TX,RX,8,N,1,9600 AT X'TAL 12.488 ***
;
ASCSET:     LD   A,64H
            OUT0 (CNTLA1),A  ;TX,RX,8BIT,1 STOP
            LD   A,2         ;9600 BAUD AT X'TAL 12.488
            OUT0 (CNTLB1),A
            LD   A,8         ;RIE enable to keyboard
            OUT0 (STAT1),A
            RET
;
; *** SET TIMER COUNTER CHANEL 0 ***
;
SETPRT:     LD   A,TIMEL
            OUT0 (TMDR0L),A  ;TIMER byte low
            OUT0 (RLDR0L),A  ;RELOAD byte low
            LD   A,TIMEH
            OUT0 (TMDR0H),A  ;TIMER byte high
            OUT0 (RLDR0H),A  ;RELOAD byte high
            LD   A,11H
            OUT0 (TCR),A     ;enable timer flag INT&start counter
            RET
;
;*** ASCI INTERRUPT EHCO TO CONSOLE ***
;
TRXMIT:     DI               ;disable interrupt
            PUSH AF
            IN0  A,(RDR1)    ;clear RDRF & read keyboard
            CALL CONOUT      ;EHCO
            CP   CR          ;check enter
            LD   A,LF        ;line feed
            CALL Z,CONOUT    ;y,out line feed
            LD   A,BEL       ;bell
            CALL CONOUT
            POP  AF
            EI               ;enable
            RETI
;
;*** TIMER CHANEL1 INTERRUPT 100 ms ***
;
PRTINT:     DI
            PUSH AF          ;save reg
            PUSH BC
;
PRTINT1:    IN0  A,(TCR)     ;TIF flag enable ?
            BIT  6,A
            JR   Z,PRTINT1
            IN0  A,(TMDR0L)  ;yes,clear TIF0
;
            LD   BC,PDATA
            OUT  (C),L       ;OUT DATA
            LD   A,L
            CPL              ;toggle data flash LED
            LD   L,A
;
            POP  BC          ;restroe reg
            POP  AF
            EI
            RETI
;
TABLE:      .DB  "DEMO CONTROL Z80180",CR,LF,0
            .END