;/***********************************/;
;/* Demo Software For Mini ET-REM8  */;
;/* Files Name  : DSP8EX3.ASM       */;
;/* Board & CPU : AT89C2051         */;
;/*  (Mini Remote Display 8-Digit)  */;
;/* Assembler   : SXA51             */;
;/* Function    : Scankey & Display */;
;/***********************************/;
;
;/* Port For Control MAX7219 */;
MAX_DATA    EQU     P1.4                    ; Data Input
MAX_CLOCK   EQU     P1.5                    ; Clock Input
MAX_LOAD    EQU     P1.6                    ; Load Input

            ORG     20H                     ; Internal RAM of CPU
FLAG_BUF:   DS      1
ROW:        DS      1
COLUM:      DS      1
DSP_BUFF:   DS      8
STACK:      DS      32                      ; Stack Area
;
KEY_PRES    EQU     FLAG_BUF.0
KEY_STAS    EQU     FLAG_BUF.1
            
            ORG     0000H                   ; Reset Vector of CPU
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     P1,#0FFH
            MOV     FLAG_BUF,#00H           ; Clear All Flag
            LCALL   INIT_MAX                ; Initial MAX7219
            ;
CLR_BUFF:   MOV     R2,#8
            MOV     R0,#DSP_BUFF
            MOV     A,#11H                  ; Blank
CLR_BUF1:   MOV     @R0,A                   ; Clear Display Buffer
            INC     R0
            DJNZ    R2,CLR_BUF1
            MOV     DSP_BUFF+0,#10H         ; "-"
            LCALL   DISPLAY                 ; Display Data to 7-Segment
            ;
LOOP:       LCALL   SCANKEY                 ; Scan Keyboard
            CJNE    A,#0FFH,DSP_KEY
            SJMP    LOOP
            ;
DSP_KEY:    LCALL   SHF_BUFF
            LCALL   DISPLAY                 ; Display Data to 7-Segment
            SJMP    LOOP

;/*********************/;
;/* Shift Left Buffer */;
;/*   DSP_BUFF+0..7   */;
;/* MSB <- LSB <- ACC */;
;/*********************/;
;
SHF_BUFF:   PUSH    ACC
            MOV     R0,#DSP_BUFF+0
            MOV     R1,#DSP_BUFF+1
            MOV     R2,#7
SHF_BUF1:   MOV     A,@R1
            MOV     @R0,A
            INC     R0
            INC     R1
            DJNZ    R2,SHF_BUF1
            POP     ACC
            MOV     @R0,A
            RET

;/********************/;
;/* Initial MAX7219  */;
;/********************/;
;
INIT_MAX:   MOV     DPTR,#0A0FH             ; Intensity (Max)
            LCALL   SHF_MAX
            MOV     DPTR,#0B07H             ; Scan Limit (8digit)
            LCALL   SHF_MAX
            MOV     DPTR,#0900H             ; Set Mode (No Decode BCD)
            LCALL   SHF_MAX
            MOV     DPTR,#0C01H             ; Not Shutdown (Normal Opr.)
            LCALL   SHF_MAX
            MOV     DPTR,#0F00H             ; Not Display test (Normal Opr.)
            LCALL   SHF_MAX
            RET

;/*************************/;
;/* Shift Data to MAX7219 */;
;/* Input : DPH = Address */;
;/*       : DPL = Data    */;
;/* Reg.  : DPTR,R2,ACC   */;
;/*************************/;
;
SHF_MAX:    MOV     R2,#8                   ; Counter Address out
            MOV     A,DPH
            CLR     CY
            CLR     MAX_CLOCK
            CLR     MAX_LOAD
SHF_MAX1:   RLC     A                       ; Shift Out D15..D8
            MOV     MAX_DATA,C
            SETB    MAX_CLOCK               ; Shift clock
            CLR     MAX_CLOCK
            DJNZ    R2,SHF_MAX1
            MOV     R2,#8                   ; Counter data out
            MOV     A,DPL
            CLR     CY
SHF_MAX2:   RLC     A                       ; Shift Out D7..D0
            MOV     MAX_DATA,C
            SETB    MAX_CLOCK               ; Shift Clock
            CLR     MAX_CLOCK
            DJNZ    R2,SHF_MAX2
            SETB    MAX_LOAD                ; Latch Data
            CLR     MAX_LOAD
            RET

;/*************************/;
;/* Table of Display Code */;
;/*    Dp A B C D E F G   */;
;/*    D7 ...........D0   */;
;/*************************/;
;
TAB_SEG:    DB      7EH,30H,6DH,79H         ; 0 1 2 3
            DB      33H,5BH,5FH,70H         ; 4 5 6 7
            DB      7FH,7BH,77H,1FH         ; 8 9 A B
            DB      4EH,3DH,4FH,47H         ; C D E F
            DB      01H,00H                 ; - Blank

;/*****************************/;
;/* Display 7-Segment 8-Digit */;
;/* Input : DSP_BUFF (8-Byte) */;
;/*****************************/;
;
DISPLAY:    MOV     R7,#8
            MOV     R1,#08H                 ; Digit 1
            MOV     R0,#DSP_BUFF            ; Buffer digit1
DSP1:       MOV     A,@R0
            ANL     A,#01111111B            ; Ignore Dp
            MOV     DPTR,#TAB_SEG
            MOVC    A,@A+DPTR
            MOV     DPH,R1                  ; Address
            MOV     DPL,A                   ; Data
            MOV     A,@R0
            ANL     A,#10000000B            ; Check Dp
            ORL     A,DPL
            MOV     DPL,A
            LCALL   SHF_MAX
            INC     R0                      ; Next Buffer
            DEC     R1                      ; Next Digit
            DJNZ    R7,DSP1
            RET

;/********************************/;
;/*  Scan Keyboard Matrix  (4x4) */;
;/*  Output    : ACC (code 0..F) */;
;/*            : FFH (Not press) */;
;/*  Register  : ACC,B,R2,DPTR   */;
;/*  Sub. Call : KEY_DLY         */;
;/*            : KEY_NEW         */;
;/********************************/;
;
SCANKEY:    MOV     ROW,#4              ; Counter for Scan 4x4
            MOV     COLUM,#11111110B    ; Data for Scan Colum
SCAN1:      ORL     P1,#0FH             ; Set P1.0-P1.3
            MOV     A,COLUM             ; Port Scan Key
            RL      A                   ; Shift Left 2bit
            RL      A
            ANL     A,#00111100B
            ANL     P3,#11000011B
            ORL     P3,A                ; Scan Colum (P3.2-P3.5)
            MOV     A,P1
            ANL     A,#0FH              ; Check Row Only
            CJNE    A,#0FH,PRESS        ; Check row only (P1.0-P1.3)
            MOV     A,COLUM             ; Scan Next Colum
            RL      A
            MOV     COLUM,A
            DJNZ    ROW,SCAN1
            MOV     A,#0FFH             ; Not Keypress
            CLR     KEY_PRES            ; not key Press
            SJMP    END_SCAN
            ;
PRESS:      LCALL   KEY_DLY             ; Debounce key
            ORL     P1,#0FH             ; Set P1.0-P1.3
            MOV     A,COLUM             ; Port Scan Key
            RL      A                   ; Shift Left 2bit
            RL      A
            ANL     A,#00111100B
            ANL     P3,#11000011B
            ORL     P3,A                ; Scan Colum (P3.2-P3.5)
            MOV     A,P1
            ANL     A,#0FH              ; Check Row Only
            CJNE    A,#0FH,KEY_CODE     ; Check row only (P1.0-P1.3)
            SJMP    SCANKEY             ; No keybounce or noise
            ;
KEY_CODE:   LCALL   KEY_NEW
            JNB     KEY_STAS,SCAN1      ; if old key don't care
            SWAP    A
            MOV     B,A                 ; Row code (High)
            MOV     A,COLUM
            ANL     A,#0FH              ; Colum (Low Byte)
            ORL     A,B                 ; Mix Row & Colum
            MOV     B,A                 ; Row & Colum code
            ;
            MOV     DPTR,#KEY_TAB
            MOV     R2,#0FFH
CODE1:      INC     R2
            MOV     A,R2
            MOVC    A,@A+DPTR
            CJNE    A,B,CODE1
            MOV     A,R2                ; Number code 0..F
END_SCAN:   RET

;/**********************************/;
;/*     Check Old & New key        */;
;/*  KEY_STAS = 0 is old press Key */;
;/*  KEY_STAS = 1 is 1st press Key */;
;/**********************************/;
;
KEY_NEW:    CLR     KEY_STAS            ; Next time = old key
            JB      KEY_PRES,END_NEW    ; Jump if old key press
            SETB    KEY_PRES            ; Next time = old press
            SETB    KEY_STAS            ; Next time = old key
END_NEW:    RET

;/****************/;
;/*   Delay For  */;
;/* Debounce key */;
;/****************/;
;
KEY_DLY:    MOV     R6,#01FH
KEY_DL1:    MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,KEY_DL1
            RET

;/*********************/;
;/* Table of Key Code */;
;/* Col = P 3.2-3-4-5 */;
;/*       X7 XB XD XE */;
;/* Row = P 1.0-1-2-3 */;
;/*       7X BX DX EX */;
;/*********************/;
;
KEY_TAB:    DB      077H,07BH,07DH,07EH     ; Row0
            DB      0B7H,0BBH,0BDH,0BEH     ; Row1
            DB      0D7H,0DBH,0DDH,0DEH     ; Row2
            DB      0E7H,0EBH,0EDH,0EEH     ; Row3

            END




