;/***********************************/;
;/* Demo Software For Mini ET-REM8  */;
;/* Files Name  : DSP8EX2.ASM       */;
;/* Board & CPU : AT89C2051         */;
;/*  (Mini Remote Display 8-Digit)  */;
;/* Assembler   : SXA51             */;
;/* Function    : Display RS232 Code*/;
;/***********************************/;
;
;/* Port For Control MAX7219 */;
MAX_DATA    EQU     P1.4                    ; Data Input
MAX_CLOCK   EQU     P1.5                    ; Clock Input
MAX_LOAD    EQU     P1.6                    ; Load Input

            ORG     20H                     ; Internal RAM of CPU
DSP_BUFF:   DS      8
STACK:      DS      32                      ; Stack Area
            
            ORG     0000H                   ; Reset Vector of CPU
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     P1,#0FFH
            LCALL   INIT_MAX                ; Initial MAX7219
            ;
INIT_SER:   MOV     A,#0FDH                 ; Set baud rate 9600
            MOV     TH1,A
            MOV     TL1,A
            MOV     TMOD,#00100001B         ; Timer1 Mode2 & Timer0 Mode1
            MOV     SCON,#01010000B         ; Serial mode 1
            CLR     ES                      ; Disable serial interupt
            CLR     ET1                     ; Disable timer1 interupt
            SETB    TR1                     ; Set timer1 control
            CLR     EA                      ; Disable Global Interupt
            ;
CLR_BUFF:   MOV     R2,#8
            MOV     R0,#DSP_BUFF
            MOV     A,#0BH                  ; Blank
CLR_BUF1:   MOV     @R0,A                   ; Clear Display Buffer
            INC     R0
            DJNZ    R2,CLR_BUF1
            MOV     DSP_BUFF+0,#0AH         ; "-"
            LCALL   DISPLAY                 ; Display Data to 7-Segment
            ;
GET_BYTE:   JNB     RI,$                    ; Wait Data From Com Port
            MOV     A,SBUF                  ; Get Data From Com Port
            CLR     RI
            CJNE    A,#30H,CHK_NUM1
CHK_NUM1:   JC      GET_BYTE                ; Not Number Ignore
            CJNE    A,#40H,CHK_NUM2
CHK_NUM2:   JNC     GET_BYTE                ; Not Number Ignore
            ANL     A,#0FH                  ; Convert 0-9 to Display
            LCALL   SHF_BUFF
            LCALL   DISPLAY                 ; Display Data to 7-Segment
            SJMP    GET_BYTE

;/*********************/;
;/* Shift Left Buffer */;
;/*   DSP_BUFF+0..7   */;
;/* MSB <- LSB <- ACC */;
;/*********************/;
;
SHF_BUFF:   PUSH    ACC
            MOV     R0,#DSP_BUFF+0
            MOV     R1,#DSP_BUFF+1
            MOV     R2,#7
SHF_BUF1:   MOV     A,@R1
            MOV     @R0,A
            INC     R0
            INC     R1
            DJNZ    R2,SHF_BUF1
            POP     ACC
            MOV     @R0,A
            RET

;/********************/;
;/* Initial MAX7219  */;
;/********************/;
;
INIT_MAX:   MOV     DPTR,#0A0FH             ; Intensity (Max)
            LCALL   SHF_MAX
            MOV     DPTR,#0B07H             ; Scan Limit (8digit)
            LCALL   SHF_MAX
            MOV     DPTR,#0900H             ; Set Mode (No Decode BCD)
            LCALL   SHF_MAX
            MOV     DPTR,#0C01H             ; Not Shutdown (Normal Opr.)
            LCALL   SHF_MAX
            MOV     DPTR,#0F00H             ; Not Display test (Normal Opr.)
            LCALL   SHF_MAX
            RET

;/*************************/;
;/* Shift Data to MAX7219 */;
;/* Input : DPH = Address */;
;/*       : DPL = Data    */;
;/* Reg.  : DPTR,R2,ACC   */;
;/*************************/;
;
SHF_MAX:    MOV     R2,#8                   ; Counter Address out
            MOV     A,DPH
            CLR     CY
            CLR     MAX_CLOCK
            CLR     MAX_LOAD
SHF_MAX1:   RLC     A                       ; Shift Out D15..D8
            MOV     MAX_DATA,C
            SETB    MAX_CLOCK               ; Shift clock
            CLR     MAX_CLOCK
            DJNZ    R2,SHF_MAX1
            MOV     R2,#8                   ; Counter data out
            MOV     A,DPL
            CLR     CY
SHF_MAX2:   RLC     A                       ; Shift Out D7..D0
            MOV     MAX_DATA,C
            SETB    MAX_CLOCK               ; Shift Clock
            CLR     MAX_CLOCK
            DJNZ    R2,SHF_MAX2
            SETB    MAX_LOAD                ; Latch Data
            CLR     MAX_LOAD
            RET

;/*************************/;
;/* Table of Display Code */;
;/*    Dp A B C D E F G   */;
;/*    D7 ...........D0   */;
;/*************************/;
;
TAB_SEG:    DB      7EH,30H,6DH,79H         ; 0 1 2 3
            DB      33H,5BH,5FH,70H         ; 4 5 6 7
            DB      7FH,7BH,01H,00H         ; 8 9 -

;/*****************************/;
;/* Display 7-Segment 8-Digit */;
;/* Input : DSP_BUFF (8-Byte) */;
;/*****************************/;
;
DISPLAY:    MOV     R7,#8
            MOV     R1,#08H                 ; Digit 1
            MOV     R0,#DSP_BUFF            ; Buffer digit1
DSP1:       MOV     A,@R0
            ANL     A,#01111111B            ; Ignore Dp
            MOV     DPTR,#TAB_SEG
            MOVC    A,@A+DPTR
            MOV     DPH,R1                  ; Address
            MOV     DPL,A                   ; Data
            MOV     A,@R0
            ANL     A,#10000000B            ; Check Dp
            ORL     A,DPL
            MOV     DPL,A
            LCALL   SHF_MAX
            INC     R0                      ; Next Buffer
            DEC     R1                      ; Next Digit
            DJNZ    R7,DSP1
            RET

            END
