;/**********************************/;
;/* Monitor For Display 14-Segment */;
;/* Files Name  : DSP14EX4.ASM     */;
;/* Board & CPU : AT89C51          */;
;/* (Display 14-Segment / 8-Digit) */;
;/* Assembler   : SXA51            */;
;/* Function    : Move Display Demo*/;
;/**********************************/;
;
;/* Port For Control Display */;
RST_WATCH   EQU     P1.0                    ; Reset Watchdog
DISPLAY1    EQU     P1.1                    ; Latch Display1
DISPLAY2    EQU     P1.2                    ; Latch Display2
GATE_DSP    EQU     P1.3                    ; Enable Display

            ORG     20H                     ; Internal RAM of CPU
DSP_BUFF:   DS      8                       ; Display Buffer
SCAN_CNT:   DS      1
SCAN_BUF:   DS      1
DIG_BUFF:   DS      1
MOVE_CNT:   DS      1
MOVE_INX:   DS      1
STACK:      DS      32
            
            ORG     0000H                   ; Reset Vector of CPU
            LJMP    MAIN
            ORG     000BH                   ; Timer0 Vector Interupt
            LJMP    SCAN_DSP
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     P0,#000H
            MOV     P1,#0FFH
            MOV     P2,#000H
            ;
            MOV     A,#0FDH                 ; Set Baud rate 9600
            MOV     TH1,A
            MOV     TL1,A
            MOV     TMOD,#00100001B         ; Timer1 Mode2 & Timer0 Mode1
            SETB    ET0                     ; Enable Timer0 Interupt
            CLR     ET1                     ; Disable Timer1 Interupt
            CLR     ES                      ; Disable Serial Interupt
            SETB    TR1                     ; Set timer1 control
            MOV     SCON,#01010000B         ; Serial Port Mode 1
            MOV     TH0,#0FCH               ; 1 milliSec Period For Timer0
            MOV     TL0,#066H
            MOV     SCAN_CNT,#08H           ; Scan Count = 8-Digit
            MOV     SCAN_BUF,#01H           ; Scan ULN2803 = Colum0
            MOV     DIG_BUFF,#DSP_BUFF      ; Display Buffer = DG-0
            SETB    TR0                     ; Strat Timer0
            SETB    EA                      ; Enable Global Interupt
            ;
            MOV     R2,#8
            MOV     R0,#DSP_BUFF
            MOV     A,#0AH
CLR_DSPY:   MOV     @R0,A
            INC     R0
            DJNZ    R2,CLR_DSPY
            MOV     MOVE_CNT,#39
            MOV     MOVE_INX,#00
            ;
MOVE_DSP:   MOV     DPTR,#TAB_MOVE
MOVEDSP1:   MOV     A,MOVE_INX
            MOVC    A,@A+DPTR
            LCALL   CONV_DSP
            INC     MOVE_INX                ; Move Index
            ;
            MOV     R2,#4
DSP_DLY1:   MOV     R3,#00
DSP_DLY2:   MOV     R4,#00
            DJNZ    R4,$
            DJNZ    R3,DSP_DLY2
            DJNZ    R2,DSP_DLY1
            ;
            DJNZ    MOVE_CNT,MOVEDSP1       ; Move Byte Count
            MOV     MOVE_CNT,#39
            MOV     MOVE_INX,#00
            SJMP    MOVE_DSP                ; Loop to Continue
            ;
TAB_MOVE:   DB      '01234567890 ABCDEFGHIJKLMNOPQRSTUVWXYZ'
            DB      '             '

;/****************************/;
;/* Convert ASCII to Display */;
;/* Input : ACC (ASCII Code) */;
;/****************************/;
;
CONV_DSP:   CJNE    A,#20H,CHK_NUM0
            MOV     A,#0AH                  ; Display Space
            LCALL   SHF_BUFF
            SJMP    END_CONV
CHK_NUM0:   CJNE    A,#30H,CHK_NUM1
CHK_NUM1:   JC      END_CONV
            CJNE    A,#40H,CHK_NUM2
CHK_NUM2:   JNC     CHK_CHR1
            ANL     A,#0FH                  ; Convert 0-9 to Display
            LCALL   SHF_BUFF
            SJMP    END_CONV
CHK_CHR1:   CJNE    A,#'A',CHK_CHR2
CHK_CHR2:   JC      END_CONV
            CJNE    A,#'Z'+1,CHK_CHR3
CHK_CHR3:   JNC     CHK_CHR4
            CLR     CY
            SUBB    A,#36H                  ; Convert A-Z to Display
            LCALL   SHF_BUFF
            SJMP    END_CONV
CHK_CHR4:   CJNE    A,#'a',CHK_CHR5
CHK_CHR5:   JC      END_CONV
            CJNE    A,#'z'+1,CHK_CHR6
CHK_CHR6:   JNC     END_CONV
            CLR     CY
            SUBB    A,#56H                  ; Convert a-z to Display
            LCALL   SHF_BUFF
END_CONV:   RET

;/*********************/;
;/* Shift Left Buffer */;
;/*   DSP_BUFF+0..7   */;
;/* MSB <- LSB <- ACC */;
;/*********************/;
;
SHF_BUFF:   PUSH    ACC
            MOV     R0,#DSP_BUFF+0
            MOV     R1,#DSP_BUFF+1
            MOV     R2,#7
SHF_BUF1:   MOV     A,@R1
            MOV     @R0,A
            INC     R0
            INC     R1
            DJNZ    R2,SHF_BUF1
            POP     ACC
            MOV     @R0,A
            RET

;/*****************************/;
;/* Timer0 : Service Routines */;
;/* Interupt Every 1 milliSec */;
;/* Scan Display on Interrupt */;
;/* Display 7-Segment 8-Digit */;
;/* Input : DSP_BUFF (8-Byte) */;
;/*       : DIG_BUFF (^DSP8)  */;
;/*       : SCAN_BUF (Colum)  */;
;/*       : SCAN_CNT (Count)  */;
;/*****************************/;
;
SCAN_DSP:   PUSH    PSW                     ; Save Register
            PUSH    DPH
            PUSH    DPL
            PUSH    ACC
            PUSH    B
            SETB    RS0                     ; Select Register Bank-1
            ;
            MOV     TH0,#0FCH               ; 1 milliSec Auto Reload
            MOV     TL0,#066H
            MOV     R0,DIG_BUFF             ; Buffer Display Code
            ;
SCAN_DS1:   SETB    GATE_DSP                ; Disable Data Display
            MOV     P2,#00H                 ; Disable Colum Display
            MOV     DPTR,#TAB_14SEG
            MOV     A,@R0
            MOV     B,#2                    ; 2 Byte / 1 Code
            MUL     AB
            MOV     B,A                     ; Save Pointer
            MOVC    A,@A+DPTR               ; Get High Byte From Table
            MOV     P0,A
            CLR     DISPLAY2                ; Latch High Byte Display
            SETB    DISPLAY2
            MOV     A,B                     ; Get Pointer
            INC     A                       ; Adjust to Low Byte
            MOVC    A,@A+DPTR               ; Get Low Byte From Table
            MOV     P0,A
            CLR     DISPLAY1                ; Latch Low Byte Display
            SETB    DISPLAY1
            MOV     P2,SCAN_BUF             ; Scan Display
            CLR     GATE_DSP                ; Enable Scan Display
            ;
            INC     DIG_BUFF                ; Next Digit Scan
            MOV     A,SCAN_BUF
            RL      A
            MOV     SCAN_BUF,A
            DJNZ    SCAN_CNT,SCAN_DS2
            MOV     SCAN_CNT,#08H           ; Scan Count = 8-Digit
            MOV     SCAN_BUF,#01H           ; Scan ULN2803 = Colum0
            MOV     DIG_BUFF,#DSP_BUFF      ; Display Buffer = DG-0
            ;
SCAN_DS2:   POP     B
            POP     ACC
            POP     DPL
            POP     DPH
            POP     PSW
            RETI

;/*************************/;
;/*           A            /;
;/*        -------         /;
;/*      | I  J  K |       /;
;/*    F |  \ | /  | B     /;
;/*      |   ...   |       /;
;/*        -G- -H-         /;
;/*      |   ...   |       /;
;/*    E |  / | \  | C     /;
;/*      | L  M  N |       /;
;/*        -------   **    /;
;/*           D      Dp    /;
;/*                        /;
;/*************************/;
;/* Table of Display Code */;
;/* 1st Byte = High Byte  */;
;/* 2nd Byte = Low Byte   */;
;/* Hi = Dp x N M L K J I */;
;/* Lo =  H G F E D C B A */;
;/* Data D7 ...........D0 */;
;/* Data in This Table is */;
;/* Hi1,Lo1,Hi2,Lo2.....  */;
;/*************************/;
;
TAB_14SEG:  DB      00CH,03FH,000H,006H     ; 0     1
            DB      008H,08BH,000H,08FH     ; 2     3
            DB      000H,0E6H,020H,069H     ; 4     5
            DB      000H,0FDH,00CH,001H     ; 6     7
            DB      000H,0FFH,000H,0EFH     ; 8     9
            DB      000H,000H,000H,0F7H     ; Sp    A
            DB      012H,08FH,000H,039H     ; B     C
            DB      012H,00FH,000H,079H     ; D     E
            DB      000H,071H,000H,0BDH     ; F     G
            DB      000H,0F6H,012H,009H     ; H     I
            DB      000H,01EH,024H,070H     ; J     K
            DB      000H,038H,005H,036H     ; L     M
            DB      021H,036H,000H,03FH     ; N     O
            DB      000H,0F3H,020H,03FH     ; P     Q
            DB      020H,0F3H,000H,0EDH     ; R     S
            DB      012H,001H,000H,03EH     ; T     U
            DB      00CH,030H,028H,036H     ; V     W
            DB      02DH,000H,015H,000H     ; X     Y
            DB      00CH,009H               ; Z

;/*********************/;
;/** Reset Watch-Dog **/;
;/*********************/;
;
WATCHDOG:   CLR     RST_WATCH               ; Reset Watch-Dog
            SETB    RST_WATCH               ; Enable Watch-Dog
            RET

            END
            
