;/**********************************/;
;/* Monitor For Display 14-Segment */;
;/* Files Name  : DSP14EX2.ASM     */;
;/* Board & CPU : AT89C51          */;
;/* (Display 14-Segment / 8-Digit) */;
;/* Assembler   : SXA51            */;
;/* Function    : Scan Display 8DG */;
;/*             : By Timer Interupt*/;
;/**********************************/;
;
;/* Port For Control Display */;
RST_WATCH   EQU     P1.0                    ; Reset Watchdog
DISPLAY1    EQU     P1.1                    ; Latch Display1
DISPLAY2    EQU     P1.2                    ; Latch Display2
GATE_DSP    EQU     P1.3                    ; Enable Display

            ORG     20H                     ; Internal RAM of CPU
DSP_BUFF:   DS      8                       ; Display Buffer
SCAN_CNT:   DS      1
SCAN_BUF:   DS      1
DIG_BUFF:   DS      1
STACK:      DS      32

            ORG     0000H                   ; Reset Vector of CPU
            LJMP    MAIN
            ORG     000BH                   ; Timer0 Vector Interupt
            LJMP    SCAN_DSP
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     P0,#000H
            MOV     P1,#0FFH
            MOV     P2,#000H
            ;
            MOV     TMOD,#00000001B         ; Timer0 Mode1 (16bit)
            SETB    ET0                     ; Enable Timer0 Interupt
            MOV     TH0,#0FCH               ; 1 milliSec Period For Timer0
            MOV     TL0,#066H
            ;
            MOV     SCAN_CNT,#08H           ; Scan Count = 8-Digit
            MOV     SCAN_BUF,#01H           ; Scan ULN2803 = Colum0
            MOV     DIG_BUFF,#DSP_BUFF      ; Display Buffer = DG-0
            SETB    TR0                     ; Strat Timer0
            SETB    EA                      ; Enable Global Interupt
            ;
            MOV     DSP_BUFF+0,#14          ; D
            MOV     DSP_BUFF+1,#29          ; S
            MOV     DSP_BUFF+2,#26          ; P
            MOV     DSP_BUFF+3,#1           ; 1
            MOV     DSP_BUFF+4,#4           ; 4
            MOV     DSP_BUFF+5,#29          ; S
            MOV     DSP_BUFF+6,#15          ; E
            MOV     DSP_BUFF+7,#17          ; G
            SJMP    $

;/*****************************/;
;/* Timer0 : Service Routines */;
;/* Interupt Every 1 milliSec */;
;/* Scan Display on Interrupt */;
;/* Display 7-Segment 8-Digit */;
;/* Input : DSP_BUFF (8-Byte) */;
;/*       : DIG_BUFF (^DSP8)  */;
;/*       : SCAN_BUF (Colum)  */;
;/*       : SCAN_CNT (Count)  */;
;/*****************************/;
;
SCAN_DSP:   PUSH    PSW                     ; Save Register
            PUSH    DPH
            PUSH    DPL
            PUSH    ACC
            PUSH    B
            SETB    RS0                     ; Select Register Bank-1
            ;
            MOV     TH0,#0FCH               ; 1 milliSec Auto Reload
            MOV     TL0,#066H
            MOV     R0,DIG_BUFF             ; Buffer Display Code
            ;
SCAN_DS1:   SETB    GATE_DSP                ; Disable Data Display
            MOV     P2,#00H                 ; Disable Colum Display
            MOV     DPTR,#TAB_14SEG
            MOV     A,@R0
            MOV     B,#2                    ; 2 Byte / 1 Code
            MUL     AB
            MOV     B,A                     ; Save Pointer
            MOVC    A,@A+DPTR               ; Get High Byte From Table
            MOV     P0,A
            CLR     DISPLAY2                ; Latch High Byte Display
            SETB    DISPLAY2
            MOV     A,B                     ; Get Pointer
            INC     A                       ; Adjust to Low Byte
            MOVC    A,@A+DPTR               ; Get Low Byte From Table
            MOV     P0,A
            CLR     DISPLAY1                ; Latch Low Byte Display
            SETB    DISPLAY1
            MOV     P2,SCAN_BUF             ; Scan Display
            CLR     GATE_DSP                ; Enable Scan Display
            ;
            INC     DIG_BUFF                ; Next Digit Scan
            MOV     A,SCAN_BUF
            RL      A
            MOV     SCAN_BUF,A
            DJNZ    SCAN_CNT,SCAN_DS2
            MOV     SCAN_CNT,#08H           ; Scan Count = 8-Digit
            MOV     SCAN_BUF,#01H           ; Scan ULN2803 = Colum0
            MOV     DIG_BUFF,#DSP_BUFF      ; Display Buffer = DG-0
            ;
SCAN_DS2:   POP     B
            POP     ACC
            POP     DPL
            POP     DPH
            POP     PSW
            RETI

;/*************************/;
;/*           A            /;
;/*        -------         /;
;/*      | I  J  K |       /;
;/*    F |  \ | /  | B     /;
;/*      |   ...   |       /;
;/*        -G- -H-         /;
;/*      |   ...   |       /;
;/*    E |  / | \  | C     /;
;/*      | L  M  N |       /;
;/*        -------   **    /;
;/*           D      Dp    /;
;/*                        /;
;/*************************/;
;/* Table of Display Code */;
;/* 1st Byte = High Byte  */;
;/* 2nd Byte = Low Byte   */;
;/* Hi = Dp x N M L K J I */;
;/* Lo =  H G F E D C B A */;
;/* Data D7 ...........D0 */;
;/* Data in This Table is */;
;/* Hi1,Lo1,Hi2,Lo2.....  */;
;/*************************/;
;
TAB_14SEG:  DB      00CH,03FH,000H,006H     ; 0     1
            DB      008H,08BH,000H,08FH     ; 2     3
            DB      000H,0E6H,020H,069H     ; 4     5
            DB      000H,0FDH,00CH,001H     ; 6     7
            DB      000H,0FFH,000H,0EFH     ; 8     9
            DB      000H,000H,000H,0F7H     ; Sp    A
            DB      012H,08FH,000H,039H     ; B     C
            DB      012H,00FH,000H,079H     ; D     E
            DB      000H,071H,000H,0BDH     ; F     G
            DB      000H,0F6H,012H,009H     ; H     I
            DB      000H,01EH,024H,070H     ; J     K
            DB      000H,038H,005H,036H     ; L     M
            DB      021H,036H,000H,03FH     ; N     O
            DB      000H,0F3H,020H,03FH     ; P     Q
            DB      020H,0F3H,000H,0EDH     ; R     S
            DB      012H,001H,000H,03EH     ; T     U
            DB      00CH,030H,028H,036H     ; V     W
            DB      02DH,000H,015H,000H     ; X     Y
            DB      00CH,009H               ; Z

;/*********************/;
;/** Reset Watch-Dog **/;
;/*********************/;
;
WATCHDOG:   CLR     RST_WATCH               ; Reset Watch-Dog
            SETB    RST_WATCH               ; Enable Watch-Dog
            RET

            END

