;/**********************************/;
;/* Example For Display 14-Segment */;
;/* Files Name  : DSP14EX1.ASM     */;
;/* Board & CPU : AT89C51          */;
;/* (Display 14-Segment / 8-Digit) */;
;/* Assembler   : SXA51            */;
;/* Function    : Scan Display 8DG */;
;/*             : Pooling Mode     */;
;/**********************************/;
;
;/* Port For Control Display */;
RST_WATCH   EQU     P1.0                    ; Reset Watchdog
DISPLAY1    EQU     P1.1                    ; Latch Display1
DISPLAY2    EQU     P1.2                    ; Latch Display2
GATE_DSP    EQU     P1.3                    ; Enable Display

            ORG     20H                     ; Internal RAM of CPU
DSP_BUFF:   DS      8                       ; Display Buffer
STACK:      DS      32

            ORG     0000H                   ; Reset Vector of CPU
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     P0,#000H
            MOV     P1,#0FFH
            MOV     P2,#000H
            ;
            MOV     DSP_BUFF+0,#0           ; Display Number 0
            MOV     DSP_BUFF+1,#1           ; Display Number 1
            MOV     DSP_BUFF+2,#2           ; Display Number 2
            MOV     DSP_BUFF+3,#3           ; Display Number 3
            MOV     DSP_BUFF+4,#4           ; Display Number 4
            MOV     DSP_BUFF+5,#5           ; Display Number 5
            MOV     DSP_BUFF+6,#6           ; Display Number 6
            MOV     DSP_BUFF+7,#7           ; Display Number 7
            ;
SCAN_DSP:   MOV     R0,#DSP_BUFF            ; Buffer Display Code
            MOV     R1,#00000001B           ; Data For Scan Digit
            MOV     R2,#8                   ; 8 Digit Count Scan Display
            ;
SCAN_DS1:   SETB    GATE_DSP                ; Disable Data Display
            MOV     P2,#00H                 ; Disable Colum Display
            MOV     DPTR,#TAB_14SEG
            MOV     A,@R0
            MOV     B,#2                    ; 2 Byte / 1 Code
            MUL     AB
            MOV     B,A                     ; Save Pointer
            MOVC    A,@A+DPTR               ; Get High Byte From Table
            MOV     P0,A
            CLR     DISPLAY2                ; Latch High Byte Display
            SETB    DISPLAY2
            MOV     A,B                     ; Get Pointer
            INC     A                       ; Adjust to Low Byte
            MOVC    A,@A+DPTR               ; Get Low Byte From Table
            MOV     P0,A
            CLR     DISPLAY1                ; Latch Low Byte Display
            SETB    DISPLAY1
            MOV     P2,R1                   ; Scan Display
            CLR     GATE_DSP                ; Enable Scan Display
            ;
            MOV     R3,#0                   ; Delay Scan Display
            DJNZ    R3,$
            ;
            INC     R0                      ; Next Digit Data Code
            MOV     A,R1
            RL      A                       ; Next Digit Display
            MOV     R1,A
            DJNZ    R2,SCAN_DS1
            SJMP    SCAN_DSP                ; Loop Scan Display

;/*************************/;
;/*           A            /;
;/*        -------         /;
;/*      | I  J  K |       /;
;/*    F |  \ | /  | B     /;
;/*      |   ...   |       /;
;/*        -G- -H-         /;
;/*      |   ...   |       /;
;/*    E |  / | \  | C     /;
;/*      | L  M  N |       /;
;/*        -------   **    /;
;/*           D      Dp    /;
;/*                        /;
;/*************************/;
;/* Table of Display Code */;
;/* 1st Byte = High Byte  */;
;/* 2nd Byte = Low Byte   */;
;/* Hi = Dp x N M L K J I */;
;/* Lo =  H G F E D C B A */;
;/* Data D7 ...........D0 */;
;/* Data in This Table is */;
;/* Hi1,Lo1,Hi2,Lo2.....  */;
;/*************************/;
;
TAB_14SEG:  DB      00CH,03FH,000H,006H     ; 0     1
            DB      008H,08BH,000H,08FH     ; 2     3
            DB      000H,0E6H,020H,069H     ; 4     5
            DB      000H,0FDH,00CH,001H     ; 6     7
            DB      000H,0FFH,000H,0EFH     ; 8     9

            END



