;******************************
;*                            *
;*    SCAN SUBROUTINE         *
;*    ETT CO.,LTD.            *
;*    BOARD      "CP-jr180"   *
;*    ASMPROGRAM "Z180ASM"    *
;*                            *
;******************************
;
;              0C     0D     0E      0F
;   PC4    ------X------X------X------X
;              08|    09|    0A|    0B|
;   PC5    ------X------X------X------X
;              04|    05|    06|    07|
;   PC6    ------X------X------X------X
;              00|    01|    02|    03|
;   PC7    ------X------X------X------X
;                |      |      |      |
;   PC0    ______|      |      |      |
;   PC1    _____________|      |      |
;   PC2    ____________________|      |
;   PC3    ___________________________|
;
;         KEY CODE IN REG. A
;
;********************************
;
         .EQU  PA,80H
         .EQU  PB,81H
         .EQU  PC,82H
         .EQU  PCC,83H
         .EQU  CONTSYS,8AH   ;PA=OUT ,PB=IN
                             ;PC-LO=OUT,PC-HI=IN
;
START:    LD   A,CONTSYS
          OUT  (PCC),A
;
; CALL SCAN  REG A=KEYCODE
;
SCAN:     LD   B,4
          LD   C,B
          LD   E,11111110B
;
SCAN_1:   CALL SCANS
          LD   HL,SYSFAG
          IN   A,(PC)
          AND  0F0H
          CP   0F0H
          JP   NZ,SCAN_3
;
          DEC  C
          JP   NZ,SCAN_2
          RES  0,(HL)
SCAN_2:   RLC  E
          DEC  B
          JP   NZ,SCAN_1
;
          JP   SCAN
;
; press key
;
SCAN_3:   BIT  0,(HL)
          JP   NZ,SCAN_2
          OR   B
          PUSH HL
          PUSH BC
          LD   HL,KEYTAB+15
          LD   B,15
          CALL PACKT1
          POP  BC
          POP  HL
          LD   D,A
          SET  0,(HL)
          RET                 ;EXIT KEY CODE IN REG A.
;
;************************
;                       *
;   SCAND SUBROUTINE    *
;                       *
;************************
;
SCANK:     LD   B,4
           LD   C,B
           LD   E,11111110B
;
SCANK_1:   CALL SCANS
           LD   HL,SYSFAG
           IN   A,(PC)
           AND  0F0H
           CP   0F0H
           JP   NZ,SCANK_3
;
           DEC  C
           JP   NZ,SCANK_2
           RES  0,(HL)
SCANK_2:   RLC  E
           DEC  B
           JP   NZ,SCANK_1
;
           RET
;
SCANK_3:   OR   B
           PUSH HL
           PUSH BC
           LD   HL,KEYTAB+15
           LD   B,15
           CALL PACKT1
           POP  BC
           POP  HL
           LD   D,A
           RET                 ;exit
;
SCANS:     LD   A,E
           OUT  (PC),A
           XOR  A              ;DELAY
SCANS_1:   NOP
           NOP
           NOP
           DEC  A
           JR   NZ,SCANS_1
           RET
;
PACKT1:    CP   (HL)
           JR   Z,PACKT1_2
           DEC  HL
           DEC  B
           JP   NZ,PACKT1
PACKT1_2:  LD   A,B
           RET
;
KEYTAB:   .DB   0E1H,0E2H,0E3H,0E4H
          .DB   0D1H,0D2H,0D3H,0D4H
          .DB   0B1H,0B2H,0B3H,0B4H
          .DB   71H,72H,73H,74H
;
;    USER  RAM
          .ORG  9000H
SYSFAG:   .RS   1
;
          .END